/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.world.action.item;

import com.craftingdead.core.world.action.Action;
import com.craftingdead.core.world.action.item.BlockItemAction;
import com.craftingdead.core.world.action.item.ItemActionType;
import com.craftingdead.core.world.entity.extension.LivingExtension;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.block.state.BlockState;

public class BlockItemActionType
extends ItemActionType<BlockItemAction> {
    private final Predicate<BlockState> predicate;

    protected BlockItemActionType(Builder builder) {
        super(builder);
        this.predicate = builder.predicate;
    }

    public Predicate<BlockState> getPredicate() {
        return this.predicate;
    }

    @Override
    public void encode(BlockItemAction action, FriendlyByteBuf out) {
        out.m_130068_((Enum)action.getHand());
        out.m_130062_(action.getContext().m_43718_());
    }

    @Override
    public BlockItemAction decode(LivingExtension<?, ?> performer, FriendlyByteBuf in) {
        return new BlockItemAction((InteractionHand)in.m_130066_(InteractionHand.class), this, performer, in.m_130283_());
    }

    @Override
    public Optional<Action> createBlockAction(LivingExtension<?, ?> performer, UseOnContext context) {
        return Optional.of(new BlockItemAction(this, performer, context));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends ItemActionType.Builder<Builder> {
        private Predicate<BlockState> predicate;

        public Builder forBlock(Predicate<BlockState> predicate) {
            this.predicate = predicate;
            return this;
        }

        public BlockItemActionType build() {
            return new BlockItemActionType(this);
        }
    }
}

