/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.world.action.item;

import com.craftingdead.core.world.action.ActionObserver;
import com.craftingdead.core.world.action.ProgressBar;
import com.craftingdead.core.world.action.item.BlockItemActionType;
import com.craftingdead.core.world.action.item.ItemAction;
import com.craftingdead.core.world.action.item.ItemActionType;
import com.craftingdead.core.world.entity.extension.LivingExtension;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class BlockItemAction
extends ItemAction {
    private final BlockItemActionType type;
    private final LivingExtension<?, ?> performer;
    private final UseOnContext context;
    private BlockState blockState;

    protected BlockItemAction(BlockItemActionType type, LivingExtension<?, ?> performer, UseOnContext context) {
        super(context.m_43724_());
        this.type = type;
        this.performer = performer;
        this.context = context;
    }

    protected BlockItemAction(InteractionHand hand, BlockItemActionType type, LivingExtension<?, ?> performer, BlockHitResult hitResult) {
        super(hand);
        Player player;
        this.type = type;
        this.performer = performer;
        Object obj = performer.getEntity();
        this.context = new UseOnContext(performer.getLevel(), obj instanceof Player ? (player = (Player)obj) : null, hand, performer.getEntity().m_21120_(hand), hitResult);
    }

    public UseOnContext getContext() {
        return this.context;
    }

    public BlockState getBlockState() {
        return this.blockState;
    }

    @Override
    public ActionObserver createPerformerObserver() {
        return ActionObserver.create(this, ProgressBar.create(this.getType(), null, this::getProgress));
    }

    @Override
    public boolean start(boolean simulate) {
        this.blockState = this.performer.getLevel().m_8055_(this.context.m_8083_());
        return super.start(simulate) && this.type.getPredicate().test(this.blockState);
    }

    @Override
    public boolean tick() {
        if (!this.performer.getLevel().m_5776_() && this.performer.getEntity().m_20238_(Vec3.m_82512_((Vec3i)this.context.m_8083_())) > 64.0) {
            this.performer.cancelAction(true);
            return false;
        }
        return super.tick();
    }

    @Override
    public LivingExtension<?, ?> getPerformer() {
        return this.performer;
    }

    @Override
    public ItemActionType<?> getType() {
        return this.type;
    }
}

