/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.world.action;

import com.craftingdead.core.world.action.ActionType;
import com.craftingdead.core.world.action.RemoveMagazineAction;
import com.craftingdead.core.world.action.SimpleActionType;
import com.craftingdead.core.world.action.TargetSelector;
import com.craftingdead.core.world.action.item.EntityItemActionType;
import com.craftingdead.core.world.action.reload.MagazineReloadAction;
import com.craftingdead.core.world.action.reload.RefillableReloadAction;
import com.craftingdead.core.world.effect.ModMobEffects;
import com.craftingdead.core.world.entity.extension.PlayerExtension;
import com.craftingdead.core.world.item.ModItems;
import com.google.common.base.Predicates;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryBuilder;
import net.minecraftforge.registries.RegistryObject;

public class ActionTypes {
    public static final ResourceKey<Registry<ActionType<?>>> REGISTRY_KEY = ResourceKey.m_135788_((ResourceLocation)new ResourceLocation("craftingdead", "action_type"));
    public static final DeferredRegister<ActionType<?>> deferredRegister = DeferredRegister.create(REGISTRY_KEY, (String)"craftingdead");
    public static final Supplier<IForgeRegistry<ActionType<?>>> REGISTRY = deferredRegister.makeRegistry(ActionType.class, RegistryBuilder::new);
    public static final RegistryObject<ActionType<?>> MAGAZINE_RELOAD = deferredRegister.register("magazine_reload", () -> new SimpleActionType<MagazineReloadAction>(MagazineReloadAction::new, true));
    public static final RegistryObject<ActionType<?>> REFILLABLE_RELOAD = deferredRegister.register("refillable_reload", () -> new SimpleActionType<RefillableReloadAction>(RefillableReloadAction::new, true));
    public static final RegistryObject<ActionType<?>> REMOVE_MAGAZINE = deferredRegister.register("remove_magazine", () -> new SimpleActionType<RemoveMagazineAction>(RemoveMagazineAction::new, true));
    public static final RegistryObject<EntityItemActionType<?>> USE_SYRINGE = deferredRegister.register("use_syringe", () -> ((EntityItemActionType.Builder)((EntityItemActionType.Builder)((EntityItemActionType.Builder)EntityItemActionType.builder((performer, target) -> {
        if (target == null || performer == target || target.getEntity() instanceof Skeleton) {
            return Optional.empty();
        }
        Object targetEntity = target.getEntity();
        if (targetEntity.m_21223_() > 4.0f) {
            return Optional.ofNullable(target);
        }
        Object patt3783$temp = performer.getEntity();
        if (patt3783$temp instanceof Player) {
            Player player = (Player)patt3783$temp;
            player.m_5661_((Component)new TranslatableComponent("message.low_health", new Object[]{targetEntity.m_5446_()}).m_130940_(ChatFormatting.RED), true);
        }
        return Optional.empty();
    }).forItem((Supplier<Item>)ModItems.SYRINGE)).duration(16)).customAction((performer, target) -> target.getEntity().m_6469_(DamageSource.m_19370_(target.getEntity()), 2.0f), 1.0f).returnItem((Supplier<Item>)ModItems.BLOOD_SYRINGE)).build());
    public static final RegistryObject<EntityItemActionType<?>> USE_FIRST_AID_KIT = deferredRegister.register("use_first_aid_kit", () -> ((EntityItemActionType.Builder)((EntityItemActionType.Builder)EntityItemActionType.builder(TargetSelector.SELF_OR_OTHERS).forItem((Supplier<Item>)ModItems.FIRST_AID_KIT)).setFreezeMovement(true)).effect(() -> new MobEffectInstance(MobEffects.f_19601_, 1, 1)).build());
    public static final RegistryObject<EntityItemActionType<?>> USE_ADRENALINE_SYRINGE = deferredRegister.register("use_adrenaline_syringe", () -> ((EntityItemActionType.Builder)((EntityItemActionType.Builder)((EntityItemActionType.Builder)((EntityItemActionType.Builder)EntityItemActionType.builder(TargetSelector.SELF_OR_OTHERS).forItem((Supplier<Item>)ModItems.ADRENALINE_SYRINGE)).duration(16)).returnItem((Supplier<? extends Item>)ModItems.SYRINGE)).useResultItemInCreative(false)).effect(() -> new MobEffectInstance((MobEffect)ModMobEffects.ADRENALINE.get(), 400, 1)).build());
    public static final RegistryObject<EntityItemActionType<?>> USE_BLOOD_SYRINGE = deferredRegister.register("use_blood_syringe", () -> ((EntityItemActionType.Builder)((EntityItemActionType.Builder)((EntityItemActionType.Builder)((EntityItemActionType.Builder)EntityItemActionType.builder(TargetSelector.SELF_OR_OTHERS).forItem((Supplier<Item>)ModItems.BLOOD_SYRINGE)).duration(16)).returnItem((Supplier<? extends Item>)ModItems.SYRINGE)).useResultItemInCreative(false)).effect(() -> new MobEffectInstance(MobEffects.f_19601_, 1, 0)).build());
    public static final RegistryObject<EntityItemActionType<?>> USE_BANDAGE = deferredRegister.register("use_bandage", () -> ((EntityItemActionType.Builder)((EntityItemActionType.Builder)EntityItemActionType.builder(TargetSelector.SELF_OR_OTHERS).forItem((Supplier<Item>)ModItems.BANDAGE)).duration(16)).effect(() -> new MobEffectInstance(MobEffects.f_19601_, 1, 0)).build());
    public static final RegistryObject<EntityItemActionType<?>> APPLY_HANDCUFFS = deferredRegister.register("apply_handcuffs", () -> ((EntityItemActionType.Builder)EntityItemActionType.builder(TargetSelector.OTHERS_ONLY.players().filter((Predicate<PlayerExtension<?>>)Predicates.not(PlayerExtension::isHandcuffed))).forItem((Supplier<Item>)ModItems.HANDCUFFS)).customAction((performer, target) -> {
        target.setHandcuffs(performer.getMainHandItem().m_41777_());
        ((Player)target.getEntity()).m_5661_((Component)new TranslatableComponent("handcuffs.handcuffed", new Object[]{performer.getEntity().m_5446_()}).m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD}), true);
    }, 1.0f).build());
}

