/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.mixin;

import com.craftingdead.core.CraftingDead;
import com.craftingdead.core.world.entity.extension.LivingExtension;
import com.craftingdead.core.world.entity.extension.PlayerExtension;
import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemRenderer.class})
public abstract class ItemRendererMixin {
    @Inject(at={@At(value="HEAD")}, method={"render(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/client/renderer/block/model/ItemTransforms$TransformType;ZLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;IILnet/minecraft/client/resources/model/BakedModel;)V"}, cancellable=true)
    private void render(ItemStack itemStack, ItemTransforms.TransformType transformType, boolean leftHanded, PoseStack matrixStack, MultiBufferSource renderTypeBuffer, int packedLight, int packedOverlay, BakedModel bakedModel, CallbackInfo callbackInfo) {
        if (CraftingDead.getInstance().getClientDist().getItemRendererManager().renderItem(itemStack, transformType, null, matrixStack, renderTypeBuffer, packedLight, packedOverlay)) {
            callbackInfo.cancel();
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"renderStatic(Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/client/renderer/block/model/ItemTransforms$TransformType;ZLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;Lnet/minecraft/world/level/Level;III)V"}, cancellable=true)
    private void renderStatic(@Nullable LivingEntity livingEntity, ItemStack itemStack, ItemTransforms.TransformType transformType, boolean leftHanded, PoseStack matrixStack, MultiBufferSource renderTypeBuffer, @Nullable Level world, int packedLight, int packedOverlay, int value, CallbackInfo callbackInfo) {
        PlayerExtension player;
        LivingExtension living;
        LivingExtension livingExtension = living = livingEntity == null ? null : (LivingExtension)livingEntity.getCapability(LivingExtension.CAPABILITY).orElse(null);
        if (living instanceof PlayerExtension && (player = (PlayerExtension)living).isHandcuffed() || CraftingDead.getInstance().getClientDist().getItemRendererManager().renderItem(itemStack, transformType, living, matrixStack, renderTypeBuffer, packedLight, packedOverlay)) {
            callbackInfo.cancel();
        }
    }
}

