/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.data.recipes;

import com.craftingdead.core.world.item.crafting.ModRecipeSerializers;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class UpgradeMagazineRecipeBuilder {
    private final Ingredient magazine;
    private final Item nextTier;
    private final Advancement.Builder advancement = Advancement.Builder.m_138353_();
    private String group;

    private UpgradeMagazineRecipeBuilder(Ingredient magazine, Item nextTier) {
        this.magazine = magazine;
        this.nextTier = nextTier;
    }

    public static UpgradeMagazineRecipeBuilder create(Ingredient magazine, Item nextTier) {
        return new UpgradeMagazineRecipeBuilder(magazine, nextTier);
    }

    public UpgradeMagazineRecipeBuilder unlockedBy(String id, CriterionTriggerInstance criterion) {
        this.advancement.m_138386_(id, criterion);
        return this;
    }

    public UpgradeMagazineRecipeBuilder group(String group) {
        this.group = group;
        return this;
    }

    public void save(Consumer<FinishedRecipe> consumer) {
        this.save(consumer, ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this.nextTier));
    }

    public void save(Consumer<FinishedRecipe> consumer, String id) {
        ResourceLocation resourcelocation = ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this.nextTier);
        if (new ResourceLocation(id).equals((Object)resourcelocation)) {
            throw new IllegalStateException("Shapeless Recipe " + id + " should remove its 'save' argument");
        }
        this.save(consumer, new ResourceLocation(id));
    }

    public void save(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        this.ensureValid(id);
        this.advancement.m_138396_(new ResourceLocation("recipes/root")).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)id)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)id)).m_138360_(RequirementsStrategy.f_15979_);
        consumer.accept(new Result(id, this.nextTier, this.group == null ? "" : this.group, this.magazine, this.advancement, new ResourceLocation(id.m_135827_(), "recipes/" + this.nextTier.m_41471_().m_40783_() + "/" + id.m_135815_())));
    }

    private void ensureValid(ResourceLocation id) {
        if (this.advancement.m_138405_().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + id);
        }
    }

    public static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final Item nextTier;
        private final String group;
        private final Ingredient magazine;
        private final Advancement.Builder advancement;
        private final ResourceLocation advancementId;

        public Result(ResourceLocation id, Item nextTier, String group, Ingredient magazine, Advancement.Builder advancement, ResourceLocation advancementId) {
            this.id = id;
            this.nextTier = nextTier;
            this.group = group;
            this.magazine = magazine;
            this.advancement = advancement;
            this.advancementId = advancementId;
        }

        public void m_7917_(JsonObject json) {
            if (!this.group.isEmpty()) {
                json.addProperty("group", this.group);
            }
            json.add("magazine", this.magazine.m_43942_());
            JsonObject nextTierJson = new JsonObject();
            nextTierJson.addProperty("item", ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this.nextTier).toString());
            json.add("nextTier", (JsonElement)nextTierJson);
        }

        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)ModRecipeSerializers.UPGRADE_MAGAZINE.get();
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        @Nullable
        public JsonObject m_5860_() {
            return this.advancement.m_138400_();
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return this.advancementId;
        }
    }
}

