/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.client.renderer.item;

import com.craftingdead.core.client.renderer.item.CustomItemRenderer;
import com.craftingdead.core.client.renderer.item.ItemRendererProperties;
import com.craftingdead.core.client.renderer.item.ItemRendererType;
import com.craftingdead.core.client.renderer.item.ItemRendererTypes;
import com.craftingdead.core.world.entity.extension.LivingExtension;
import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fml.StartupMessageManager;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IRegistryDelegate;
import org.slf4j.Logger;

public class ItemRenderDispatcher
implements ResourceManagerReloadListener {
    private static final String FILE_EXTENSION = ".json";
    private static final int PATH_SUFFIX_LENGTH = ".json".length();
    private static final String DIRECTORY = "renderers/item";
    private static final Gson gson = new Gson();
    private static final Logger logger = LogUtils.getLogger();
    private final Minecraft minecraft = Minecraft.m_91087_();
    private Map<IRegistryDelegate<Item>, CustomItemRenderer> renderers = Map.of();
    private Map<ResourceLocation, Set<ResourceLocation>> materials = Map.of();

    public Set<ResourceLocation> getTextures(ResourceLocation atlasLocation) {
        return this.materials.getOrDefault(atlasLocation, Collections.emptySet());
    }

    public CustomItemRenderer getItemRenderer(Item item) {
        return this.renderers.get(item.delegate);
    }

    public boolean renderItem(ItemStack itemStack, ItemTransforms.TransformType transformType, @Nullable LivingExtension<?, ?> living, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        CustomItemRenderer renderer = this.renderers.get(itemStack.m_41720_().delegate);
        if (renderer != null && renderer.handlePerspective(itemStack, transformType)) {
            renderer.renderItem(itemStack, transformType, living, poseStack, bufferSource, packedLight, packedOverlay);
            return true;
        }
        return false;
    }

    public Set<ResourceLocation> gatherItemRenderers(ResourceManager resourceManager, ProfilerFiller profiler) {
        logger.debug("Gathering item renderers");
        profiler.m_7242_();
        HashSet<ResourceLocation> modelDependencies = new HashSet<ResourceLocation>();
        ImmutableMap.Builder renderers = ImmutableMap.builder();
        int i = DIRECTORY.length() + 1;
        for (ResourceLocation location : resourceManager.m_6540_(DIRECTORY, file -> file.endsWith(FILE_EXTENSION))) {
            String path = location.m_135815_();
            ResourceLocation pathNoFileExtension = new ResourceLocation(location.m_135827_(), path.substring(i, path.length() - PATH_SUFFIX_LENGTH));
            Item item = (Item)ForgeRegistries.ITEMS.getValue(pathNoFileExtension);
            if (item == null) {
                logger.warn("No matching item for item renderer: {}", (Object)pathNoFileExtension.toString());
                continue;
            }
            try {
                Resource resource = resourceManager.m_142591_(location);
                try {
                    InputStream inputStream = resource.m_6679_();
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
                        profiler.m_6180_(resource.m_7816_());
                        profiler.m_6180_("parse");
                        JsonElement json = (JsonElement)GsonHelper.m_13776_((Gson)gson, (Reader)reader, JsonElement.class);
                        if (json != null) {
                            CustomItemRenderer renderer = ItemRenderDispatcher.tryCreate(item, new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)json));
                            if (renderer != null) {
                                renderers.put((Object)item.delegate, (Object)renderer);
                                modelDependencies.addAll(renderer.getModelDependencies());
                            }
                        } else {
                            logger.error("Couldn't load data file {} from {} as it's null or empty", (Object)pathNoFileExtension, (Object)location);
                        }
                        profiler.m_7238_();
                        profiler.m_7238_();
                    }
                    finally {
                        if (inputStream == null) continue;
                        inputStream.close();
                    }
                }
                finally {
                    if (resource == null) continue;
                    resource.close();
                }
            }
            catch (JsonParseException | IOException | IllegalArgumentException e) {
                logger.error("Couldn't parse data file {} from {}", new Object[]{pathNoFileExtension, location, e});
            }
        }
        this.renderers = renderers.build();
        profiler.m_6180_("materials");
        this.materials = this.renderers.values().stream().map(CustomItemRenderer::getMaterials).flatMap(Collection::stream).collect(Collectors.groupingBy(Material::m_119193_, Collectors.mapping(Material::m_119203_, Collectors.toSet())));
        profiler.m_7238_();
        profiler.m_7241_();
        return modelDependencies;
    }

    private static <I extends Item, P extends ItemRendererProperties, T extends ItemRendererType<I, P>> CustomItemRenderer tryCreate(Item item, Dynamic<?> dynamic) {
        ItemRendererProperties properties = (ItemRendererProperties)ItemRendererProperties.CODEC.parse(dynamic).getOrThrow(false, arg_0 -> ((Logger)logger).error(arg_0));
        ItemRendererType<?, ?> type = properties.getItemRendererType();
        if (type.getItemType().isInstance(item)) {
            return type.create((Item)type.getItemType().cast(item), properties);
        }
        logger.error("Item renderer {} expects item of type: {}", (Object)ItemRendererTypes.getKey(type).get(), (Object)type.getItemType().getName());
        return null;
    }

    public void m_6213_(ResourceManager resourceManager) {
        StartupMessageManager.addModMessage((String)"Refreshing cached models");
        this.renderers.values().forEach(renderer -> renderer.refreshCachedModels(arg_0 -> ((EntityModelSet)this.minecraft.m_167973_()).m_171103_(arg_0)));
    }
}

