/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.client.renderer.item;

import com.craftingdead.core.client.renderer.item.ItemRendererProperties;
import com.craftingdead.core.client.renderer.item.ItemRendererType;
import com.craftingdead.core.client.renderer.item.ItemRendererTypes;
import com.craftingdead.core.client.util.RenderUtil;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Quaternion;
import com.mojang.math.Transformation;
import com.mojang.math.Vector3f;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;

public record GunRendererProperties(ResourceLocation modelLocation, Transformation muzzleFlashTransform, Transformation aimingTransform, Transformation sprintingTransform, Transformation backTransform, Map<ResourceLocation, Transformation> attachementTransforms, Map<ResourceLocation, Transformation> magazineTransforms, Map<HandTransform, Pair<Transformation, Transformation>> handTransforms, List<Pair<ResourceLocation, Transformation>> ironSights) implements ItemRendererProperties
{
    private static final Transformation DEFAULT_SPRINTING_TRANSFORM = new Transformation(new Vector3f(-0.3f, 0.0f, 0.15f), new Quaternion(-20.0f, 40.0f, 0.0f, true), new Vector3f(1.0f, 1.0f, 1.0f), null);
    public static final Codec<GunRendererProperties> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.f_135803_.fieldOf("model").forGetter(t -> t.modelLocation), (App)RenderUtil.TRANSFORMATION_MATRIX_CODEC.fieldOf("muzzle_flash_transform").forGetter(t -> t.muzzleFlashTransform), (App)RenderUtil.TRANSFORMATION_MATRIX_CODEC.optionalFieldOf("aiming_transform", (Object)Transformation.m_121093_()).forGetter(t -> t.aimingTransform), (App)RenderUtil.TRANSFORMATION_MATRIX_CODEC.optionalFieldOf("sprinting_transform", (Object)DEFAULT_SPRINTING_TRANSFORM).forGetter(t -> t.sprintingTransform), (App)RenderUtil.TRANSFORMATION_MATRIX_CODEC.optionalFieldOf("back_transform", (Object)Transformation.m_121093_()).forGetter(t -> t.backTransform), (App)Codec.unboundedMap((Codec)ResourceLocation.f_135803_, RenderUtil.TRANSFORMATION_MATRIX_CODEC).optionalFieldOf("attachement_transforms", Collections.emptyMap()).forGetter(t -> t.attachementTransforms), (App)Codec.unboundedMap((Codec)ResourceLocation.f_135803_, RenderUtil.TRANSFORMATION_MATRIX_CODEC).optionalFieldOf("magazine_transforms", Collections.emptyMap()).forGetter(t -> t.magazineTransforms), (App)Codec.unboundedMap(HandTransform.CODEC, (Codec)Codec.mapPair((MapCodec)RenderUtil.TRANSFORMATION_MATRIX_CODEC.optionalFieldOf("right_hand", (Object)Transformation.m_121093_()), (MapCodec)RenderUtil.TRANSFORMATION_MATRIX_CODEC.optionalFieldOf("left_hand", (Object)Transformation.m_121093_())).codec()).optionalFieldOf("hand_transforms", Collections.emptyMap()).forGetter(t -> t.handTransforms), (App)Codec.compoundList((Codec)ResourceLocation.f_135803_, RenderUtil.TRANSFORMATION_MATRIX_CODEC).optionalFieldOf("iron_sights", Collections.emptyList()).forGetter(t -> t.ironSights)).apply((Applicative)instance, GunRendererProperties::new));

    @Override
    public ItemRendererType<?, ?> getItemRendererType() {
        return ItemRendererTypes.GUN;
    }

    public static enum HandTransform implements StringRepresentable
    {
        HELD_RIGHT_HANDED("held_right_handed"),
        HELD_LEFT_HANDED("held_left_handed"),
        AIMING_RIGHT_HANDED("aiming_right_handed"),
        AIMING_LEFT_HANDED("aiming_left_handed");

        public static final Codec<HandTransform> CODEC;
        private static final Map<String, HandTransform> BY_NAME;
        private final String name;

        private HandTransform(String name) {
            this.name = name;
        }

        public String m_7912_() {
            return this.name;
        }

        public static HandTransform byName(String name) {
            return BY_NAME.get(name);
        }

        static {
            CODEC = StringRepresentable.m_14350_(HandTransform::values, HandTransform::byName);
            BY_NAME = Arrays.stream(HandTransform.values()).collect(Collectors.toMap(HandTransform::m_7912_, Function.identity()));
        }
    }
}

