/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.client.renderer.item;

import com.craftingdead.core.capability.CapabilityUtil;
import com.craftingdead.core.client.model.geom.ModModelLayers;
import com.craftingdead.core.client.renderer.item.CustomItemRenderer;
import com.craftingdead.core.client.renderer.item.GunRendererProperties;
import com.craftingdead.core.client.renderer.item.ItemRendererType;
import com.craftingdead.core.client.renderer.item.ItemRendererTypes;
import com.craftingdead.core.util.EasingFunction;
import com.craftingdead.core.world.entity.extension.LivingExtension;
import com.craftingdead.core.world.item.GunItem;
import com.craftingdead.core.world.item.gun.Gun;
import com.craftingdead.core.world.item.gun.attachment.Attachment;
import com.craftingdead.core.world.item.gun.attachment.Attachments;
import com.craftingdead.core.world.item.gun.skin.Paint;
import com.craftingdead.core.world.item.scope.Scope;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Transformation;
import com.mojang.math.Vector3f;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.model.ForgeModelBakery;
import net.minecraftforge.client.model.SimpleModelState;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.model.TransformationHelper;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class GunRenderer
implements CustomItemRenderer {
    private static final Pair<Transformation, Transformation> IDENTITY_HAND_TRANSFORMS = Pair.of((Object)Transformation.m_121093_(), (Object)Transformation.m_121093_());
    private static final String GUN_TEXTURE_REFERENCE = "gun";
    private static final int FLASH_TEXTURE_CHANGE_TIMEOUT_MS = 250;
    private static final int SPRINT_TRANSITION_MS = 300;
    private static final int AIMING_TRANSITION_MS = 200;
    private static final Random random = new Random();
    private final Minecraft minecraft = Minecraft.m_91087_();
    private final Map<Integer, BakedModel> cachedModels = new Int2ObjectOpenHashMap();
    private final GunItem item;
    private final GunRendererProperties properties;
    private ModelPart muzzleFlashModel;
    private long lastFlashTime = 0L;
    private long sprintStartTimeMs;
    private boolean wasSprinting;
    private long aimingStartTimeMs;
    private boolean wasAiming;

    public GunRenderer(GunItem item, GunRendererProperties properties) {
        this.item = item;
        this.properties = properties;
    }

    @Override
    public void rotateCamera(ItemStack itemStack, LivingEntity livingEntity, float partialTicks, Vector3f rotations) {
        Gun gun = CapabilityUtil.getOrThrow(Gun.CAPABILITY, (ICapabilityProvider)itemStack, Gun.class);
        gun.getClient().getAnimationController().applyCamera(partialTicks, rotations);
    }

    @Override
    public boolean handlePerspective(ItemStack item, ItemTransforms.TransformType transformType) {
        return switch (transformType) {
            case ItemTransforms.TransformType.THIRD_PERSON_LEFT_HAND, ItemTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, ItemTransforms.TransformType.FIRST_PERSON_LEFT_HAND, ItemTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, ItemTransforms.TransformType.FIXED, ItemTransforms.TransformType.HEAD -> true;
            default -> false;
        };
    }

    @Override
    public void renderItem(ItemStack itemStack, ItemTransforms.TransformType transformType, @Nullable LivingExtension<?, ?> living, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        boolean scoping;
        Scope scope = (Scope)itemStack.getCapability(Scope.CAPABILITY).orElse(null);
        boolean bl = scoping = scope != null && living != null && scope.isScoping(living);
        if (scoping && scope.getOverlayTexture(living).isPresent()) {
            return;
        }
        float partialTicks = this.minecraft.m_91104_() ? 1.0f : this.minecraft.m_91296_();
        Gun gun = CapabilityUtil.getOrThrow(Gun.CAPABILITY, (ICapabilityProvider)itemStack, Gun.class);
        poseStack.m_85836_();
        switch (transformType) {
            case FIRST_PERSON_LEFT_HAND: 
            case FIRST_PERSON_RIGHT_HAND: {
                Object obj;
                if (living == null || !((obj = living.getEntity()) instanceof AbstractClientPlayer)) break;
                AbstractClientPlayer player = (AbstractClientPlayer)obj;
                this.renderFirstPerson(player, itemStack, gun, scoping, transformType, partialTicks, poseStack, bufferSource, packedLight, packedOverlay);
                break;
            }
            case THIRD_PERSON_LEFT_HAND: 
            case THIRD_PERSON_RIGHT_HAND: {
                gun.getClient().getAnimationController().apply(partialTicks, poseStack);
                this.renderGunWithAttachements(itemStack.m_41790_(), gun, 0.0f, transformType, partialTicks, poseStack, bufferSource, packedLight, packedOverlay);
                break;
            }
            case HEAD: {
                this.properties.backTransform().push(poseStack);
                this.renderGunWithAttachements(itemStack.m_41790_(), gun, 0.0f, transformType, partialTicks, poseStack, bufferSource, packedLight, packedOverlay);
                poseStack.m_85849_();
                break;
            }
            case FIXED: {
                poseStack.m_85841_(1.5f, 1.5f, 1.5f);
                poseStack.m_85837_(-0.25, 0.0, 0.0);
                poseStack.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
                poseStack.m_85845_(Vector3f.f_122223_.m_122240_(180.0f));
            }
            default: {
                this.renderGunWithAttachements(itemStack.m_41790_(), gun, 0.0f, transformType, partialTicks, poseStack, bufferSource, packedLight, packedOverlay);
            }
        }
        poseStack.m_85849_();
    }

    private void renderFirstPersonArms(AbstractClientPlayer playerEntity, ItemStack itemStack, Gun gun, float aimingPct, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        Transformation leftHandTransforms;
        Transformation rightHandTransforms;
        PlayerRenderer playerRenderer = (PlayerRenderer)this.minecraft.m_91290_().m_114382_((Entity)playerEntity);
        HumanoidArm mainArm = playerEntity.m_5737_();
        Pair<Transformation, Transformation> heldTransforms = this.properties.handTransforms().getOrDefault((Object)(mainArm == HumanoidArm.RIGHT ? GunRendererProperties.HandTransform.HELD_RIGHT_HANDED : GunRendererProperties.HandTransform.HELD_LEFT_HANDED), IDENTITY_HAND_TRANSFORMS);
        if (aimingPct > 0.0f) {
            Pair<Transformation, Transformation> aimingTransforms = this.properties.handTransforms().getOrDefault((Object)(mainArm == HumanoidArm.RIGHT ? GunRendererProperties.HandTransform.AIMING_RIGHT_HANDED : GunRendererProperties.HandTransform.AIMING_LEFT_HANDED), IDENTITY_HAND_TRANSFORMS);
            rightHandTransforms = TransformationHelper.slerp((Transformation)((Transformation)heldTransforms.getFirst()), (Transformation)((Transformation)aimingTransforms.getFirst()), (float)aimingPct);
            leftHandTransforms = TransformationHelper.slerp((Transformation)((Transformation)heldTransforms.getSecond()), (Transformation)((Transformation)aimingTransforms.getSecond()), (float)aimingPct);
        } else {
            rightHandTransforms = (Transformation)heldTransforms.getFirst();
            leftHandTransforms = (Transformation)heldTransforms.getSecond();
        }
        poseStack.m_85836_();
        gun.getClient().getAnimationController().applyArm(playerEntity.m_5737_() == HumanoidArm.RIGHT ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND, HumanoidArm.RIGHT, partialTicks, poseStack);
        poseStack.m_85837_(0.75, -0.75, (double)-0.6f);
        rightHandTransforms.push(poseStack);
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(95.0f));
        poseStack.m_85845_(Vector3f.f_122227_.m_122240_(100.0f));
        poseStack.m_85845_(Vector3f.f_122223_.m_122240_(180.0f));
        poseStack.m_85837_((double)0.9f, -0.75, 0.5);
        playerRenderer.m_117770_(poseStack, bufferSource, packedLight, playerEntity);
        poseStack.m_85849_();
        poseStack.m_85849_();
        poseStack.m_85836_();
        gun.getClient().getAnimationController().applyArm(playerEntity.m_5737_() == HumanoidArm.LEFT ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND, HumanoidArm.LEFT, partialTicks, poseStack);
        poseStack.m_85837_(0.75, -0.75, -0.75);
        leftHandTransforms.push(poseStack);
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(95.0f));
        poseStack.m_85845_(Vector3f.f_122227_.m_122240_(95.0f));
        poseStack.m_85845_(Vector3f.f_122223_.m_122240_(120.0f));
        poseStack.m_85837_((double)0.05f, (double)-1.05f, (double)0.3f);
        playerRenderer.m_117813_(poseStack, bufferSource, packedLight, playerEntity);
        poseStack.m_85849_();
        poseStack.m_85849_();
    }

    private void renderFlash(Gun gun, PoseStack matrixStack, MultiBufferSource bufferSource, int packedOverlay) {
        matrixStack.m_85836_();
        long currentTime = Util.m_137550_();
        long deltaTime = currentTime - this.lastFlashTime;
        if (deltaTime > 250L) {
            this.lastFlashTime = currentTime;
            deltaTime = 250L;
        }
        int texture = (int)(deltaTime / 100L + 1L);
        float randomScale = (float)(random.nextInt(8) + 3) / 10.0f;
        Transformation transform = this.properties.muzzleFlashTransform();
        Vector3f scale = transform.m_175941_();
        matrixStack.m_85841_(scale.m_122239_() + randomScale, scale.m_122260_() + randomScale, scale.m_122269_() + randomScale);
        float x = transform.m_175940_().m_122239_();
        float y = transform.m_175940_().m_122260_();
        float z = transform.m_175940_().m_122269_();
        if (gun.getAttachments().contains(Attachments.SUPPRESSOR.get())) {
            z = (float)((double)z - 0.4);
        }
        matrixStack.m_85837_((double)(x - randomScale * x / 2.0f), (double)(y - randomScale * y / 2.0f), (double)(z - randomScale * z / 2.0f));
        VertexConsumer flashBuffer = bufferSource.m_6299_(RenderType.m_110460_((ResourceLocation)new ResourceLocation("craftingdead", "textures/flash/flash" + texture + ".png"), (boolean)true));
        this.muzzleFlashModel.m_104306_(matrixStack, flashBuffer, 0xF000F0, packedOverlay, 1.0f, 1.0f, 1.0f, randomScale + 0.5f);
        matrixStack.m_85849_();
    }

    private void renderFirstPerson(AbstractClientPlayer playerEntity, ItemStack itemStack, Gun gun, boolean aiming, ItemTransforms.TransformType transformType, float partialTicks, PoseStack poseStack, MultiBufferSource renderTypeBuffer, int packedLight, int packedOverlay) {
        boolean flash = gun.getClient().isFlashing();
        if (flash) {
            packedLight = 0xF000F0;
        }
        if (this.wasSprinting != playerEntity.m_20142_()) {
            this.sprintStartTimeMs = Util.m_137550_();
            this.wasSprinting = playerEntity.m_20142_();
        }
        float sprintingPct = Mth.m_14036_((float)((float)(Util.m_137550_() - this.sprintStartTimeMs) / 300.0f), (float)0.0f, (float)1.0f);
        if (!playerEntity.m_20142_()) {
            sprintingPct = 1.0f - sprintingPct;
        }
        sprintingPct = EasingFunction.SINE_IN_OUT.apply(sprintingPct);
        if (this.wasAiming != aiming) {
            this.aimingStartTimeMs = Util.m_137550_();
            this.wasAiming = aiming;
        }
        float aimingPct = Mth.m_14036_((float)((float)(Util.m_137550_() - this.aimingStartTimeMs) / 200.0f), (float)0.0f, (float)1.0f);
        if (!aiming) {
            aimingPct = 1.0f - aimingPct;
        }
        aimingPct = EasingFunction.SINE_IN_OUT.apply(aimingPct);
        if (sprintingPct > 0.0f) {
            TransformationHelper.slerp((Transformation)Transformation.m_121093_(), (Transformation)this.properties.sprintingTransform(), (float)sprintingPct).push(poseStack);
        } else {
            poseStack.m_85836_();
        }
        if (!aiming && flash) {
            this.renderFlash(gun, poseStack, renderTypeBuffer, packedOverlay);
        }
        this.renderFirstPersonArms(playerEntity, itemStack, gun, aimingPct, partialTicks, poseStack, renderTypeBuffer, packedLight);
        gun.getClient().getAnimationController().apply(partialTicks, poseStack);
        this.renderGunWithAttachements(itemStack.m_41790_(), gun, aimingPct, transformType, partialTicks, poseStack, renderTypeBuffer, packedLight, packedOverlay);
        poseStack.m_85849_();
    }

    private void renderGunWithAttachements(boolean foil, Gun gun, float aimingPct, ItemTransforms.TransformType transformType, float partialTicks, PoseStack matrixStack, MultiBufferSource renderTypeBuffer, int packedLight, int packedOverlay) {
        ResourceLocation skinTextureLocation = gun.getSkin() == null ? null : gun.getSkin().getTextureLocation(gun.getItemStack().m_41720_().getRegistryName());
        Integer color = gun.getPaintStack().getCapability(Paint.CAPABILITY).resolve().map(paint -> paint.getColor().orElse(-1)).orElse(-1);
        Map<String, Either> textures = null;
        if (skinTextureLocation != null) {
            textures = Map.of(GUN_TEXTURE_REFERENCE, Either.left((Object)new Material(InventoryMenu.f_39692_, skinTextureLocation)));
        }
        BakedModel bakedModel = this.getBakedModel(this.properties.modelLocation(), textures);
        PoseStack tempPoseStack = new PoseStack();
        bakedModel = bakedModel.handlePerspective(transformType, tempPoseStack);
        Transformation normalTransform = new Transformation(tempPoseStack.m_85850_().m_85861_());
        Transformation perspectiveTransform = aimingPct > 0.0f ? TransformationHelper.slerp((Transformation)normalTransform, (Transformation)this.properties.aimingTransform(), (float)aimingPct) : normalTransform;
        perspectiveTransform.push(matrixStack);
        this.renderBakedModel(bakedModel, foil, color, transformType, matrixStack, renderTypeBuffer, packedLight, packedOverlay);
        matrixStack.m_85836_();
        this.renderMagazine(gun, skinTextureLocation, color, foil, transformType, matrixStack, renderTypeBuffer, packedLight, packedOverlay);
        matrixStack.m_85849_();
        this.renderAttachments(gun, skinTextureLocation, color, foil, transformType, partialTicks, matrixStack, renderTypeBuffer, packedLight, packedOverlay);
        matrixStack.m_85849_();
    }

    protected final void renderBakedModel(BakedModel bakedModel, boolean foil, int colour, ItemTransforms.TransformType transformType, PoseStack poseStack, MultiBufferSource renderTypeBuffer, int packedLight, int packedOverlay) {
        poseStack.m_85836_();
        poseStack.m_85837_(-0.5, -0.5, -0.5);
        VertexConsumer vertexBuilder = ItemRenderer.m_115211_((MultiBufferSource)renderTypeBuffer, (RenderType)Sheets.m_110792_(), (boolean)true, (boolean)foil);
        List bakedQuads = bakedModel.getQuads(null, null, random, (IModelData)EmptyModelData.INSTANCE);
        PoseStack.Pose pose = poseStack.m_85850_();
        for (BakedQuad bakedQuad : bakedQuads) {
            float red = (float)(colour >> 16 & 0xFF) / 255.0f;
            float green = (float)(colour >> 8 & 0xFF) / 255.0f;
            float blue = (float)(colour & 0xFF) / 255.0f;
            vertexBuilder.putBulkData(pose, bakedQuad, red, green, blue, packedLight, packedOverlay, true);
        }
        poseStack.m_85849_();
    }

    private BakedModel getBakedModel(ResourceLocation modelLocation, @Nullable Map<String, Either<Material, String>> textures) {
        return this.cachedModels.computeIfAbsent(modelLocation.hashCode() + (textures == null ? 0 : textures.hashCode()), key -> {
            UnbakedModel model;
            if (textures != null && (model = ForgeModelBakery.instance().getModelOrMissing(modelLocation)) instanceof BlockModel) {
                BlockModel blockModel = (BlockModel)model;
                BlockModel overriddenModel = new BlockModel(null, List.of(), textures, false, null, ItemTransforms.f_111786_, List.of());
                overriddenModel.f_111418_ = blockModel;
                return overriddenModel.m_111449_((ModelBakery)ForgeModelBakery.instance(), overriddenModel, ForgeModelBakery.defaultTextureGetter(), (ModelState)SimpleModelState.IDENTITY, modelLocation, false);
            }
            return this.minecraft.m_91304_().getModel(modelLocation);
        });
    }

    private void renderAttachments(Gun gun, @Nullable ResourceLocation skinTextureLocation, int colour, boolean foil, ItemTransforms.TransformType transformType, float partialTicks, PoseStack matrixStack, MultiBufferSource renderTypeBuffer, int packedLight, int packedOverlay) {
        if (gun.hasIronSight()) {
            for (Pair pair : this.properties.ironSights()) {
                ((Transformation)pair.getSecond()).push(matrixStack);
                BakedModel bakedModel = this.getBakedModel((ResourceLocation)pair.getFirst(), Map.of(GUN_TEXTURE_REFERENCE, Either.left((Object)(skinTextureLocation == null ? this.getGunRenderMaterial() : new Material(InventoryMenu.f_39692_, skinTextureLocation)))));
                this.renderBakedModel(bakedModel, foil, colour, transformType, matrixStack, renderTypeBuffer, packedLight, packedOverlay);
                matrixStack.m_85849_();
            }
        }
        for (Attachment attachment : gun.getAttachments()) {
            Transformation transform = this.properties.attachementTransforms().getOrDefault(attachment.getRegistryName(), Transformation.m_121093_());
            transform.push(matrixStack);
            BakedModel bakedModel = this.getBakedModel(GunRenderer.getAttachmentModelLocation(attachment.getRegistryName()), null);
            this.renderBakedModel(bakedModel, foil, colour, transformType, matrixStack, renderTypeBuffer, packedLight, packedOverlay);
            matrixStack.m_85849_();
        }
    }

    private void renderMagazine(Gun gun, @Nullable ResourceLocation skinTextureLocation, int colour, boolean foil, ItemTransforms.TransformType transformType, PoseStack matrixStack, MultiBufferSource renderTypeBuffer, int packedLight, int packedOverlay) {
        ItemStack magazineStack = gun.getAmmoProvider().getMagazineStack();
        if (!magazineStack.m_41619_()) {
            Transformation transform = this.properties.magazineTransforms().getOrDefault(magazineStack.m_41720_().getRegistryName(), Transformation.m_121093_());
            transform.push(matrixStack);
            ResourceLocation modelLocation = GunRenderer.getMagazineModelLocation(magazineStack.m_41720_().getRegistryName());
            BakedModel magazineBakedModel = this.getBakedModel(modelLocation, Map.of(GUN_TEXTURE_REFERENCE, Either.left((Object)(skinTextureLocation == null ? this.getGunRenderMaterial() : new Material(InventoryMenu.f_39692_, skinTextureLocation)))));
            this.renderBakedModel(magazineBakedModel, foil, colour, transformType, matrixStack, renderTypeBuffer, packedLight, packedOverlay);
            matrixStack.m_85849_();
        }
    }

    private Material getGunRenderMaterial() {
        Material material;
        UnbakedModel unbakedModel = ForgeModelBakery.instance().getModelOrMissing(this.properties.modelLocation());
        if (unbakedModel instanceof BlockModel) {
            BlockModel model = (BlockModel)unbakedModel;
            material = model.m_111480_(GUN_TEXTURE_REFERENCE);
        } else {
            material = new Material(InventoryMenu.f_39692_, MissingTextureAtlasSprite.m_118071_());
        }
        return material;
    }

    @Override
    public Collection<ResourceLocation> getModelDependencies() {
        HashSet<ResourceLocation> dependencies = new HashSet<ResourceLocation>();
        dependencies.addAll(this.properties.ironSights().stream().map(Pair::getFirst).collect(Collectors.toSet()));
        dependencies.addAll(this.item.asGun().getAcceptedAttachments().stream().map(ForgeRegistryEntry::getRegistryName).map(GunRenderer::getAttachmentModelLocation).collect(Collectors.toSet()));
        dependencies.addAll(this.item.asGun().getAcceptedMagazines().stream().map(ForgeRegistryEntry::getRegistryName).map(GunRenderer::getMagazineModelLocation).collect(Collectors.toSet()));
        dependencies.add(this.properties.modelLocation());
        return dependencies;
    }

    @Override
    public Collection<Material> getMaterials() {
        return Collections.emptySet();
    }

    @Override
    public void refreshCachedModels(Function<ModelLayerLocation, ModelPart> modelBaker) {
        this.cachedModels.clear();
        this.muzzleFlashModel = modelBaker.apply(ModModelLayers.MUZZLE_FLASH);
    }

    @Override
    public ItemRendererType<?, ?> getType() {
        return ItemRendererTypes.GUN;
    }

    private static ResourceLocation getAttachmentModelLocation(ResourceLocation attachmentName) {
        return new ResourceLocation(attachmentName.m_135827_(), "attachment/" + attachmentName.m_135815_());
    }

    private static ResourceLocation getMagazineModelLocation(ResourceLocation magazineName) {
        return new ResourceLocation(magazineName.m_135827_(), "magazine/" + magazineName.m_135815_());
    }

    public static LayerDefinition createMuzzleFlashBodyLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.m_171576_();
        root.m_171599_("box0", CubeListBuilder.m_171558_().m_171480_().m_171514_(1, 1).m_171481_(0.0f, 0.0f, 0.0f, 8.0f, 8.0f, 0.0f).m_171555_(false), PartPose.m_171419_((float)-4.0f, (float)-4.0f, (float)0.0f));
        root.m_171599_("box1", CubeListBuilder.m_171558_().m_171480_().m_171514_(9, 1).m_171481_(-4.0f, 0.0f, 0.0f, 8.0f, 0.0f, 15.0f).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)-15.0f, (float)0.0f, (float)0.0f, (float)-0.7853982f));
        root.m_171599_("box2", CubeListBuilder.m_171558_().m_171480_().m_171514_(1, 17).m_171481_(-4.0f, 0.0f, 0.0f, 8.0f, 0.0f, 15.0f).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)-15.0f, (float)0.0f, (float)0.0f, (float)-2.373648f));
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)64, (int)64);
    }
}

