/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.client.renderer.entity.layers;

import com.craftingdead.core.client.util.RenderUtil;
import com.craftingdead.core.world.entity.extension.LivingExtension;
import com.craftingdead.core.world.inventory.ModEquipmentSlot;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class EquipmentLayer<T extends LivingEntity, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    private final ModEquipmentSlot slot;
    private final boolean useCrouchOrientation;
    private final boolean useHeadOrientation;
    @Nullable
    private final Consumer<PoseStack> transformation;

    private EquipmentLayer(Builder<T, M> builder) {
        super(builder.renderer);
        this.slot = builder.slot;
        this.useCrouchOrientation = builder.useCrouchOrientation;
        this.transformation = builder.tranformation;
        this.useHeadOrientation = builder.useHeadOrientation;
    }

    public void render(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, T livingEntity, float limbSwing, float limbSwingAmount, float partialTicks, float ageTicks, float headYaw, float headPitch) {
        boolean partiallyVisible;
        Minecraft minecraft = Minecraft.m_91087_();
        boolean invisible = livingEntity.m_20145_();
        boolean bl = partiallyVisible = livingEntity.m_20145_() && !livingEntity.m_20177_((Player)minecraft.f_91074_);
        if (partiallyVisible || !invisible) {
            ItemRenderer itemRenderer = minecraft.m_91291_();
            livingEntity.getCapability(LivingExtension.CAPABILITY).ifPresent(living -> {
                ItemStack itemStack = living.getItemHandler().getStackInSlot(this.slot.getIndex());
                if (!itemStack.m_41619_()) {
                    BakedModel bakedModel = itemRenderer.m_174264_(itemStack, livingEntity.f_19853_, livingEntity, 0);
                    poseStack.m_85836_();
                    if (this.useCrouchOrientation && livingEntity.m_6047_()) {
                        RenderUtil.applyPlayerCrouchRotation(poseStack);
                    }
                    if (this.useHeadOrientation) {
                        if (livingEntity.m_6162_()) {
                            poseStack.m_85837_(0.0, 0.03125, 0.0);
                            poseStack.m_85841_(0.7f, 0.7f, 0.7f);
                            poseStack.m_85837_(0.0, 1.0, 0.0);
                        }
                        ((HeadedModel)this.m_117386_()).m_5585_().m_104299_(poseStack);
                    }
                    if (this.transformation != null) {
                        this.transformation.accept(poseStack);
                    }
                    itemRenderer.m_115143_(itemStack, ItemTransforms.TransformType.HEAD, false, poseStack, bufferSource, packedLight, OverlayTexture.f_118083_, bakedModel);
                    poseStack.m_85849_();
                }
            });
        }
    }

    public static <T extends LivingEntity, M extends EntityModel<T>> Builder<T, M> builder(LivingEntityRenderer<T, M> renderer) {
        return new Builder<T, M>(renderer);
    }

    public static class Builder<T extends LivingEntity, M extends EntityModel<T>> {
        private final LivingEntityRenderer<T, M> renderer;
        private ModEquipmentSlot slot;
        @Nullable
        private Consumer<PoseStack> tranformation;
        private boolean useCrouchOrientation;
        private boolean useHeadOrientation;

        private Builder(LivingEntityRenderer<T, M> renderer) {
            this.renderer = renderer;
        }

        public Builder<T, M> slot(ModEquipmentSlot slot) {
            this.slot = slot;
            return this;
        }

        public Builder<T, M> transformation(Consumer<PoseStack> transformation) {
            this.tranformation = transformation;
            return this;
        }

        public Builder<T, M> useCrouchOrientation(boolean useCrouchOrientation) {
            this.useCrouchOrientation = useCrouchOrientation;
            return this;
        }

        public Builder<T, M> useHeadOrientation(boolean useHeadOrientation) {
            this.useHeadOrientation = useHeadOrientation;
            return this;
        }

        public EquipmentLayer<T, M> build() {
            Objects.requireNonNull(this.renderer, "The renderer must not be null");
            Objects.requireNonNull(this.slot, "The slot must not be null");
            return new EquipmentLayer(this);
        }
    }
}

