/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.client.renderer.entity.grenade;

import com.craftingdead.core.client.model.geom.ModModelLayers;
import com.craftingdead.core.world.entity.grenade.Grenade;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;

public class GrenadeRenderer
extends EntityRenderer<Grenade> {
    private final ModelPart model;

    public GrenadeRenderer(EntityRendererProvider.Context context, ModelPart model) {
        super(context);
        this.model = model;
    }

    public void render(Grenade entity, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        float rotation = entity.getTotalTicksInAir();
        if (!entity.hasStoppedMoving()) {
            rotation += partialTick;
        }
        float yTranslation = Math.min((rotation /= 4.0f) / 1.5707964f, 1.0f);
        yTranslation = (float)((double)yTranslation / 10.0);
        poseStack.m_85837_(0.0, (double)yTranslation, 0.0);
        poseStack.m_85845_(Vector3f.f_122223_.m_122270_(rotation));
        VertexConsumer vertexConsumer = bufferSource.m_6299_(RenderType.m_110458_((ResourceLocation)this.getTextureLocation(entity)));
        this.model.m_104306_(poseStack, vertexConsumer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 0.15f);
    }

    public ResourceLocation getTextureLocation(Grenade entity) {
        return new ResourceLocation(entity.m_6095_().getRegistryName().m_135827_(), "textures/entity/grenade/" + entity.m_6095_().getRegistryName().m_135815_() + ".png");
    }

    public static EntityRendererProvider<Grenade> cylinder() {
        return GrenadeRenderer.forModel(ModModelLayers.CYLINDER_GRENADE);
    }

    public static EntityRendererProvider<Grenade> slim() {
        return GrenadeRenderer.forModel(ModModelLayers.SLIM_GRENADE);
    }

    public static EntityRendererProvider<Grenade> frag() {
        return GrenadeRenderer.forModel(ModModelLayers.FRAG_GRENADE);
    }

    public static EntityRendererProvider<Grenade> forModel(ModelLayerLocation modelLocation) {
        return context -> new GrenadeRenderer(context, context.m_174023_(modelLocation));
    }
}

