/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.client.gui.screen.inventory;

import com.craftingdead.core.client.gui.SimpleButton;
import com.craftingdead.core.network.NetworkChannel;
import com.craftingdead.core.network.message.play.OpenStorageMessage;
import com.craftingdead.core.world.inventory.EquipmentMenu;
import com.craftingdead.core.world.inventory.ModEquipmentSlot;
import com.craftingdead.core.world.inventory.storage.Storage;
import com.craftingdead.core.world.item.gun.Gun;
import com.craftingdead.core.world.item.gun.skin.Paint;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.EffectRenderingInventoryScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;

public class EquipmentScreen
extends EffectRenderingInventoryScreen<EquipmentMenu> {
    private static final ResourceLocation BACKGROUND = new ResourceLocation("craftingdead", "textures/gui/container/equipment.png");
    private static final Component ARROW = new TextComponent(">");
    private int oldMouseX;
    private int oldMouseY;
    private Button backpackButton;
    private Button vestButton;
    private boolean transitioning = false;

    public EquipmentScreen(EquipmentMenu menu, Inventory inventory, Component title) {
        super((AbstractContainerMenu)menu, inventory, title);
    }

    public void m_7856_() {
        super.m_7856_();
        this.backpackButton = new SimpleButton(this.f_97735_ + 98, this.f_97736_ + 7, 10, 17, ARROW, button -> {
            NetworkChannel.PLAY.getSimpleChannel().sendToServer((Object)new OpenStorageMessage(ModEquipmentSlot.BACKPACK));
            this.transitioning = true;
        });
        this.m_142416_((GuiEventListener)this.backpackButton);
        this.vestButton = new SimpleButton(this.f_97735_ + 98, this.f_97736_ + 61, 10, 17, ARROW, button -> {
            NetworkChannel.PLAY.getSimpleChannel().sendToServer((Object)new OpenStorageMessage(ModEquipmentSlot.VEST));
            this.transitioning = true;
        });
        this.m_142416_((GuiEventListener)this.vestButton);
        this.refreshButtonStatus();
    }

    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        this.m_7025_(matrixStack, mouseX, mouseY);
        this.oldMouseX = mouseX;
        this.oldMouseY = mouseY;
    }

    protected void m_181908_() {
        super.m_181908_();
        this.refreshButtonStatus();
    }

    private void refreshButtonStatus() {
        this.backpackButton.f_93623_ = ((EquipmentMenu)this.f_97732_).getItemHandler().getStackInSlot(ModEquipmentSlot.BACKPACK.getIndex()).getCapability(Storage.CAPABILITY).isPresent();
        this.vestButton.f_93623_ = ((EquipmentMenu)this.f_97732_).getItemHandler().getStackInSlot(ModEquipmentSlot.VEST.getIndex()).getCapability(Storage.CAPABILITY).isPresent();
    }

    public boolean isTransitioning() {
        return this.transitioning;
    }

    protected void m_7027_(PoseStack matrixStack, int x, int y) {
    }

    protected void m_7286_(PoseStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        this.m_7333_(matrixStack);
        RenderSystem.m_157456_((int)0, (ResourceLocation)BACKGROUND);
        this.m_93228_(matrixStack, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        ItemStack gunStack = ((EquipmentMenu)this.f_97732_).getGunStack();
        gunStack.getCapability(Gun.CAPABILITY).ifPresent(gun -> {
            boolean carriedItemAccepted;
            int gunSlotX = this.f_97735_ + 124;
            int gunSlotY = this.f_97736_ + 32;
            this.m_93228_(matrixStack, gunSlotX, gunSlotY, 176, 0, 22, 22);
            boolean bl = carriedItemAccepted = gun.isAcceptedAttachment(((EquipmentMenu)this.f_97732_).m_142621_()) || Paint.isValid(((EquipmentMenu)this.f_97732_).getGunStack(), ((EquipmentMenu)this.f_97732_).m_142621_());
            if (!((EquipmentMenu)this.f_97732_).isCraftingInventoryEmpty() && ((EquipmentMenu)this.f_97732_).isCraftable() || !((EquipmentMenu)this.f_97732_).m_142621_().m_41619_() && carriedItemAccepted) {
                this.m_93228_(matrixStack, gunSlotX, gunSlotY, 176, 22, 22, 22);
            } else if (!((EquipmentMenu)this.f_97732_).m_142621_().m_41619_() && !carriedItemAccepted) {
                this.m_93228_(matrixStack, gunSlotX, gunSlotY, 176, 44, 22, 22);
            }
        });
        InventoryScreen.m_98850_((int)(this.f_97735_ + 33), (int)(this.f_97736_ + 72), (int)30, (float)(this.f_97735_ + 51 - this.oldMouseX), (float)(this.f_97736_ + 75 - 50 - this.oldMouseY), (LivingEntity)this.f_96541_.f_91074_);
    }
}

