/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.client.gui;

import com.craftingdead.core.client.ClientDist;
import com.craftingdead.core.client.crosshair.Crosshair;
import com.craftingdead.core.client.gui.HitMarker;
import com.craftingdead.core.client.util.RenderUtil;
import com.craftingdead.core.world.action.ActionObserver;
import com.craftingdead.core.world.damagesource.KillFeedEntry;
import com.craftingdead.core.world.effect.ModMobEffects;
import com.craftingdead.core.world.entity.extension.PlayerExtension;
import com.craftingdead.core.world.item.GrenadeItem;
import com.craftingdead.core.world.item.GunItem;
import com.craftingdead.core.world.item.gun.Gun;
import com.craftingdead.core.world.item.gun.ammoprovider.AmmoProvider;
import com.craftingdead.core.world.item.gun.magazine.Magazine;
import com.craftingdead.core.world.item.scope.Scope;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;

public class IngameGui {
    private static final Random random = new Random();
    private static final ResourceLocation HEALTH = new ResourceLocation("craftingdead", "textures/gui/health.png");
    private static final ResourceLocation SHIELD = new ResourceLocation("craftingdead", "textures/gui/shield.png");
    private static final int KILL_FEED_MESSAGE_LIFE_MS = 5000;
    private final Minecraft minecraft;
    private final ClientDist client;
    private final List<KillFeedEntry> killFeedMessages = new LinkedList<KillFeedEntry>();
    private ResourceLocation crosshairLocation;
    private float lastSpread;
    private float lastFlashScale = 0.0f;
    @Nullable
    private HitMarker hitMarker;
    private long killFeedVisibleTimeMs;
    private long killFeedAnimationTimeMs;

    public IngameGui(Minecraft minecraft, ClientDist client, ResourceLocation crosshairLocation) {
        this.minecraft = minecraft;
        this.client = client;
        this.crosshairLocation = crosshairLocation;
    }

    public void setCrosshairLocation(ResourceLocation crosshairLocation) {
        this.crosshairLocation = crosshairLocation;
    }

    public void addKillFeedEntry(KillFeedEntry killFeedMessage) {
        if (this.killFeedMessages.isEmpty()) {
            this.killFeedVisibleTimeMs = 0L;
        }
        this.killFeedMessages.add(killFeedMessage);
    }

    public void setHitMarker(@Nullable HitMarker hitMarker) {
        this.hitMarker = hitMarker;
    }

    private void renderGunFlash(PoseStack poseStack, Gun gun, int width, int height, float partialTicks) {
        if (gun.getClient().isFlashing()) {
            poseStack.m_85836_();
            float flashIntensity = (float)(random.nextInt(3) + 5) / 10.0f;
            float scale = this.lastFlashScale = Mth.m_14179_((float)partialTicks, (float)this.lastFlashScale, (float)flashIntensity);
            RenderSystem.m_157456_((int)0, (ResourceLocation)new ResourceLocation("craftingdead", "textures/flash/white_flash.png"));
            RenderSystem.m_69478_();
            RenderSystem.m_69453_();
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)(flashIntensity - 0.15f));
            float x = (float)width * 0.625f;
            float y = (float)height * 0.625f;
            float flashWidth = 300.0f;
            float flashHeight = 300.0f;
            poseStack.m_85837_((double)(x - x * scale), (double)(y - y * scale), 0.0);
            poseStack.m_85841_(scale, scale, 1.0f);
            RenderUtil.blit(x - 150.0f, y - 150.0f, 300.0f, 300.0f);
            RenderSystem.m_69461_();
            poseStack.m_85849_();
        }
    }

    private static void renderScopeOverlay(PlayerExtension<AbstractClientPlayer> player, Scope scope, int width, int height) {
        scope.getOverlayTexture(player).ifPresent(overlayTexture -> {
            RenderSystem.m_157456_((int)0, (ResourceLocation)overlayTexture);
            int overlayTextureWidth = scope.getOverlayTextureWidth();
            int overlayTextureHeight = scope.getOverlayTextureHeight();
            float scale = RenderUtil.getFitScale(overlayTextureWidth, overlayTextureHeight);
            overlayTextureWidth = (int)((float)overlayTextureWidth * scale);
            overlayTextureHeight = (int)((float)overlayTextureHeight * scale);
            RenderSystem.m_69478_();
            RenderUtil.blit((float)width / 2.0f - (float)overlayTextureWidth / 2.0f, (float)height / 2.0f - (float)overlayTextureHeight / 2.0f, overlayTextureWidth, overlayTextureHeight);
            RenderSystem.m_69461_();
        });
    }

    public void renderOverlay(PlayerExtension<AbstractClientPlayer> player, ItemStack heldStack, @Nullable Gun gun, PoseStack poseStack, int width, int height, float partialTicks) {
        if (this.hitMarker != null && this.hitMarker.render(poseStack, width, height, partialTicks)) {
            this.hitMarker = null;
        }
        this.renderKillFeed(poseStack, partialTicks);
        heldStack.getCapability(Scope.CAPABILITY).filter(scope -> scope.isScoping(player)).ifPresent(scope -> IngameGui.renderScopeOverlay(player, scope, width, height));
        MobEffectInstance flashEffect = ((AbstractClientPlayer)player.getEntity()).m_21124_((MobEffect)ModMobEffects.FLASH_BLINDNESS.get());
        if (flashEffect != null) {
            int alpha = (int)(255.0f * (Mth.m_14036_((float)((float)flashEffect.m_19557_() - partialTicks), (float)0.0f, (float)20.0f) / 20.0f));
            int flashColour = 0xFFFFFF | (alpha & 0xFF) << 24;
            RenderUtil.fillGradient(poseStack, 0.0f, 0.0f, width, height, flashColour, flashColour);
        }
        player.getActionObserver().flatMap(ActionObserver::getProgressBar).ifPresent(observer -> IngameGui.renderProgress(poseStack, this.minecraft.f_91062_, width, height, observer.getMessage(), observer.getSubMessage().orElse(null), observer.getProgress(partialTicks)));
        if (gun != null) {
            this.renderGunFlash(poseStack, gun, width, height, partialTicks);
        }
        if (gun != null) {
            this.renderAmmo(poseStack, width, height, gun);
        }
        if (player.isCombatModeEnabled()) {
            this.renderCombatMode(player, poseStack, width, height);
        }
        this.renderHandcuffsDamage(poseStack, player.getHandcuffs(), width, height);
    }

    private void renderHandcuffsDamage(PoseStack poseStack, ItemStack handcuffs, int width, int height) {
        if (!handcuffs.m_41619_()) {
            int mWidth = width / 2;
            int mHeight = height / 2;
            int damage = handcuffs.m_41776_() - handcuffs.m_41773_();
            GuiComponent.m_93215_((PoseStack)poseStack, (Font)this.minecraft.f_91062_, (Component)new TextComponent(damage + "/" + handcuffs.m_41776_()), (int)(mWidth + 1), (int)(mHeight + 10), (int)-1);
            PoseStack modelViewStack = RenderSystem.m_157191_();
            modelViewStack.m_85836_();
            modelViewStack.m_85837_((double)((float)mWidth - 20.0f), (double)((float)mHeight - 30.0f), 0.0);
            float scale = 2.5f;
            modelViewStack.m_85841_(2.5f, 2.5f, 2.5f);
            this.minecraft.m_91291_().m_115123_(handcuffs, 0, 0);
            modelViewStack.m_85849_();
            RenderSystem.m_157182_();
        }
    }

    private void renderKillFeed(PoseStack poseStack, float partialTicks) {
        long currentTime;
        float durationPct;
        if (this.killFeedVisibleTimeMs == 0L) {
            this.killFeedVisibleTimeMs = Util.m_137550_();
            this.killFeedAnimationTimeMs = 0L;
        }
        if ((durationPct = Mth.m_14036_((float)((float)((currentTime = Util.m_137550_()) - this.killFeedVisibleTimeMs) / 5000.0f), (float)0.0f, (float)1.0f)) == 1.0f && !this.killFeedMessages.isEmpty()) {
            this.killFeedMessages.remove(0);
            if (!this.killFeedMessages.isEmpty()) {
                this.killFeedVisibleTimeMs = Util.m_137550_();
                this.killFeedAnimationTimeMs = 0L;
            }
        } else if (durationPct >= 0.75f && this.killFeedAnimationTimeMs == 0L) {
            this.killFeedAnimationTimeMs = Util.m_137550_();
        }
        float animationPct = this.killFeedAnimationTimeMs != 0L ? Mth.m_14036_((float)((float)(currentTime - this.killFeedAnimationTimeMs) / (1250.0f - partialTicks)), (float)0.0f, (float)1.0f) : 0.0f;
        int killFeedMessageX = 5;
        for (int i = 0; i < this.killFeedMessages.size(); ++i) {
            KillFeedEntry killFeedMessage = this.killFeedMessages.get(i);
            float killFeedMessageY = 5.0f + ((float)i - 1.0f * animationPct) * 12.0f;
            this.renderKillFeedEntry(killFeedMessage, poseStack, 5.0f, killFeedMessageY, i == 0 ? 1.0f - animationPct : 1.0f);
        }
    }

    private void renderKillFeedEntry(KillFeedEntry entry, PoseStack poseStack, float x, float y, float alpha) {
        String killerName = entry.getKillerName().getString();
        String deadName = entry.getDeadName().getString();
        int killerNameWidth = this.minecraft.f_91062_.m_92895_(killerName);
        int deadNameWidth = this.minecraft.f_91062_.m_92895_(deadName);
        int spacing = 20;
        alpha *= entry.getKillerEntityId() == this.minecraft.f_91074_.m_142049_() ? 0.7f : 0.5f;
        switch (entry.getType()) {
            case WALLBANG_HEADSHOT: {
                spacing += 16;
            }
            case HEADSHOT: 
            case WALLBANG: {
                spacing += 16;
                break;
            }
        }
        int opacity = Math.min((int)(alpha * 255.0f), 255);
        if (opacity < 8) {
            return;
        }
        int colour = 0 + (opacity << 24);
        RenderUtil.fillGradient(poseStack, x, y, x + (float)killerNameWidth + (float)deadNameWidth + (float)spacing, y + 11.0f, colour, colour);
        this.minecraft.f_91062_.m_92750_(poseStack, killerName, x + 2.0f, y + 2.0f, 0xFFFFFF + ((int)(alpha * 255.0f) << 24));
        this.minecraft.f_91062_.m_92750_(poseStack, deadName, x + (float)killerNameWidth + (float)spacing - 1.0f, y + 2.0f, 0xFFFFFF + (opacity << 24));
        switch (entry.getType()) {
            case HEADSHOT: {
                RenderSystem.m_69478_();
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
                RenderSystem.m_157456_((int)0, (ResourceLocation)new ResourceLocation("craftingdead", "textures/gui/headshot.png"));
                RenderUtil.blit(x + (float)killerNameWidth + 17.0f, y - 1.0f, 12.0f, 12.0f);
                RenderSystem.m_69461_();
                break;
            }
            case WALLBANG: {
                RenderSystem.m_69478_();
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
                RenderSystem.m_157456_((int)0, (ResourceLocation)new ResourceLocation("craftingdead", "textures/gui/wallbang.png"));
                RenderUtil.blit(x + (float)killerNameWidth + 35.0f, y - 1.0f, 12.0f, 12.0f);
                RenderSystem.m_69461_();
                break;
            }
            case WALLBANG_HEADSHOT: {
                RenderSystem.m_69478_();
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
                RenderSystem.m_157456_((int)0, (ResourceLocation)new ResourceLocation("craftingdead", "textures/gui/wallbang.png"));
                RenderUtil.blit(x + (float)killerNameWidth + 35.0f, y - 1.0f, 12.0f, 12.0f);
                RenderSystem.m_157456_((int)0, (ResourceLocation)new ResourceLocation("craftingdead", "textures/gui/headshot.png"));
                RenderUtil.blit(x + (float)killerNameWidth + 35.0f + 14.0f, y - 1.0f, 12.0f, 12.0f);
                RenderSystem.m_69461_();
                break;
            }
        }
        if (!entry.getWeaponStack().m_41619_()) {
            float scale;
            poseStack.m_85836_();
            poseStack.m_85837_((double)(x + (float)killerNameWidth + 4.0f), (double)(y - 1.0f), 0.0);
            if (entry.getWeaponStack().m_41720_() instanceof GunItem) {
                scale = 0.75f;
                poseStack.m_85841_(scale, scale, scale);
            }
            if (entry.getWeaponStack().m_41720_() instanceof GrenadeItem) {
                scale = 0.8f;
                poseStack.m_85841_(scale, scale, scale);
                poseStack.m_85837_(4.0, 1.0, 0.0);
            }
            RenderUtil.renderGuiItem(entry.getWeaponStack(), 0, 0, 0xFFFFFF + (opacity << 24));
            poseStack.m_85849_();
        }
    }

    private void renderAmmo(PoseStack poseStack, int width, int height, Gun gun) {
        int x = width - 115;
        int boxHeight = 25;
        RenderUtil.fillGradient(poseStack, x - 10, height - boxHeight, x + 30, height, 0, 0x55000000);
        GuiComponent.m_93172_((PoseStack)poseStack, (int)(x + 30), (int)(height - boxHeight), (int)(x + 30 + 90), (int)height, (int)0x55000000);
        AmmoProvider ammoProvider = gun.getAmmoProvider();
        int ammoCount = ammoProvider.getMagazine().map(Magazine::getSize).orElse(0);
        int reserveSize = ammoProvider.getReserveSize();
        boolean empty = ammoCount == 0 && reserveSize == 0;
        String ammoText = empty ? I18n.m_118938_((String)"hud.empty_magazine", (Object[])new Object[0]) : String.valueOf(ammoCount);
        int ammoTextWidth = this.minecraft.f_91062_.m_92895_(ammoText);
        float reserveTextScale = 0.6f;
        String reserveText = " / " + reserveSize;
        int reserveTextWidth = (int)((float)this.minecraft.f_91062_.m_92895_(reserveText) * reserveTextScale);
        Font font = this.minecraft.f_91062_;
        float f = x + 55 - ammoTextWidth - (empty ? 0 : reserveTextWidth);
        int n = height - boxHeight / 2;
        Objects.requireNonNull(this.minecraft.f_91062_);
        font.m_92750_(poseStack, ammoText, f, (float)(n - 9 / 2), empty ? ChatFormatting.RED.m_126665_() : -1);
        if (!empty) {
            poseStack.m_85836_();
            poseStack.m_85837_((double)(x + 55 - reserveTextWidth), (double)((float)(height - boxHeight / 2) - reserveTextScale * 2.0f), 0.0);
            poseStack.m_85841_(reserveTextScale, reserveTextScale, reserveTextScale);
            this.minecraft.f_91062_.m_92750_(poseStack, reserveText, 0.0f, 0.0f, empty ? ChatFormatting.RED.m_126665_() : -1);
            poseStack.m_85849_();
        }
        String fireMode = I18n.m_118938_((String)gun.getFireMode().getTranslationKey(), (Object[])new Object[0]);
        this.minecraft.f_91062_.m_92750_(poseStack, fireMode, (float)(x + 65), (float)(height - 16), -1);
    }

    private static void renderProgress(PoseStack poseStack, Font font, int width, int height, Component message, @Nullable Component subMessage, float percent) {
        int barWidth = 100;
        int barHeight = 10;
        int barColour = -1056964609;
        float x = width / 2 - 50;
        float y = height / 2;
        String string = message.getString();
        Objects.requireNonNull(font);
        font.m_92750_(poseStack, string, x, y - 10.0f - ((float)(9 / 2) + 0.5f), 0xFFFFFF);
        RenderUtil.fillGradient(poseStack, x, y, x + 100.0f * percent, y + 10.0f, -1056964609, -1056964609);
        if (subMessage != null) {
            String string2 = subMessage.getString();
            Objects.requireNonNull(font);
            font.m_92750_(poseStack, string2, x, y + 10.0f + ((float)(9 / 2) + 0.5f), 0xFFFFFF);
        }
    }

    private void renderCombatMode(PlayerExtension<AbstractClientPlayer> player, PoseStack poseStack, int width, int height) {
        Inventory inventory = ((AbstractClientPlayer)player.getEntity()).m_150109_();
        int boxX = width - 115;
        int boxWidth = 110;
        int boxY = height - 170;
        int boxHeight = 30;
        int boxMarginY = 31;
        int currentItemIndex = inventory.f_35977_;
        ItemStack primaryStack = inventory.m_8020_(0);
        if (currentItemIndex == 0) {
            RenderUtil.fill(poseStack, boxX + 1, boxY + 1, boxWidth - 2, boxHeight - 2, -855638017);
        }
        RenderUtil.fill(poseStack, boxX, boxY, boxWidth, boxHeight, 0x66000000);
        this.minecraft.f_91062_.m_92750_(poseStack, "1", (float)(boxX + 5), (float)(boxY + 5), -1);
        PoseStack modelViewStack = RenderSystem.m_157191_();
        modelViewStack.m_85836_();
        modelViewStack.m_85837_((double)(boxX + boxWidth / 2 - 8), (double)(boxY + boxHeight / 2 - 8), 0.0);
        modelViewStack.m_85841_(1.2f, 1.2f, 1.2f);
        RenderUtil.renderGuiItem(primaryStack, 0, 0, -1, ItemTransforms.TransformType.FIXED);
        modelViewStack.m_85849_();
        RenderSystem.m_157182_();
        ItemStack secondaryStack = inventory.m_8020_(1);
        boxY += boxMarginY;
        if (currentItemIndex == 1) {
            RenderUtil.fill(poseStack, boxX + 1, boxY + 1, boxWidth - 2, boxHeight - 2, -855638017);
        }
        RenderUtil.fill(poseStack, boxX, boxY, boxWidth, boxHeight, 0x66000000);
        this.minecraft.f_91062_.m_92750_(poseStack, "2", (float)(boxX + 5), (float)(boxY + 5), -1);
        modelViewStack.m_85836_();
        modelViewStack.m_85837_((double)(boxX + boxWidth / 2 - 8), (double)(boxY + boxHeight / 2 - 8), 0.0);
        modelViewStack.m_85841_(1.2f, 1.2f, 1.2f);
        RenderUtil.renderGuiItem(secondaryStack, 0, 0, -1, ItemTransforms.TransformType.FIXED);
        modelViewStack.m_85849_();
        RenderSystem.m_157182_();
        ItemStack meleeStack = inventory.m_8020_(2);
        boxY += boxMarginY;
        if (currentItemIndex == 2) {
            RenderUtil.fill(poseStack, boxX + 1, boxY + 1, boxWidth - 2, boxHeight - 2, -855638017);
        }
        RenderUtil.fill(poseStack, boxX, boxY, boxWidth, boxHeight, 0x66000000);
        this.minecraft.f_91062_.m_92750_(poseStack, "3", (float)(boxX + 5), (float)(boxY + 5), -1);
        modelViewStack.m_85836_();
        modelViewStack.m_85837_((double)(boxX + boxWidth / 2 - 8), (double)(boxY + boxHeight / 2 - 8), 0.0);
        modelViewStack.m_85841_(1.2f, 1.2f, 1.2f);
        RenderUtil.renderGuiItem(meleeStack, 0, 0, -1, ItemTransforms.TransformType.FIXED);
        modelViewStack.m_85849_();
        RenderSystem.m_157182_();
        boxY += boxMarginY;
        boxHeight = 25;
        boxWidth = 25;
        for (int i = 0; i < 4; ++i) {
            ItemStack extraStack = inventory.m_8020_(3 + i);
            if (currentItemIndex == 3 + i) {
                RenderUtil.fill(poseStack, boxX + 1, boxY + 1, boxWidth - 2, boxHeight - 2, -855638017);
            }
            RenderUtil.fill(poseStack, boxX, boxY, boxWidth, boxHeight, 0x66000000);
            this.minecraft.f_91062_.m_92750_(poseStack, String.valueOf(4 + i), (float)(boxX + 1), (float)(boxY + 1), -1);
            RenderUtil.renderGuiItem(extraStack, boxX + boxWidth / 2 - 8, boxY + boxHeight / 2 - 6, -1);
            boxX += 28;
        }
        int healthBoxHeight = 25;
        float health = ((AbstractClientPlayer)player.getEntity()).m_21223_();
        int armour = ((AbstractClientPlayer)player.getEntity()).m_21230_();
        int healthWidth = 100;
        if (armour > 0) {
            healthWidth *= 2;
        }
        GuiComponent.m_93172_((PoseStack)poseStack, (int)0, (int)(height - 25), (int)healthWidth, (int)height, (int)0x55000000);
        RenderUtil.fillGradient(poseStack, healthWidth, height - 25, healthWidth + 40, height, 0x55000000, 0);
        RenderSystem.m_157456_((int)0, (ResourceLocation)HEALTH);
        RenderSystem.m_69478_();
        RenderUtil.blit(5.0f, height - 12 - 8, 16.0f, 16.0f);
        RenderSystem.m_69461_();
        Font font = this.minecraft.f_91062_;
        String string = String.valueOf(Math.round(health));
        Objects.requireNonNull(this.minecraft.f_91062_);
        GuiComponent.m_93208_((PoseStack)poseStack, (Font)font, (String)string, (int)31, (int)(height - 12 - 9 / 2), (int)-1);
        RenderUtil.fill(poseStack, 42, height - 12 - 5, 65, 10, 0x66000000);
        RenderUtil.fill(poseStack, 42, height - 12 - 5, Math.round(65.0f * (health / ((AbstractClientPlayer)player.getEntity()).m_21233_())), 10, -855638017);
        if (armour > 0) {
            int armourX = healthWidth / 2 + 7;
            RenderSystem.m_157456_((int)0, (ResourceLocation)SHIELD);
            RenderSystem.m_69478_();
            RenderUtil.blit(armourX + 5, height - 12 - 8, 16.0f, 16.0f);
            RenderSystem.m_69461_();
            Font font2 = this.minecraft.f_91062_;
            String string2 = String.valueOf(Math.round(armour));
            Objects.requireNonNull(this.minecraft.f_91062_);
            GuiComponent.m_93208_((PoseStack)poseStack, (Font)font2, (String)string2, (int)(armourX + 31), (int)(height - 12 - 9 / 2), (int)-1);
            RenderUtil.fill(poseStack, armourX + 42, height - 12 - 5, 65, 10, 0x66000000);
            RenderUtil.fill(poseStack, armourX + 42, height - 12 - 5, Math.round(65 * (armour / 20)), 10, -855638017);
        }
    }

    public void renderCrosshairs(PoseStack poseStack, float accuracy, float partialTicks, int width, int height) {
        float imageWidth = 16.0f;
        float imageHeight = 16.0f;
        float x = (float)width / 2.0f - 8.0f - 0.5f;
        float y = (float)height / 2.0f - 8.0f;
        float newSpread = (1.15f - accuracy) * 60.0f;
        float lerpSpread = Mth.m_14179_((float)0.5f, (float)this.lastSpread, (float)newSpread);
        Crosshair crosshair = this.client.getCrosshairManager().getCrosshair(this.crosshairLocation);
        poseStack.m_85836_();
        RenderSystem.m_69478_();
        RenderSystem.m_157456_((int)0, (ResourceLocation)crosshair.getMiddle());
        RenderUtil.blit(x, y, 16.0f, 16.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)crosshair.getTop());
        RenderUtil.blit(x, y - lerpSpread, 16.0f, 16.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)crosshair.getBottom());
        RenderUtil.blit(x, y + lerpSpread, 16.0f, 16.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)crosshair.getLeft());
        RenderUtil.blit(x - lerpSpread, y, 16.0f, 16.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)crosshair.getRight());
        RenderUtil.blit(x + lerpSpread, y, 16.0f, 16.0f);
        RenderSystem.m_69461_();
        poseStack.m_85849_();
        this.lastSpread = lerpSpread;
    }
}

