/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.client.animation.gun;

import com.craftingdead.core.client.animation.TimedAnimation;
import com.craftingdead.core.util.EasingFunction;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;

public class RifleShootAnimation
extends TimedAnimation {
    public RifleShootAnimation() {
        super(5);
    }

    @Override
    public void apply(float partialTicks, PoseStack poseStack) {
        float lerpProgress = this.lerpProgress(partialTicks);
        poseStack.m_85837_(0.0, 0.0, (double)RifleShootAnimation.getPushbackTranslation(lerpProgress));
        poseStack.m_85845_(RifleShootAnimation.getBounceRotation(lerpProgress));
    }

    private static Quaternion getBounceRotation(float lerpProgress) {
        float amplification = 3.0f;
        float easedProgress = EasingFunction.SINE_IN.andThen(EasingFunction.ELASTIC_OUT).apply(lerpProgress);
        return Vector3f.f_122223_.m_122240_(3.0f * Mth.m_14031_((float)(easedProgress * (float)Math.PI)));
    }

    private static float getPushbackTranslation(float lerpProgress) {
        float easedProgress = EasingFunction.EXPO_OUT.apply(lerpProgress);
        return Mth.m_14031_((float)(easedProgress * (float)Math.PI)) * 0.5f;
    }

    @Override
    public void applyArm(InteractionHand hand, HumanoidArm arm, float partialTicks, PoseStack poseStack) {
        float lerpProgress = this.lerpProgress(partialTicks);
        float translation = RifleShootAnimation.getPushbackTranslation(lerpProgress);
        switch (arm) {
            case LEFT: {
                poseStack.m_85837_(0.0, (double)(-translation * 0.5f), (double)translation);
                break;
            }
            case RIGHT: {
                poseStack.m_85837_(0.0, 0.0, (double)translation);
            }
        }
    }

    @Override
    public void applyCamera(float partialTicks, Vector3f rotations) {
    }
}

