/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.client.animation.gun;

import com.craftingdead.core.client.animation.TimedAnimation;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import net.minecraft.Util;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;

public class ReloadAnimation
extends TimedAnimation {
    private static final Vector3f MUTABLE_VEC = new Vector3f();

    public ReloadAnimation(int lifetimeTicks) {
        super(lifetimeTicks);
    }

    @Override
    public void apply(float partialTicks, PoseStack poseStack) {
        this.applyTranslations(partialTicks, poseStack);
    }

    @Override
    public void applyArm(InteractionHand hand, HumanoidArm arm, float partialTicks, PoseStack poseStack) {
        this.applyTranslations(partialTicks, poseStack);
    }

    private void applyTranslations(float partialTicks, PoseStack poseStack) {
        float sineProgress = Mth.m_14031_((float)(this.lerpProgress(partialTicks) * (float)Math.PI));
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(sineProgress * 30.0f));
        poseStack.m_85845_(Vector3f.f_122223_.m_122240_(sineProgress * -30.0f));
        poseStack.m_85837_(0.0, 0.0, (double)sineProgress / 4.0);
        ReloadAnimation.applyRandomMovements(MUTABLE_VEC, partialTicks);
        poseStack.m_85845_(Vector3f.f_122223_.m_122240_(MUTABLE_VEC.m_122239_()));
        poseStack.m_85845_(Vector3f.f_122227_.m_122240_(MUTABLE_VEC.m_122269_()));
    }

    @Override
    public void applyCamera(float partialTicks, Vector3f rotations) {
        ReloadAnimation.applyRandomMovements(rotations, partialTicks);
    }

    private static void applyRandomMovements(Vector3f vec, float partialTicks) {
        float time = (float)Util.m_137550_() / 20.0f;
        float angle1 = Mth.m_14031_((float)(time / 30.0f));
        float angle2 = Mth.m_14031_((float)(time / 25.0f));
        float angle3 = Mth.m_14031_((float)(time / 5.0f));
        float angle4 = Mth.m_14031_((float)(time / 15.0f));
        vec.setX(-2.0f * ((angle1 *= angle4) * 5.0f + (angle2 *= angle3 * angle4)));
        vec.setZ(2.0f * angle2);
    }
}

