/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.capability;

import com.craftingdead.core.capability.SerializableCapabilityProvider;
import com.craftingdead.core.capability.SimpleCapabilityProvider;
import it.unimi.dsi.fastutil.objects.ReferenceSet;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullFunction;
import net.minecraftforge.common.util.NonNullSupplier;

public class CapabilityUtil {
    public static <T extends CapabilityProvider<T>> Predicate<T> capabilityPresent(Capability<?> capability) {
        return provider -> provider.getCapability(capability).isPresent();
    }

    public static <T, R extends T> R getOrThrow(Capability<T> capability, ICapabilityProvider provider, Class<R> clazz) {
        R value = CapabilityUtil.get(capability, provider, clazz);
        if (value == null) {
            throw new IllegalStateException("Expecting capability: " + capability.getName());
        }
        return value;
    }

    @Nullable
    public static <T, R extends T> R get(Capability<T> capability, ICapabilityProvider provider, Class<R> clazz) {
        Object value = provider.getCapability(capability).orElse(null);
        return clazz.isInstance(value) ? (R)clazz.cast(value) : null;
    }

    @SafeVarargs
    public static <C extends INBTSerializable<CompoundTag>> ICapabilityProvider serializableProvider(NonNullSupplier<C> instanceSupplier, Capability<? super C> ... capabilities) {
        return CapabilityUtil.serializableProvider(CompoundTag::new, instanceSupplier, capabilities);
    }

    @SafeVarargs
    public static <C extends INBTSerializable<T>, T extends Tag> ICapabilityProvider serializableProvider(Supplier<T> emptyTag, NonNullSupplier<C> instanceSupplier, Capability<? super C> ... capabilities) {
        return CapabilityUtil.serializableProvider(emptyTag, LazyOptional.of(instanceSupplier), ReferenceSet.of((Object[])capabilities), null);
    }

    @SafeVarargs
    public static <C extends INBTSerializable<T>, T extends Tag> ICapabilityProvider serializableProvider(Supplier<T> emptyTag, LazyOptional<C> instance, Capability<? super C> ... capabilities) {
        return CapabilityUtil.serializableProvider(emptyTag, instance, ReferenceSet.of((Object[])capabilities), null);
    }

    public static <C extends INBTSerializable<T>, T extends Tag> ICapabilityProvider serializableProvider(Supplier<T> emptyTag, LazyOptional<C> instance, Set<Capability<? super C>> capabilities, @Nullable NonNullFunction<C, ICapabilityProvider> instanceMapper) {
        return new SerializableCapabilityProvider<C, T>(emptyTag, instance, capabilities, instanceMapper);
    }

    @SafeVarargs
    public static <C> ICapabilityProvider provider(NonNullSupplier<C> instanceSupplier, Capability<? super C> ... capabilities) {
        return CapabilityUtil.provider(LazyOptional.of(instanceSupplier), ReferenceSet.of((Object[])capabilities), null);
    }

    @SafeVarargs
    public static <C> ICapabilityProvider provider(LazyOptional<C> instance, Capability<? super C> ... capabilities) {
        return CapabilityUtil.provider(instance, ReferenceSet.of((Object[])capabilities), null);
    }

    public static <C> ICapabilityProvider provider(LazyOptional<C> instance, Set<Capability<? super C>> capabilities, @Nullable NonNullFunction<C, ICapabilityProvider> instanceMapper) {
        return new SimpleCapabilityProvider<C>(instance, capabilities, instanceMapper);
    }
}

