/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core;

import net.minecraft.world.level.Explosion;
import net.minecraftforge.common.ForgeConfigSpec;

public class ServerConfig {
    public final ForgeConfigSpec.BooleanValue burstfireEnabled;
    public final ForgeConfigSpec.IntValue burstfireShotsPerBurst;
    public final ForgeConfigSpec.BooleanValue reloadGunComeEmptyMag;
    public final ForgeConfigSpec.IntValue reloadDuration;
    public final ForgeConfigSpec.BooleanValue reloadDestroyMagWhenEmpty;
    public final ForgeConfigSpec.BooleanValue scopeAttachmentsAllowed;
    public final ForgeConfigSpec.DoubleValue scopeZoomMultiplier;
    public final ForgeConfigSpec.DoubleValue scopeZoomAccuracyMultiplier;
    public final ForgeConfigSpec.BooleanValue headshotEnabled;
    public final ForgeConfigSpec.DoubleValue headshotBonusDamage;
    public final ForgeConfigSpec.BooleanValue backstabEnabled;
    public final ForgeConfigSpec.DoubleValue backstabBonusDamage;
    public final ForgeConfigSpec.BooleanValue criticalHitEnable;
    public final ForgeConfigSpec.DoubleValue criticalHitBonusDamage;
    public final ForgeConfigSpec.DoubleValue criticalHitChance;
    public final ForgeConfigSpec.BooleanValue damageDropOffEnable;
    public final ForgeConfigSpec.DoubleValue damageDropOffLoss;
    public final ForgeConfigSpec.DoubleValue damageDropOffMinimumDamage;
    public final ForgeConfigSpec.BooleanValue explosivesRemoteDetonatorEnabled;
    public final ForgeConfigSpec.BooleanValue explosivesC4Enabled;
    public final ForgeConfigSpec.BooleanValue explosivesDecoyGrenadeEnabled;
    public final ForgeConfigSpec.BooleanValue explosivesFireGrenadeEnabled;
    public final ForgeConfigSpec.BooleanValue explosivesFlashGrenadeEnabled;
    public final ForgeConfigSpec.BooleanValue explosivesFragGrenadeEnabled;
    public final ForgeConfigSpec.BooleanValue explosivesSmokeGrenadeEnabled;
    public final ForgeConfigSpec.EnumValue<Explosion.BlockInteraction> explosivesC4ExplosionMode;
    public final ForgeConfigSpec.EnumValue<Explosion.BlockInteraction> explosivesFireGrenadeExplosionMode;
    public final ForgeConfigSpec.EnumValue<Explosion.BlockInteraction> explosivesFragGrenadeExplosionMode;
    public final ForgeConfigSpec.DoubleValue explosivesRemoteDetonatorRange;
    public final ForgeConfigSpec.DoubleValue explosivesC4Radius;
    public final ForgeConfigSpec.DoubleValue explosivesFireGrenadeRadius;
    public final ForgeConfigSpec.DoubleValue explosivesFlashRadius;
    public final ForgeConfigSpec.DoubleValue explosivesFragGrenadeRadius;
    public final ForgeConfigSpec.DoubleValue explosivesSmokeGrenadeRadius;
    public final ForgeConfigSpec.DoubleValue explosivesC4KnockbackMultiplier;
    public final ForgeConfigSpec.DoubleValue explosivesFireGrenadeKnockbackMultiplier;
    public final ForgeConfigSpec.DoubleValue explosivesFragGrenadeKnockbackMultiplier;
    public final ForgeConfigSpec.DoubleValue explosivesC4DamageMultiplier;
    public final ForgeConfigSpec.DoubleValue explosivesFireGrenadeDamageMultiplier;
    public final ForgeConfigSpec.DoubleValue explosivesFragGrenadeDamageMultiplier;
    public final ForgeConfigSpec.IntValue explosivesFlashGrenadeTicksBeforeActivation;
    public final ForgeConfigSpec.IntValue explosivesFragGrenadeTicksBeforeActivation;
    public final ForgeConfigSpec.IntValue explosivesDecoyGrenadeTicksBeforeDeactivation;
    public final ForgeConfigSpec.IntValue explosivesFlashGrenadeTicksBeforeDeactivation;
    public final ForgeConfigSpec.IntValue explosivesSmokeGrenadeTicksBeforeDeactivation;

    ServerConfig(ForgeConfigSpec.Builder builder) {
        builder.comment(new String[]{"Some guns allow 'burstfire', where it can fire multiple shots at the same time", "Here you can tweak all settings related to burstfire"}).push("burstfire");
        this.burstfireEnabled = builder.translation("options.craftingdead.server.burstfire.enable").comment("Enable (some) guns to fire a burst of shots").define("enable", true);
        this.burstfireShotsPerBurst = builder.translation("options.craftingdead.server.burstfire.shots_per_burst").comment("The amount of shots per fired burst").defineInRange("shotsPerBurst", 3, 1, Integer.MAX_VALUE);
        builder.pop();
        builder.comment("Tweak multiple behaviours on how guns should be reloaded as well it's ammo").push("reload");
        this.reloadGunComeEmptyMag = builder.translation("options.craftingdead.server.reload.gun_comes_empty_mag").comment("Defines whenever a gun should come with am empty magazine when crafted").define("gunComeEmptyMag", true);
        this.reloadDuration = builder.translation("options.craftingdead.server.reload.extra_reload_duration").comment("Additional reload time applied to the standard gun reload time (Ticks)").defineInRange("duration", 0, 0, 200);
        this.reloadDestroyMagWhenEmpty = builder.translation("options.craftingdead.server.destroy_mag_when_empty").comment("When empty, magazines will be destroyed instead of being given back to the player when reloading").define("destroyMagWhenEmpty", false);
        builder.pop();
        builder.comment("Tweak multiple scope and attachment behaviors").push("scope");
        this.scopeAttachmentsAllowed = builder.translation("options.craftingdead.server.scope.allow_attachments").comment(new String[]{"Defines if attachments can be added by the player", "Guns with pre existing attachments or that where added before this option was toggled will remain unchanged"}).define("attachmentsAllowed", true);
        this.scopeZoomMultiplier = builder.translation("options.craftingdead.server.zoom_amount_multiplier").comment("Additional zoom given to the base scope zoom (Multiplier)").defineInRange("zoomMultiplier", 1.0, 0.1, 3.0);
        this.scopeZoomAccuracyMultiplier = builder.translation("options.craftingdead.server.zoom_accuracy_multiplier").comment("Additional accuracy given when scoping (Multiplier)").defineInRange("zoomAccuracyMultiplier", 1.0, 0.1, 3.0);
        builder.pop();
        builder.comment("Tweak and toggle headshots and it's properties").push("headshot");
        this.headshotEnabled = builder.translation("options.craftingdead.server.headshot.enable").comment("Enables the ability to headshot").define("enabled", true);
        this.headshotBonusDamage = builder.translation("options.craftingdead.server.headshot.bonus_damage").comment("Additional bonus damage when a headshot is hit (Multiplier)").defineInRange("bonusDamage", 4.0, 1.0, 10.0);
        builder.pop();
        builder.comment("Tweak and toggle backstab and it's properties").push("backstab");
        this.backstabEnabled = builder.translation("options.craftingdead.server.backstab.enable").comment("Enables the ability to backstab with melee weapons").define("enabled", false);
        this.backstabBonusDamage = builder.translation("options.craftingdead.server.backstab.bonus_damage").comment("Additional bonus damage multiplier when backstabbing (Multiplier)").defineInRange("bonusDamage", 1.2, 1.0, 10.0);
        builder.pop();
        builder.comment("Tweak and toggle critical hits and it's properties").push("criticalHit");
        this.criticalHitEnable = builder.translation("options.craftingdead.server.critical_hit.enable").comment("Enables critical hits").define("enabled", false);
        this.criticalHitBonusDamage = builder.translation("options.craftingdead.server.critical_hit.bonus_damage").comment("Additional bonus damage multiplier when a critical hit (Multiplier)").defineInRange("bonusDamage", 0.5, 1.0, 10.0);
        this.criticalHitChance = builder.translation("options.craftingdead.server.critical_hit.chance").comment("How likely the player is to hit a critical hit (Percentage)").defineInRange("chance", 0.005, 0.0, 1.0);
        builder.pop();
        builder.comment("Distance based damage reduction applied to gun shots").push("damageDropOff");
        this.damageDropOffEnable = builder.translation("options.craftingdead.server.damage_drop_off.enable").comment("Enables damage dropoff").define("enable", false);
        this.damageDropOffLoss = builder.translation("options.craftingdead.server.damage_drop_off.loss").comment("How much damage is lost per block (Percentage)").defineInRange("loss", 0.1, 0.01, 100.0);
        this.damageDropOffMinimumDamage = builder.translation("options.craftingdead.server.damage_drop_off.min_damage").comment("The absolute minimum damage after all the loss is applied").defineInRange("minimumDamage", 2.0, 0.0, 20.0);
        builder.pop();
        builder.comment("Change every aspect of how grenades interact with the world").push("explosives");
        this.explosivesRemoteDetonatorEnabled = builder.translation("options.craftingdead.server.explosives.remote_detonator.enable").comment(new String[]{"Enables the usage of Remote Detonator", "It wont prevent the ability to get Remote Detonators, only the ability to use it"}).define("remoteDetonatorEnabled", true);
        this.explosivesC4Enabled = builder.translation("options.craftingdead.server.explosives.c4.enable").comment(new String[]{"Enables the usage of C4 Explosive", "It wont prevent the ability to get C4 Explosives, only the ability to use it"}).define("C4Enabled", true);
        this.explosivesDecoyGrenadeEnabled = builder.translation("options.craftingdead.server.explosives.decoy_grenade.enable").comment(new String[]{"Enables the usage of Decoy Grenade", "It wont prevent the ability to get Decoy Grenades, only the ability to use it"}).define("decoyGrenadeEnabled", true);
        this.explosivesFireGrenadeEnabled = builder.translation("options.craftingdead.server.explosives.fire_grenade.enable").comment(new String[]{"Enables the usage of Fire Grenade", "It wont prevent the ability to get Fire Grenades, only the ability to use it"}).define("fireGrenadeEnabled", true);
        this.explosivesFlashGrenadeEnabled = builder.translation("options.craftingdead.server.explosives.flash_grenade.enable").comment(new String[]{"Enables the usage of Flash Grenade", "It wont prevent the ability to get Flash Grenades, only the ability to use it"}).define("flashGrenadeEnabled", true);
        this.explosivesFragGrenadeEnabled = builder.translation("options.craftingdead.server.explosives.frag_grenade.enable").comment(new String[]{"Enables the usage of Frag Grenade", "It wont prevent the ability to get Frag Grenades, only the ability to use it"}).define("fragGrenadeEnabled", true);
        this.explosivesSmokeGrenadeEnabled = builder.translation("options.craftingdead.server.explosives.smoke_grenade.enable").comment(new String[]{"Enables the usage of Smoke Grenade", "It wont prevent the ability to get Smoke Grenade, only the ability to use it"}).define("smokeGrenadeEnabled", true);
        this.explosivesC4ExplosionMode = builder.translation("options.craftingdead.server.explosives.c4.mode").comment(new String[]{"Defines how the explosion should interact with blocks", "NONE: No block interaction, blocks will remain unchanged", "BREAK: Blocks are broken, they will be dropped when exploded", "DESTROY: Blocks are destroyed, nothing will be dropped and only a crater will be left"}).defineEnum("c4ExplosionMode", (Enum)Explosion.BlockInteraction.NONE);
        this.explosivesFireGrenadeExplosionMode = builder.translation("options.craftingdead.server.explosives.fire_grenade.mode").comment(new String[]{"Defines how the explosion should interact with blocks", "NONE: No block interaction, blocks will remain unchanged", "BREAK: Blocks are broken, they will be dropped when exploded", "DESTROY: Blocks are destroyed, nothing will be dropped and only a crater will be left"}).defineEnum("fireGrenadeExplosionMode", (Enum)Explosion.BlockInteraction.NONE);
        this.explosivesFragGrenadeExplosionMode = builder.translation("options.craftingdead.server.explosives.frag_grenade.mode").comment(new String[]{"Defines how the explosion should interact with blocks", "NONE: No block interaction, blocks will remain unchanged", "BREAK: Blocks are broken, they will be dropped when exploded", "DESTROY: Blocks are destroyed, nothing will be dropped and only a crater will be left"}).defineEnum("fragGrenadeExplosionMode", (Enum)Explosion.BlockInteraction.NONE);
        this.explosivesRemoteDetonatorRange = builder.translation("options.craftingdead.server.explosives.remote_detonator.range").comment("Activation range (in blocks) of the Remote Detonator").defineInRange("remoteDetonatorRange", 50.0, 1.0, 500.0);
        this.explosivesC4Radius = builder.translation("options.craftingdead.server.explosives.c4.radius").comment("The explosion radius (in blocks), it tells how big the explosion should be").defineInRange("c4Radius", 4.0, 0.1, 50.0);
        this.explosivesFireGrenadeRadius = builder.translation("options.craftingdead.server.explosives.fire_grenade.radius").comment("The explosion radius (in blocks), it tells how big the explosion should be").defineInRange("fireGrenadeRadius", 2.0, 0.1, 50.0);
        this.explosivesFlashRadius = builder.translation("options.craftingdead.server.explosives.flash_grenade.radius").comment("The flash radius (in blocks), it tells how big the flash should be").defineInRange("flashGrenadeRadius", 50.0, 0.1, 200.0);
        this.explosivesFragGrenadeRadius = builder.translation("options.craftingdead.server.explosives.frag_grenade.radius").comment("The explosion radius (in blocks), it tells how big the explosion should be").defineInRange("fragGrenadeRadius", 4.0, 0.1, 50.0);
        this.explosivesSmokeGrenadeRadius = builder.translation("options.craftingdead.server.explosives.smoke_grenade.radius").comment("The smoke cloud radius (in blocks), it tells how big the smoke cloud should be").defineInRange("smokeGrenadeRadius", 1.0, 0.1, 5.0);
        this.explosivesC4KnockbackMultiplier = builder.translation("options.craftingdead.server.explosives.c4.knockback").comment("Defines how strong the explosion knockback should be (Multiplier)").defineInRange("c4KnockbackMultiplier", 1.0, 0.0, 30.0);
        this.explosivesFireGrenadeKnockbackMultiplier = builder.translation("options.craftingdead.server.explosives.fire_grenade.knockback").comment("Defines how strong the explosion knockback should be (Multiplier)").defineInRange("fireGrenadeKnockbackMultiplier", 1.0, 0.0, 30.0);
        this.explosivesFragGrenadeKnockbackMultiplier = builder.translation("options.craftingdead.server.explosives.frag_grenade.knockback").comment("Defines how strong the explosion knockback should be (Multiplier)").defineInRange("fragGrenadeKnockbackMultiplier", 1.0, 0.0, 30.0);
        this.explosivesC4DamageMultiplier = builder.translation("options.craftingdead.server.explosives.c4.damage").comment("Multiplies the base damage given by the explosion (Multiplier)").defineInRange("c4DamageMultiplier", 1.0, 0.0, 30.0);
        this.explosivesFireGrenadeDamageMultiplier = builder.translation("options.craftingdead.server.explosives.fire_grenade.damage").comment("Multiplies the base damage given by the explosion (Multiplier)").defineInRange("fireGrenadeDamageMultiplier", 1.0, 0.0, 30.0);
        this.explosivesFragGrenadeDamageMultiplier = builder.translation("options.craftingdead.server.explosives.frag_grenade.damage").comment("Multiplies the base damage given by the explosion (Multiplier)").defineInRange("fragGrenadeDamageMultiplier", 1.0, 0.0, 30.0);
        this.explosivesFlashGrenadeTicksBeforeActivation = builder.translation("options.craftingdead.server.explosives.flash_grenade.activation_tick").comment("How long before the grenade activates automatically (Ticks)").defineInRange("flashGrenadeTicksBeforeActivation", 30, 0, 18000);
        this.explosivesFragGrenadeTicksBeforeActivation = builder.translation("options.craftingdead.server.explosives.frag_grenade.activation_tick").comment("How long before the grenade activates automatically (Ticks)").defineInRange("fragGrenadeTicksBeforeActivation", 35, 0, 18000);
        this.explosivesDecoyGrenadeTicksBeforeDeactivation = builder.translation("options.craftingdead.server.explosives.decoy_grenade.deactivation_tick").comment("How long before the grenade deactivates automatically (Ticks)").defineInRange("decoyGrenadeTicksBeforeDeactivation", 400, 0, 18000);
        this.explosivesFlashGrenadeTicksBeforeDeactivation = builder.translation("options.craftingdead.server.explosives.flash_grenade.deactivation_tick").comment("How long before the grenade deactivates automatically (Ticks)").defineInRange("flashGrenadeTicksBeforeDeactivation", 5, 0, 18000);
        this.explosivesSmokeGrenadeTicksBeforeDeactivation = builder.translation("options.craftingdead.server.explosives.smoke_grenade.deactivation_tick").comment("How long before the grenade deactivates automatically (Ticks)").defineInRange("smokeGrenadeTicksBeforeDeactivation", 500, 0, 18000);
        builder.pop();
    }
}

