/*
 * Decompiled with CFR 0.152.
 */
package terrablender.util;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.RegistryAccess;
import net.minecraft.data.BuiltinRegistries;

public class RegistryUtils {
    private static RegistryAccess registryAccess = BuiltinRegistries.f_206379_;
    private static List<Consumer<RegistryAccess>> registryAccessCaptureOneShotListeners = Lists.newArrayList();

    public static void captureCurrentRegistryAccess(RegistryAccess access) {
        registryAccess = access;
        registryAccessCaptureOneShotListeners.forEach(listener -> listener.accept(access));
        registryAccessCaptureOneShotListeners.clear();
    }

    public static void addRegistryAccessCaptureOneShotListener(Consumer<RegistryAccess> listener) {
        registryAccessCaptureOneShotListeners.add(listener);
    }

    public static RegistryAccess getCurrentRegistryAccess() {
        return registryAccess;
    }
}

