/*
 * Decompiled with CFR 0.152.
 */
package terrablender.mixin;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.MultiNoiseBiomeSource;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import terrablender.api.RegionType;
import terrablender.api.Regions;
import terrablender.util.RegistryUtils;
import terrablender.worldgen.IExtendedBiomeSource;
import terrablender.worldgen.IExtendedParameterList;

@Mixin(value={LevelStem.class})
public class MixinLevelStem {
    @Inject(method={"<init>(Lnet/minecraft/core/Holder;Lnet/minecraft/world/level/chunk/ChunkGenerator;)V"}, at={@At(value="RETURN")})
    public void onInit(Holder<DimensionType> dimensionType, ChunkGenerator chunkGenerator, CallbackInfo ci) {
        if (!(chunkGenerator instanceof NoiseBasedChunkGenerator) || !(chunkGenerator.m_62218_() instanceof MultiNoiseBiomeSource)) {
            return;
        }
        RegionType regionType = dimensionType.m_203565_(DimensionType.f_63846_) ? RegionType.NETHER : (dimensionType.m_203565_(DimensionType.f_63845_) ? RegionType.OVERWORLD : null);
        NoiseBasedChunkGenerator noiseBasedChunkGenerator = (NoiseBasedChunkGenerator)chunkGenerator;
        MultiNoiseBiomeSource biomeSource = (MultiNoiseBiomeSource)chunkGenerator.m_62218_();
        IExtendedBiomeSource biomeSourceEx = (IExtendedBiomeSource)biomeSource;
        if (regionType == null) {
            biomeSourceEx.appendDeferredBiomesList((List<Holder<Biome>>)ImmutableList.of());
            return;
        }
        Climate.ParameterList parameters = biomeSource.f_48435_;
        IExtendedParameterList parametersEx = (IExtendedParameterList)parameters;
        parametersEx.initializeForTerraBlender(regionType, noiseBasedChunkGenerator.f_64333_);
        RegistryUtils.addRegistryAccessCaptureOneShotListener(registryAccess -> {
            Registry biomeRegistry = registryAccess.m_175515_(Registry.f_122885_);
            ImmutableList.Builder builder = ImmutableList.builder();
            Regions.get(regionType).forEach(region -> region.addBiomes((Registry<Biome>)biomeRegistry, pair -> builder.add((Object)biomeRegistry.m_203538_((ResourceKey)pair.getSecond()))));
            biomeSourceEx.appendDeferredBiomesList((List<Holder<Biome>>)builder.build());
        });
    }
}

