/*
 * Decompiled with CFR 0.152.
 */
package mekanism.additions.common.entity;

import java.util.List;
import java.util.stream.Stream;
import mekanism.additions.common.config.AdditionsCommonConfig;
import mekanism.additions.common.config.MekanismAdditionsConfig;
import mekanism.additions.common.entity.baby.EntityBabyStray;
import mekanism.additions.common.registries.AdditionsEntityTypes;
import mekanism.common.Mekanism;
import mekanism.common.registration.impl.EntityTypeRegistryObject;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.common.world.MobSpawnSettingsBuilder;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.event.world.StructureSpawnListGatherEvent;

public class SpawnHelper {
    private SpawnHelper() {
    }

    public static void setupEntities() {
        SpawnHelper.registerSpawnControls(AdditionsEntityTypes.BABY_CREEPER, AdditionsEntityTypes.BABY_ENDERMAN, AdditionsEntityTypes.BABY_SKELETON, AdditionsEntityTypes.BABY_WITHER_SKELETON);
        SpawnPlacements.m_21754_((EntityType)((EntityType)AdditionsEntityTypes.BABY_STRAY.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, EntityBabyStray::spawnRestrictions);
        Parrot.f_29358_.put((EntityType)AdditionsEntityTypes.BABY_CREEPER.get(), SoundEvents.f_12247_);
        Parrot.f_29358_.put((EntityType)AdditionsEntityTypes.BABY_SKELETON.get(), SoundEvents.f_12266_);
        Parrot.f_29358_.put((EntityType)AdditionsEntityTypes.BABY_STRAY.get(), SoundEvents.f_12269_);
        Parrot.f_29358_.put((EntityType)AdditionsEntityTypes.BABY_WITHER_SKELETON.get(), SoundEvents.f_12222_);
    }

    @SafeVarargs
    private static void registerSpawnControls(EntityTypeRegistryObject<? extends Monster> ... entityTypeROs) {
        for (EntityTypeRegistryObject<? extends Monster> entityTypeRO : entityTypeROs) {
            SpawnPlacements.m_21754_((EntityType)((EntityType)entityTypeRO.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_33017_);
        }
    }

    private static MobSpawnSettings.SpawnerData getSpawner(AdditionsCommonConfig.SpawnConfig spawnConfig, MobSpawnSettings.SpawnerData parentEntry) {
        int weight = (int)Math.ceil((double)parentEntry.m_142631_().m_146281_() * spawnConfig.weightPercentage.get());
        int minSize = (int)Math.ceil((double)parentEntry.f_48405_ * spawnConfig.minSizePercentage.get());
        int maxSize = (int)Math.ceil((double)parentEntry.f_48406_ * spawnConfig.maxSizePercentage.get());
        return new MobSpawnSettings.SpawnerData(spawnConfig.entityTypeProvider.getEntityType(), weight, minSize, Math.max(minSize, maxSize));
    }

    private static Stream<AdditionsCommonConfig.SpawnConfig> getSpawnConfigs() {
        return Stream.of(MekanismAdditionsConfig.common.babyCreeper, MekanismAdditionsConfig.common.babyEnderman, MekanismAdditionsConfig.common.babySkeleton, MekanismAdditionsConfig.common.babyStray, MekanismAdditionsConfig.common.babyWitherSkeleton);
    }

    public static void onBiomeLoad(BiomeLoadingEvent event) {
        MobSpawnSettingsBuilder spawns = event.getSpawns();
        List monsterSpawns = spawns.getSpawner(MobCategory.MONSTER);
        if (!monsterSpawns.isEmpty()) {
            ResourceLocation biomeName = event.getName();
            SpawnHelper.getSpawnConfigs().filter(spawnConfig -> spawnConfig.shouldSpawn.get() && !((List)spawnConfig.biomeBlackList.get()).contains(biomeName)).forEach(spawnConfig -> {
                EntityType parent = spawnConfig.parentTypeProvider.getEntityType();
                monsterSpawns.stream().filter(monsterSpawn -> monsterSpawn.f_48404_ == parent).findFirst().ifPresent(parentEntry -> {
                    MobSpawnSettings.SpawnerData spawner = SpawnHelper.getSpawner(spawnConfig, parentEntry);
                    spawns.m_48376_(MobCategory.MONSTER, spawner);
                    MobSpawnSettings.MobSpawnCost parentCost = spawns.getCost(parent);
                    if (parentCost == null) {
                        Mekanism.logger.debug("Adding spawn rate for '{}' in biome '{}', with weight: {}, minSize: {}, maxSize: {}", (Object)spawner.f_48404_.getRegistryName(), (Object)biomeName, (Object)spawner.m_142631_(), (Object)spawner.f_48405_, (Object)spawner.f_48406_);
                    } else {
                        double spawnCostPerEntity = parentCost.m_48400_() * spawnConfig.spawnCostPerEntityPercentage.get();
                        double maxSpawnCost = parentCost.m_48395_() * spawnConfig.maxSpawnCostPercentage.get();
                        spawns.m_48370_(spawner.f_48404_, spawnCostPerEntity, maxSpawnCost);
                        Mekanism.logger.debug("Adding spawn rate for '{}' in biome '{}', with weight: {}, minSize: {}, maxSize: {}, spawnCostPerEntity: {}, maxSpawnCost: {}", (Object)spawner.f_48404_.getRegistryName(), (Object)biomeName, (Object)spawner.m_142631_(), (Object)spawner.f_48405_, (Object)spawner.f_48406_, (Object)spawnCostPerEntity, (Object)maxSpawnCost);
                    }
                });
            });
        }
    }

    public static void onStructureSpawnListGather(StructureSpawnListGatherEvent event) {
        List monsterSpawns = event.getEntitySpawns(MobCategory.MONSTER);
        if (!monsterSpawns.isEmpty()) {
            ResourceLocation structureName = event.getStructure().getRegistryName();
            SpawnHelper.getSpawnConfigs().filter(spawnConfig -> spawnConfig.shouldSpawn.get() && !((List)spawnConfig.structureBlackList.get()).contains(structureName)).forEach(spawnConfig -> {
                EntityType parent = spawnConfig.parentTypeProvider.getEntityType();
                monsterSpawns.stream().filter(monsterSpawn -> monsterSpawn.f_48404_ == parent).findFirst().ifPresent(parentEntry -> {
                    MobSpawnSettings.SpawnerData spawner = SpawnHelper.getSpawner(spawnConfig, parentEntry);
                    event.addEntitySpawn(MobCategory.MONSTER, spawner);
                    Mekanism.logger.debug("Adding spawn rate for '{}' in structure '{}', with weight: {}, minSize: {}, maxSize: {}", (Object)spawner.f_48404_.getRegistryName(), (Object)structureName, (Object)spawner.m_142631_(), (Object)spawner.f_48405_, (Object)spawner.f_48406_);
                });
            });
        }
    }
}

