/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.goldenhopper.world.level.block.entity;

import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.Hopper;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.VanillaInventoryCodeHooks;
import org.apache.commons.lang3.tuple.Pair;

public abstract class AbstractHopperBlockEntity
extends RandomizableContainerBlockEntity
implements Hopper {
    protected NonNullList<ItemStack> items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
    protected final int transferSpeed;
    protected int transferCooldown = -1;
    protected long tickedGameTime;

    protected AbstractHopperBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, int transferSpeed) {
        super(type, pos, state);
        this.transferSpeed = transferSpeed;
    }

    protected NonNullList<ItemStack> m_7086_() {
        return this.items;
    }

    protected void m_6520_(NonNullList<ItemStack> items) {
        this.items = items;
    }

    protected abstract Component m_6820_();

    protected abstract AbstractContainerMenu m_6555_(int var1, Inventory var2);

    public double m_6343_() {
        return (double)this.f_58858_.m_123341_() + 0.5;
    }

    public double m_6358_() {
        return (double)this.f_58858_.m_123342_() + 0.5;
    }

    public double m_6446_() {
        return (double)this.f_58858_.m_123343_() + 0.5;
    }

    public int m_6643_() {
        return 5;
    }

    public void setTransferCooldown(int transferCooldown) {
        this.transferCooldown = transferCooldown;
    }

    public boolean isCoolingDown() {
        return this.transferCooldown > 0;
    }

    public boolean isCustomCooldown() {
        return this.transferCooldown > this.transferSpeed;
    }

    public long getLastUpdateTime() {
        return this.tickedGameTime;
    }

    public boolean isInventoryFull() {
        return this.items.stream().noneMatch(stack -> stack.m_41619_() || stack.m_41613_() != stack.m_41741_());
    }

    public int[] getTransferableSlots() {
        return IntStream.range(0, this.items.size()).toArray();
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        if (!this.m_59631_(tag)) {
            ContainerHelper.m_18980_((CompoundTag)tag, this.items);
        }
        this.transferCooldown = tag.m_128451_("TransferCooldown");
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (!this.m_59634_(tag)) {
            ContainerHelper.m_18973_((CompoundTag)tag, this.items);
        }
        tag.m_128405_("TransferCooldown", this.transferCooldown);
    }

    public ItemStack m_7407_(int index, int count) {
        this.m_59640_(null);
        return ContainerHelper.m_18969_(this.m_7086_(), (int)index, (int)count);
    }

    public void m_6836_(int index, ItemStack stack) {
        this.m_59640_(null);
        this.m_7086_().set(index, (Object)stack);
        if (stack.m_41613_() > this.m_6893_()) {
            stack.m_41764_(this.m_6893_());
        }
    }

    protected abstract IItemHandler createUnSidedHandler();

    public static void serverTick(Level level, BlockPos pos, BlockState state, AbstractHopperBlockEntity hopper) {
        --hopper.transferCooldown;
        hopper.tickedGameTime = level.m_46467_();
        if (!hopper.isCoolingDown()) {
            hopper.setTransferCooldown(0);
            AbstractHopperBlockEntity.attemptTransferItems(level, pos, state, hopper, () -> HopperBlockEntity.m_155552_((Level)level, (Hopper)hopper));
        }
    }

    private static void attemptTransferItems(Level level, BlockPos pos, BlockState state, AbstractHopperBlockEntity hopper, Supplier<Boolean> supplier) {
        if (level.m_5776_()) {
            return;
        }
        if (hopper.isCoolingDown() || !((Boolean)hopper.m_58900_().m_61143_((Property)BlockStateProperties.f_61431_)).booleanValue()) {
            return;
        }
        boolean pushedItems = !hopper.m_7983_() && AbstractHopperBlockEntity.transferItems(level, pos, state, hopper);
        if (pushedItems |= !hopper.isInventoryFull() && supplier.get() != false) {
            hopper.setTransferCooldown(hopper.transferSpeed);
            hopper.m_6596_();
        }
    }

    private static boolean transferItems(Level level, BlockPos pos, BlockState state, AbstractHopperBlockEntity hopper) {
        if (AbstractHopperBlockEntity.transferItemsToCaps(level, state, hopper)) {
            return true;
        }
        Container container = AbstractHopperBlockEntity.getTargetContainer(level, pos, state);
        if (container == null) {
            return false;
        }
        Direction direction = ((Direction)state.m_61143_((Property)BlockStateProperties.f_61373_)).m_122424_();
        if (AbstractHopperBlockEntity.isContainerFull(container, direction)) {
            return false;
        }
        for (int index : hopper.getTransferableSlots()) {
            ItemStack stack = hopper.m_8020_(index);
            if (stack.m_41619_()) continue;
            ItemStack copyStack = stack.m_41777_();
            ItemStack resultStack = HopperBlockEntity.m_59326_((Container)hopper, (Container)container, (ItemStack)hopper.m_7407_(index, 1), (Direction)direction);
            if (resultStack.m_41619_()) {
                container.m_6596_();
                return true;
            }
            hopper.m_6836_(index, copyStack);
        }
        return false;
    }

    private static ItemStack attemptMoveStackToContainer(@Nullable Container source, Object target, IItemHandler handler, ItemStack stack, @Nullable Direction direction) {
        if (target instanceof WorldlyContainer) {
            WorldlyContainer worldlyContainer = (WorldlyContainer)target;
            if (direction != null) {
                int[] slots = worldlyContainer.m_7071_(direction);
                for (int i = 0; i < slots.length && !stack.m_41619_(); ++i) {
                    stack = AbstractHopperBlockEntity.attemptMoveStackToSlot(source, target, handler, stack, i, direction);
                }
                return stack;
            }
        }
        if (target instanceof Container) {
            Container container = (Container)target;
            for (int i = 0; i < container.m_6643_() && !stack.m_41619_(); ++i) {
                stack = AbstractHopperBlockEntity.attemptMoveStackToSlot(source, target, handler, stack, i, direction);
            }
            return stack;
        }
        for (int i = 0; i < handler.getSlots() && !stack.m_41619_(); ++i) {
            stack = AbstractHopperBlockEntity.attemptMoveStackToSlot(source, target, handler, stack, i, direction);
        }
        return stack;
    }

    private static ItemStack attemptMoveStackToSlot(@Nullable Container source, Object target, IItemHandler handler, ItemStack stack, int index, @Nullable Direction direction) {
        if (!AbstractHopperBlockEntity.canPlaceInContainerSlot(target, stack, index, direction)) {
            return stack;
        }
        boolean moved = false;
        boolean targetWasEmpty = !AbstractHopperBlockEntity.isItemHandlerEmpty(handler);
        ItemStack targetStack = handler.getStackInSlot(index);
        if (targetStack.m_41619_()) {
            stack = handler.insertItem(index, stack, false);
            moved = stack.m_41619_();
        } else if (AbstractHopperBlockEntity.canMergeStacks(stack, targetStack)) {
            int remaining = Math.min(stack.m_41613_(), stack.m_41741_() - targetStack.m_41613_());
            stack.m_41774_(remaining);
            targetStack.m_41769_(remaining);
            boolean bl = moved = remaining > 0;
        }
        if (moved) {
            if (targetWasEmpty) {
                AbstractHopperBlockEntity hopper;
                HopperBlockEntity hopper2;
                int cooldown = 0;
                if (target instanceof HopperBlockEntity && !(hopper2 = (HopperBlockEntity)target).m_59409_()) {
                    if (source instanceof AbstractHopperBlockEntity) {
                        AbstractHopperBlockEntity abstractHopper = (AbstractHopperBlockEntity)source;
                        if (hopper2.getLastUpdateTime() >= abstractHopper.tickedGameTime) {
                            cooldown = 1;
                        }
                    }
                    hopper2.m_59395_(8 - cooldown);
                } else if (target instanceof AbstractHopperBlockEntity && !(hopper = (AbstractHopperBlockEntity)((Object)target)).isCustomCooldown()) {
                    if (source instanceof AbstractHopperBlockEntity) {
                        AbstractHopperBlockEntity abstractHopper = (AbstractHopperBlockEntity)source;
                        if (hopper.getLastUpdateTime() >= abstractHopper.tickedGameTime) {
                            cooldown = 1;
                        }
                    }
                    hopper.setTransferCooldown(hopper.transferSpeed - cooldown);
                }
            }
            if (target instanceof Container) {
                Container container = (Container)target;
                container.m_6596_();
            }
        }
        return stack;
    }

    public static void entityCollide(Level level, BlockPos pos, BlockState state, Entity entity, AbstractHopperBlockEntity hopper) {
        if (entity instanceof ItemEntity && Shapes.m_83157_((VoxelShape)Shapes.m_83064_((AABB)entity.m_142469_().m_82386_((double)(-pos.m_123341_()), (double)(-pos.m_123342_()), (double)(-pos.m_123343_()))), (VoxelShape)hopper.m_59300_(), (BooleanOp)BooleanOp.f_82689_)) {
            AbstractHopperBlockEntity.attemptTransferItems(level, pos, state, hopper, () -> {
                AtomicBoolean returnValue = new AtomicBoolean(false);
                hopper.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).ifPresent(handler -> returnValue.set(AbstractHopperBlockEntity.addItemEntity((Container)hopper, handler, (ItemEntity)entity)));
                return returnValue.get();
            });
        }
    }

    public static boolean addItemEntity(Container container, IItemHandler handler, ItemEntity entity) {
        ItemStack copyStack = entity.m_32055_().m_41777_();
        ItemStack resultStack = AbstractHopperBlockEntity.attemptMoveStackToContainer(null, container, handler, copyStack, null);
        if (resultStack.m_41619_()) {
            entity.m_146870_();
            return true;
        }
        entity.m_32045_(resultStack);
        return false;
    }

    private static boolean transferItemsToCaps(Level level, BlockState state, AbstractHopperBlockEntity hopper) {
        Optional<Pair<IItemHandler, Object>> optional = AbstractHopperBlockEntity.getItemHandler(level, state, hopper);
        return optional.map(pair -> {
            IItemHandler handler = (IItemHandler)pair.getKey();
            if (AbstractHopperBlockEntity.isItemHandlerFull(handler)) {
                return false;
            }
            Object value = pair.getValue();
            for (int index : hopper.getTransferableSlots()) {
                ItemStack stack = hopper.m_8020_(index);
                if (stack.m_41619_()) continue;
                ItemStack copyStack = hopper.m_8020_(index).m_41777_();
                ItemStack insertStack = hopper.m_7407_(index, 1);
                ItemStack resultStack = AbstractHopperBlockEntity.attemptMoveStackToContainer((Container)hopper, value, handler, insertStack, ((Direction)state.m_61143_((Property)BlockStateProperties.f_61373_)).m_122424_());
                if (resultStack.m_41619_()) {
                    if (value instanceof Container) {
                        Container container = (Container)value;
                        container.m_6596_();
                    }
                    return true;
                }
                hopper.m_6836_(index, copyStack);
            }
            return false;
        }).orElse(false);
    }

    private static Optional<Pair<IItemHandler, Object>> getItemHandler(Level level, BlockState state, Hopper hopper) {
        Direction direction = (Direction)state.m_61143_((Property)BlockStateProperties.f_61373_);
        double x = hopper.m_6343_() + (double)direction.m_122429_();
        double y = hopper.m_6358_() + (double)direction.m_122430_();
        double z = hopper.m_6446_() + (double)direction.m_122431_();
        return VanillaInventoryCodeHooks.getItemHandler((Level)level, (double)x, (double)y, (double)z, (Direction)direction.m_122424_());
    }

    private static boolean isItemHandlerFull(IItemHandler handler) {
        return IntStream.range(0, handler.getSlots()).noneMatch(index -> {
            ItemStack stack = handler.getStackInSlot(index);
            return stack.m_41619_() || stack.m_41613_() < handler.getSlotLimit(index);
        });
    }

    private static boolean isItemHandlerEmpty(IItemHandler handler) {
        return IntStream.range(0, handler.getSlots()).noneMatch(index -> {
            ItemStack stack = handler.getStackInSlot(index);
            return stack.m_41619_();
        });
    }

    private static boolean canPlaceInContainerSlot(Object target, ItemStack stack, int index, @Nullable Direction direction) {
        if (target instanceof Container) {
            Container container = (Container)target;
            return container.m_7013_(index, stack) && (!(container instanceof WorldlyContainer) || ((WorldlyContainer)container).m_7155_(index, stack, direction));
        }
        return true;
    }

    private static boolean canMergeStacks(ItemStack source, ItemStack target) {
        return source.m_150930_(target.m_41720_()) && source.m_41773_() == target.m_41773_() && source.m_41613_() <= source.m_41741_() && ItemStack.m_41658_((ItemStack)source, (ItemStack)target);
    }

    @Nullable
    private static Container getTargetContainer(Level level, BlockPos pos, BlockState state) {
        return HopperBlockEntity.m_59390_((Level)level, (BlockPos)pos.m_142300_((Direction)state.m_61143_((Property)BlockStateProperties.f_61373_)));
    }

    private static boolean isContainerFull(Container container, Direction direction) {
        return AbstractHopperBlockEntity.getContainerSlots(container, direction).mapToObj(arg_0 -> ((Container)container).m_8020_(arg_0)).allMatch(stack -> stack.m_41613_() >= stack.m_41741_());
    }

    private static IntStream getContainerSlots(Container container, Direction direction) {
        return container instanceof WorldlyContainer ? IntStream.of(((WorldlyContainer)container).m_7071_(direction)) : IntStream.range(0, container.m_6643_());
    }
}

