/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.command.type;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.bracket.custom.RecipeTypeBracketHandler;
import com.blamejared.crafttweaker.api.command.CommandUtilities;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.plugin.ICommandRegistrationHandler;
import com.blamejared.crafttweaker.api.recipe.handler.IRecipeHandlerRegistry;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker.api.util.ItemStackUtil;
import com.blamejared.crafttweaker.mixin.common.access.recipe.AccessRecipeManager;
import com.blamejared.crafttweaker.platform.Services;
import java.util.Collection;
import java.util.Comparator;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;

public final class RecipeCommands {
    private RecipeCommands() {
    }

    public static void registerCommands(ICommandRegistrationHandler handler) {
        handler.registerRootCommand("recipes", (MutableComponent)new TranslatableComponent("crafttweaker.command.description.recipes"), builder -> builder.executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            return RecipeCommands.dumpRecipes((Player)player);
        }));
        handler.registerSubCommand("recipes", "hand", (MutableComponent)new TranslatableComponent("crafttweaker.command.description.recipes.hand"), builder -> builder.executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            return RecipeCommands.dumpHand((Player)player, player.m_21205_());
        }));
    }

    private static int dumpRecipes(Player player) {
        CraftTweakerAPI.LOGGER.info("Dumping all recipes!");
        ((AccessRecipeManager)player.f_19853_.m_7465_()).crafttweaker$getRecipes().forEach((recipeType, map) -> RecipeCommands.dumpRecipe(recipeType, map.values(), it -> true, false));
        CommandUtilities.send(CommandUtilities.openingLogFile(new TranslatableComponent("crafttweaker.command.list.check.log", new Object[]{CommandUtilities.makeNoticeable((MutableComponent)new TranslatableComponent("crafttweaker.command.misc.recipes.list")), CommandUtilities.getFormattedLogFile()}).m_130940_(ChatFormatting.GREEN)), player);
        return 1;
    }

    private static int dumpHand(Player player, ItemStack stack) {
        if (stack.m_41619_()) {
            CommandUtilities.send((Component)new TranslatableComponent("crafttweaker.command.recipes.hand.empty").m_130940_(ChatFormatting.RED), player);
            return 1;
        }
        IItemStack workingStack = Services.PLATFORM.createMCItemStack(stack.m_41777_()).setAmount(1);
        CraftTweakerAPI.LOGGER.info("Dumping all recipes that output {}!", (Object)ItemStackUtil.getCommandString(workingStack.getInternal()));
        ((AccessRecipeManager)player.f_19853_.m_7465_()).crafttweaker$getRecipes().forEach((recipeType, map) -> RecipeCommands.dumpRecipe(recipeType, map.values(), it -> workingStack.matches(Services.PLATFORM.createMCItemStack(it.m_8043_())), true));
        CommandUtilities.send(CommandUtilities.openingLogFile(new TranslatableComponent("crafttweaker.command.list.check.log", new Object[]{CommandUtilities.makeNoticeable((MutableComponent)new TranslatableComponent("crafttweaker.command.misc.recipes.list")), CommandUtilities.getFormattedLogFile()}).m_130940_(ChatFormatting.GREEN)), player);
        return 1;
    }

    private static void dumpRecipe(RecipeType<?> type, Collection<Recipe<?>> recipes, Predicate<Recipe<?>> filter, boolean hideEmpty) {
        IRecipeManager<Recipe<?>> manager = RecipeTypeBracketHandler.getOrDefault(type);
        if (manager == null) {
            return;
        }
        String dumpResult = recipes.stream().filter(filter).sorted(Comparator.comparing(RecipeCommands::serializer).thenComparing(Recipe::m_6423_)).map(it -> RecipeCommands.dump(manager, it)).collect(Collectors.joining("\n  "));
        if (hideEmpty && dumpResult.isEmpty()) {
            return;
        }
        CraftTweakerAPI.LOGGER.info("Recipe type: '{}'\n  {}\n", (Object)manager.getCommandString(), (Object)(dumpResult.isEmpty() ? "No recipe found" : dumpResult));
    }

    private static ResourceLocation serializer(Recipe<?> recipe) {
        return Objects.requireNonNull(Services.REGISTRY.getRegistryKey(recipe.m_7707_()));
    }

    private static <T extends Recipe<?>> String dump(IRecipeManager<?> manager, T recipe) {
        return IRecipeHandlerRegistry.getHandlerFor(recipe).dumpToCommandString(manager, recipe);
    }
}

