/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.command.type;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.command.CommandUtilities;
import com.blamejared.crafttweaker.api.loot.LootManager;
import com.blamejared.crafttweaker.api.plugin.ICommandRegistrationHandler;
import com.blamejared.crafttweaker.api.tag.CraftTweakerTagRegistry;
import com.blamejared.crafttweaker.api.tag.MCTag;
import com.blamejared.crafttweaker.api.tag.manager.ITagManager;
import com.blamejared.crafttweaker.api.villager.CTVillagerTrades;
import com.blamejared.crafttweaker.impl.command.CtCommands;
import com.blamejared.crafttweaker.mixin.common.access.recipe.AccessRecipeManager;
import com.blamejared.crafttweaker.natives.villager.ExpandVillagerProfession;
import com.blamejared.crafttweaker.platform.Services;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.context.CommandContext;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.Player;
import org.apache.logging.log4j.Logger;

public final class DumpCommands {
    private DumpCommands() {
    }

    public static void registerCommands(ICommandRegistrationHandler handler) {
        handler.registerRootCommand("dump_brackets", (MutableComponent)new TranslatableComponent("crafttweaker.command.description.dump.brackets"), builder -> builder.executes(context -> {
            DumpCommands.doFullBracketsDump((CommandContext<CommandSourceStack>)context);
            return 1;
        }));
        handler.registerRootCommand("dump", (MutableComponent)new TranslatableComponent("crafttweaker.command.description.dump"), builder -> builder.executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            CommandUtilities.send((Component)new TranslatableComponent("crafttweaker.command.dump.types").m_130946_(": "), (Player)player);
            CtCommands.get().commands().get("dump").subCommands().keySet().stream().map(it -> CommandUtilities.run(new TextComponent("- ").m_7220_((Component)new TextComponent(it).m_130940_(ChatFormatting.GREEN)), "/ct dump " + it)).forEach(it -> CommandUtilities.send(it, (Player)player));
            return 1;
        }));
    }

    public static void registerDumpers(ICommandRegistrationHandler handler) {
        DumpCommands.registerBracketDumpers(handler);
        DumpCommands.registerCustomDumpers(handler);
    }

    private static void registerBracketDumpers(ICommandRegistrationHandler handler) {
        CraftTweakerAPI.getRegistry().getAllLoaders().stream().map(CraftTweakerAPI.getRegistry()::getBracketDumpers).map(Map::values).flatMap(Collection::stream).distinct().forEach(it -> {
            String subCommandName = it.subCommandName();
            handler.registerDump(subCommandName, it.description(), builder -> builder.executes((Command)it));
        });
    }

    private static void registerCustomDumpers(ICommandRegistrationHandler handler) {
        handler.registerDump("recipes", (MutableComponent)new TranslatableComponent("crafttweaker.command.description.dump.recipes"), builder -> builder.executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            Services.REGISTRY.recipeTypes().stream().peek(type -> CraftTweakerAPI.LOGGER.info(type.toString())).map(it -> ((AccessRecipeManager)player.f_19853_.m_7465_()).crafttweaker$getRecipes().getOrDefault(it, Collections.emptyMap()).keySet()).flatMap(Collection::stream).map(ResourceLocation::toString).forEach(arg_0 -> ((Logger)CraftTweakerAPI.LOGGER).info(arg_0));
            CommandUtilities.send(CommandUtilities.openingLogFile(new TranslatableComponent("crafttweaker.command.list.check.log", new Object[]{CommandUtilities.makeNoticeable((MutableComponent)new TranslatableComponent("crafttweaker.command.misc.recipes")), CommandUtilities.getFormattedLogFile()}).m_130940_(ChatFormatting.GREEN)), (Player)player);
            return 1;
        }));
        handler.registerDump("loot_modifiers", (MutableComponent)new TranslatableComponent("crafttweaker.command.description.dump.loot_modifiers"), builder -> builder.executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            LootManager.INSTANCE.getModifierManager().getAllNames().forEach(arg_0 -> ((Logger)CraftTweakerAPI.LOGGER).info(arg_0));
            CommandUtilities.send(CommandUtilities.openingLogFile(new TranslatableComponent("crafttweaker.command.list.check.log", new Object[]{CommandUtilities.makeNoticeable((MutableComponent)new TranslatableComponent("crafttweaker.command.misc.loot_modifiers")), CommandUtilities.getFormattedLogFile()}).m_130940_(ChatFormatting.GREEN)), (Player)player);
            return 1;
        }));
        handler.registerDump("loot_tables", (MutableComponent)new TranslatableComponent("crafttweaker.command.description.dump.loot_tables"), builder -> builder.executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            MinecraftServer server = ((CommandSourceStack)context.getSource()).m_81377_();
            server.m_129898_().m_79195_().stream().map(ResourceLocation::toString).sorted().forEach(arg_0 -> ((Logger)CraftTweakerAPI.LOGGER).info(arg_0));
            CommandUtilities.send(CommandUtilities.openingLogFile(new TranslatableComponent("crafttweaker.command.list.check.log", new Object[]{CommandUtilities.makeNoticeable((MutableComponent)new TranslatableComponent("crafttweaker.command.misc.loot_tables")), CommandUtilities.getFormattedLogFile()}).m_130940_(ChatFormatting.GREEN)), (Player)player);
            return 1;
        }));
        handler.registerDump("villager_trades", (MutableComponent)new TranslatableComponent("crafttweaker.command.description.dump.villager.trades"), builder -> builder.executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            VillagerTrades.f_35627_.forEach((villagerProfession, levelToTrades) -> {
                CraftTweakerAPI.LOGGER.info("Trades for: " + ExpandVillagerProfession.getCommandString(villagerProfession));
                levelToTrades.keySet().intStream().sorted().filter(level -> ((VillagerTrades.ItemListing[])levelToTrades.getOrDefault(level, (Object)new VillagerTrades.ItemListing[0])).length > 0).peek(level -> CraftTweakerAPI.LOGGER.info("Level " + level + " trades")).mapToObj(level -> (VillagerTrades.ItemListing[])levelToTrades.getOrDefault(level, (Object)new VillagerTrades.ItemListing[0])).flatMap(Arrays::stream).forEach(iTrade -> {
                    String tradeStr = " - Unable to display trade.";
                    if (CTVillagerTrades.TRADE_CONVERTER.containsKey(iTrade.getClass())) {
                        tradeStr = CTVillagerTrades.TRADE_CONVERTER.get(iTrade.getClass()).apply((VillagerTrades.ItemListing)iTrade).toString();
                    }
                    CraftTweakerAPI.LOGGER.info(iTrade.getClass().getSimpleName() + tradeStr);
                });
            });
            CommandUtilities.send(CommandUtilities.openingLogFile(new TranslatableComponent("crafttweaker.command.list.check.log", new Object[]{CommandUtilities.makeNoticeable((MutableComponent)new TranslatableComponent("crafttweaker.command.misc.villager.trades")), CommandUtilities.getFormattedLogFile()}).m_130940_(ChatFormatting.GREEN)), (Player)player);
            return 1;
        }));
        handler.registerDump("wandering_trades", (MutableComponent)new TranslatableComponent("crafttweaker.command.description.dump.wandering.trades"), builder -> builder.executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            CraftTweakerAPI.LOGGER.info("Wandering Trader Trades");
            VillagerTrades.f_35628_.keySet().intStream().sorted().filter(level -> ((VillagerTrades.ItemListing[])VillagerTrades.f_35628_.getOrDefault(level, (Object)new VillagerTrades.ItemListing[0])).length > 0).peek(level -> CraftTweakerAPI.LOGGER.info("Level " + level + " trades")).mapToObj(level -> (VillagerTrades.ItemListing[])VillagerTrades.f_35628_.getOrDefault(level, (Object)new VillagerTrades.ItemListing[0])).flatMap(Arrays::stream).forEach(iTrade -> {
                String tradeStr = " - Unable to display trade.";
                if (CTVillagerTrades.TRADE_CONVERTER.containsKey(iTrade.getClass())) {
                    tradeStr = CTVillagerTrades.TRADE_CONVERTER.get(iTrade.getClass()).apply((VillagerTrades.ItemListing)iTrade).toString();
                }
                CraftTweakerAPI.LOGGER.info(iTrade.getClass().getSimpleName() + tradeStr);
            });
            CommandUtilities.send(CommandUtilities.openingLogFile(new TranslatableComponent("crafttweaker.command.list.check.log", new Object[]{CommandUtilities.makeNoticeable((MutableComponent)new TranslatableComponent("crafttweaker.command.misc.wandering.trades")), CommandUtilities.getFormattedLogFile()}).m_130940_(ChatFormatting.GREEN)), (Player)player);
            return 1;
        }));
        handler.registerDump("tag_contents", (MutableComponent)new TranslatableComponent("crafttweaker.command.description.dump.tag.contents"), builder -> builder.executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            CraftTweakerAPI.LOGGER.info("All Tag Contents");
            CraftTweakerTagRegistry.INSTANCE.managers().stream().sorted(Comparator.comparing(ITagManager::tagFolder)).peek(it -> CraftTweakerAPI.LOGGER.info("Contents of '{}' tags:", (Object)it.tagFolder())).flatMap(it -> it.tags().stream()).peek(it -> CraftTweakerAPI.LOGGER.info(it.getCommandString())).flatMap(it -> it.idElements().stream().map(o -> DumpCommands.getTagAsString(player, it, o))).forEach(it -> CraftTweakerAPI.LOGGER.info("\t- {}", it));
            CommandUtilities.send(CommandUtilities.openingLogFile(new TranslatableComponent("crafttweaker.command.list.check.log", new Object[]{CommandUtilities.makeNoticeable((MutableComponent)new TranslatableComponent("crafttweaker.command.misc.tag.contents")), CommandUtilities.getFormattedLogFile()}).m_130940_(ChatFormatting.GREEN)), (Player)player);
            return 1;
        }));
    }

    private static String getTagAsString(ServerPlayer player, MCTag tag, Object o) {
        if (o instanceof ResourceLocation) {
            return o.toString();
        }
        Optional foundRegistry = player.f_8924_.m_206579_().m_6632_(tag.manager().resourceKey());
        if (foundRegistry.isPresent()) {
            return foundRegistry.map(objects -> objects.m_7981_(o)).map(ResourceLocation::toString).orElse(o.toString());
        }
        return o.toString();
    }

    private static void doFullBracketsDump(CommandContext<CommandSourceStack> context) {
        Path directory = Services.PLATFORM.getPathFromGameDirectory("./ct_dumps");
        try {
            Files.createDirectories(directory, new FileAttribute[0]);
        }
        catch (IOException e) {
            CraftTweakerAPI.LOGGER.error("Could not create output folder '{}'", (Object)directory);
            return;
        }
        CraftTweakerAPI.getRegistry().getAllLoaders().stream().map(CraftTweakerAPI.getRegistry()::getBracketDumpers).map(Map::values).flatMap(Collection::stream).distinct().forEach(it -> {
            String dumpedFileName = it.dumpedFileName() + ".txt";
            Iterable iterable = () -> it.values().sorted().iterator();
            try {
                Files.write(directory.resolve(dumpedFileName), iterable, new OpenOption[0]);
            }
            catch (IOException e) {
                CraftTweakerAPI.LOGGER.error("Error writing to file '" + dumpedFileName + "'", (Throwable)e);
            }
        });
        CommandUtilities.send(CommandUtilities.openingFile(new TranslatableComponent("crafttweaker.command.files.created").m_130940_(ChatFormatting.GREEN), "ct_dumps"), (CommandSourceStack)context.getSource());
    }
}

