/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.zencode.expand;

import java.util.Arrays;
import java.util.List;
import org.openzen.zencode.shared.CodePosition;
import org.openzen.zencode.shared.CompileException;
import org.openzen.zenscript.codemodel.GenericName;
import org.openzen.zenscript.codemodel.OperatorType;
import org.openzen.zenscript.codemodel.expression.ArrayExpression;
import org.openzen.zenscript.codemodel.expression.CallArguments;
import org.openzen.zenscript.codemodel.expression.Expression;
import org.openzen.zenscript.codemodel.expression.MapExpression;
import org.openzen.zenscript.codemodel.expression.NewExpression;
import org.openzen.zenscript.codemodel.member.ref.FunctionalMemberRef;
import org.openzen.zenscript.codemodel.partial.IPartialExpression;
import org.openzen.zenscript.codemodel.scope.ExpressionScope;
import org.openzen.zenscript.codemodel.type.BasicTypeID;
import org.openzen.zenscript.codemodel.type.DefinitionTypeID;
import org.openzen.zenscript.codemodel.type.TypeID;
import org.openzen.zenscript.parser.expression.ParsedExpression;
import org.openzen.zenscript.parser.expression.ParsedExpressionArray;
import org.openzen.zenscript.parser.expression.ParsedExpressionMap;

public class IDataRewrites {
    public static final List<GenericName> IDATA_NAME = Arrays.asList(new GenericName("crafttweaker"), new GenericName("api"), new GenericName("data"), new GenericName("IData"));
    public static final List<GenericName> COLLECTION_DATA_NAME = Arrays.asList(new GenericName("crafttweaker"), new GenericName("api"), new GenericName("data"), new GenericName("ICollectionData"));
    public static final List<GenericName> LIST_DATA_NAME = Arrays.asList(new GenericName("crafttweaker"), new GenericName("api"), new GenericName("data"), new GenericName("ListData"));
    public static final List<GenericName> MAP_DATA_NAME = Arrays.asList(new GenericName("crafttweaker"), new GenericName("api"), new GenericName("data"), new GenericName("MapData"));

    public static IPartialExpression rewriteArray(ParsedExpressionArray parsedExpressionArray, ExpressionScope expressionScope) {
        List<TypeID> hints = expressionScope.hints;
        if (hints.size() != 1) {
            return null;
        }
        TypeID typeID = hints.get(0);
        if (typeID.isOptional()) {
            typeID = typeID.withoutOptional();
        }
        if (!(typeID instanceof DefinitionTypeID)) {
            return null;
        }
        DefinitionTypeID definitionTypeID = (DefinitionTypeID)typeID;
        String name = definitionTypeID.definition.name;
        boolean isListData = name.equals("ListData");
        if (!(isListData || name.equals("IData") || name.equals("ICollectionData"))) {
            return null;
        }
        CodePosition position = parsedExpressionArray.position;
        DefinitionTypeID iDataType = (DefinitionTypeID)expressionScope.getType(position, IDATA_NAME);
        DefinitionTypeID listType = (DefinitionTypeID)expressionScope.getType(position, LIST_DATA_NAME);
        DefinitionTypeID collectionType = (DefinitionTypeID)expressionScope.getType(position, COLLECTION_DATA_NAME);
        List<ParsedExpression> contents = parsedExpressionArray.contents;
        Expression[] cContent = new Expression[contents.size()];
        for (int i = 0; i < contents.size(); ++i) {
            ParsedExpression content = contents.get(i);
            try {
                cContent[i] = content.compile(expressionScope.withHint(iDataType)).eval().castExplicit(position, expressionScope, iDataType, false);
                continue;
            }
            catch (CompileException e) {
                return null;
            }
        }
        try {
            ArrayExpression arrayExpression = new ArrayExpression(position, cContent, (TypeID)expressionScope.getTypeRegistry().getArray(iDataType, 1));
            CallArguments arguments = new CallArguments(arrayExpression);
            if (isListData) {
                FunctionalMemberRef constructor = expressionScope.getTypeMembers(listType).getOrCreateGroup(OperatorType.CONSTRUCTOR).selectMethod(position, expressionScope, arguments, true, true);
                return new NewExpression(position, listType, constructor, arguments);
            }
            return expressionScope.getTypeMembers(collectionType).getGroup("getFromMembers").callStatic(position, collectionType, expressionScope, arguments);
        }
        catch (CompileException e) {
            return null;
        }
    }

    public static IPartialExpression rewriteMap(ParsedExpressionMap parsedExpressionMap, ExpressionScope expressionScope) {
        List<TypeID> hints = expressionScope.hints;
        if (hints.size() != 1) {
            return null;
        }
        TypeID typeID = hints.get(0);
        if (typeID.isOptional()) {
            typeID = typeID.withoutOptional();
        }
        if (!(typeID instanceof DefinitionTypeID) || !((DefinitionTypeID)typeID).definition.name.equals("IData") && !((DefinitionTypeID)typeID).definition.name.equals("MapData")) {
            return null;
        }
        CodePosition position = parsedExpressionMap.position;
        DefinitionTypeID mapDataType = (DefinitionTypeID)expressionScope.getType(position, MAP_DATA_NAME);
        DefinitionTypeID iDataType = (DefinitionTypeID)expressionScope.getType(position, IDATA_NAME);
        Expression[] cKeys = new Expression[parsedExpressionMap.keys.size()];
        Expression[] cValues = new Expression[parsedExpressionMap.values.size()];
        for (int i = 0; i < parsedExpressionMap.keys.size(); ++i) {
            if (parsedExpressionMap.keys.get(i) == null) {
                return null;
            }
            try {
                cKeys[i] = parsedExpressionMap.keys.get(i).compileKey(expressionScope.withHint(BasicTypeID.STRING));
                cValues[i] = parsedExpressionMap.values.get(i).compile(expressionScope.withHint(iDataType)).eval().castExplicit(position, expressionScope, iDataType, false);
                continue;
            }
            catch (CompileException e) {
                return null;
            }
        }
        try {
            MapExpression mapExpression = new MapExpression(position, cKeys, cValues, expressionScope.getTypeRegistry().getAssociative(BasicTypeID.STRING, iDataType));
            CallArguments arguments = new CallArguments(mapExpression);
            FunctionalMemberRef constructor = expressionScope.getTypeMembers(mapDataType).getOrCreateGroup(OperatorType.CONSTRUCTOR).selectMethod(position, expressionScope, arguments, true, true);
            return new NewExpression(position, mapDataType, constructor, arguments);
        }
        catch (CompileException e) {
            return null;
        }
    }
}

