/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import xfacthd.framedblocks.api.util.FramedProperties;
import xfacthd.framedblocks.api.util.SideSkipPredicate;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.StairsType;
import xfacthd.framedblocks.common.data.skippreds.StairsSkipPredicate;

public class VerticalHalfStairsSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean top = (Boolean)state.m_61143_((Property)FramedProperties.TOP);
        if (adjState.m_60713_((Block)FBContent.blockFramedVerticalHalfStairs.get())) {
            return VerticalHalfStairsSkipPredicate.testAgainstVerticalHalfStairs(level, pos, dir, top, adjState, side);
        }
        if (adjState.m_60713_((Block)FBContent.blockFramedVerticalStairs.get())) {
            return VerticalHalfStairsSkipPredicate.testAgainstVerticalStairs(level, pos, dir, top, adjState, side);
        }
        if (adjState.m_60713_((Block)FBContent.blockFramedSlab.get())) {
            return VerticalHalfStairsSkipPredicate.testAgainstSlab(level, pos, dir, top, adjState, side);
        }
        if (adjState.m_60713_((Block)FBContent.blockFramedDoubleSlab.get())) {
            return VerticalHalfStairsSkipPredicate.testAgainstDoubleSlab(level, pos, dir, top, side);
        }
        if (adjState.m_60713_((Block)FBContent.blockFramedSlabEdge.get())) {
            return VerticalHalfStairsSkipPredicate.testAgainstSlabEdge(level, pos, dir, top, adjState, side);
        }
        if (adjState.m_60713_((Block)FBContent.blockFramedSlabCorner.get())) {
            return VerticalHalfStairsSkipPredicate.testAgainstSlabCorner(level, pos, dir, top, adjState, side);
        }
        if (adjState.m_60713_((Block)FBContent.blockFramedStairs.get())) {
            return VerticalHalfStairsSkipPredicate.testAgainstStairs(level, pos, dir, top, adjState, side);
        }
        if (adjState.m_60713_((Block)FBContent.blockFramedHalfStairs.get())) {
            return VerticalHalfStairsSkipPredicate.testAgainstHalfStairs(level, pos, dir, top, adjState, side);
        }
        if (adjState.m_60713_((Block)FBContent.blockFramedSlopeSlab.get())) {
            return VerticalHalfStairsSkipPredicate.testAgainstSlopeSlab(level, pos, dir, top, adjState, side);
        }
        if (adjState.m_60713_((Block)FBContent.blockFramedElevatedSlopeSlab.get())) {
            return VerticalHalfStairsSkipPredicate.testAgainstElevatedSlopeSlab(level, pos, dir, top, adjState, side);
        }
        if (adjState.m_60713_((Block)FBContent.blockFramedDoubleSlopeSlab.get())) {
            return VerticalHalfStairsSkipPredicate.testAgainstDoubleSlopeSlab(level, pos, dir, top, adjState, side);
        }
        if (adjState.m_60713_((Block)FBContent.blockFramedInverseDoubleSlopeSlab.get())) {
            return VerticalHalfStairsSkipPredicate.testAgainstInverseDoubleSlopeSlab(level, pos, dir, top, adjState, side);
        }
        return false;
    }

    private static boolean testAgainstVerticalHalfStairs(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (side == Direction.UP && top || side == Direction.DOWN && !top) {
            if (adjTop == top || adjDir != dir) {
                return false;
            }
            return SideSkipPredicate.compareState(level, pos, side);
        }
        if (side == dir.m_122424_() && adjDir == dir.m_122428_() || side == dir.m_122427_() && adjDir == dir.m_122427_()) {
            return adjTop == top && SideSkipPredicate.compareState(level, pos, side);
        }
        if (side == dir && adjDir == dir.m_122428_() || side == dir.m_122428_() && adjDir == dir.m_122427_()) {
            return adjTop == top && SideSkipPredicate.compareState(level, pos, side);
        }
        return false;
    }

    private static boolean testAgainstVerticalStairs(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        StairsType adjType = (StairsType)((Object)adjState.m_61143_(PropertyHolder.STAIRS_TYPE));
        if (side == Direction.DOWN && !top && !adjType.isTop() || side == Direction.UP && top && !adjType.isBottom()) {
            return adjDir == dir && SideSkipPredicate.compareState(level, pos, side);
        }
        return false;
    }

    private static boolean testAgainstSlab(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (adjTop == top && (side == dir || side == dir.m_122428_())) {
            return SideSkipPredicate.compareState(level, pos, side);
        }
        return false;
    }

    private static boolean testAgainstDoubleSlab(BlockGetter level, BlockPos pos, Direction dir, boolean top, Direction side) {
        if (side == dir || side == dir.m_122428_()) {
            return SideSkipPredicate.compareState(level, pos, side, top ? Direction.UP : Direction.DOWN);
        }
        return false;
    }

    private static boolean testAgainstSlabEdge(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        if (Utils.isY(side)) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (adjTop != top) {
            return false;
        }
        if ((side == dir || side == dir.m_122428_()) && adjDir == side.m_122424_()) {
            return SideSkipPredicate.compareState(level, pos, side);
        }
        if (side == dir.m_122427_() && adjDir == dir || side == dir.m_122424_() && adjDir == dir.m_122428_()) {
            return SideSkipPredicate.compareState(level, pos, side);
        }
        return false;
    }

    private static boolean testAgainstSlabCorner(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (adjTop == top && adjDir == dir && (side == dir.m_122424_() || side == dir.m_122427_())) {
            return SideSkipPredicate.compareState(level, pos, side);
        }
        return false;
    }

    private static boolean testAgainstStairs(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)BlockStateProperties.f_61374_);
        boolean adjTop = adjState.m_61143_((Property)StairBlock.f_56842_) == Half.TOP;
        StairsShape adjShape = (StairsShape)adjState.m_61143_((Property)StairBlock.f_56843_);
        if (adjTop != top || !StairsSkipPredicate.isSlabSide(adjShape, adjDir, side.m_122424_())) {
            return false;
        }
        if (side == dir || side == dir.m_122428_()) {
            return SideSkipPredicate.compareState(level, pos, side);
        }
        return false;
    }

    private static boolean testAgainstHalfStairs(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (adjTop == top && (side == dir.m_122424_() || side == dir.m_122427_()) && adjDir == side) {
            return SideSkipPredicate.compareState(level, pos, side);
        }
        return false;
    }

    private static boolean testAgainstSlopeSlab(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)PropertyHolder.TOP_HALF);
        if (adjTop == top && (side == dir || side == dir.m_122428_()) && adjDir == side.m_122424_()) {
            return SideSkipPredicate.compareState(level, pos, side);
        }
        return false;
    }

    private static boolean testAgainstElevatedSlopeSlab(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (adjTop == top && (side == dir || side == dir.m_122428_()) && adjDir == side) {
            return SideSkipPredicate.compareState(level, pos, side);
        }
        return false;
    }

    private static boolean testAgainstDoubleSlopeSlab(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)PropertyHolder.TOP_HALF);
        if (!(adjTop != top || side != dir && side != dir.m_122428_() || adjDir != side && adjDir != side.m_122424_())) {
            return SideSkipPredicate.compareState(level, pos, side);
        }
        return false;
    }

    private static boolean testAgainstInverseDoubleSlopeSlab(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        if (side != dir && side != dir.m_122428_()) {
            return false;
        }
        if (!top && adjDir == side || top && adjDir == side.m_122424_()) {
            return SideSkipPredicate.compareState(level, pos, side);
        }
        return false;
    }
}

