/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import xfacthd.framedblocks.api.util.FramedProperties;
import xfacthd.framedblocks.api.util.SideSkipPredicate;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.skippreds.StairsSkipPredicate;

public class SlabSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        if (Utils.isY(side)) {
            return SideSkipPredicate.CTM.test(level, pos, state, adjState, side);
        }
        boolean top = (Boolean)state.m_61143_((Property)PropertyHolder.TOP);
        if (adjState.m_60734_() == FBContent.blockFramedSlab.get()) {
            return SlabSkipPredicate.testAgainstSlab(level, pos, top, adjState, side);
        }
        if (adjState.m_60734_() == FBContent.blockFramedDoubleSlab.get()) {
            return SlabSkipPredicate.testAgainstDoubleSlab(level, pos, top, side);
        }
        if (adjState.m_60734_() == FBContent.blockFramedSlabEdge.get()) {
            return SlabSkipPredicate.testAgainstEdge(level, pos, top, adjState, side);
        }
        if (adjState.m_60734_() == FBContent.blockFramedStairs.get()) {
            return SlabSkipPredicate.testAgainstStairs(level, pos, top, adjState, side);
        }
        if (adjState.m_60713_((Block)FBContent.blockFramedSlopeSlab.get())) {
            return SlabSkipPredicate.testAgainstSlopeSlab(level, pos, top, adjState, side);
        }
        if (adjState.m_60713_((Block)FBContent.blockFramedElevatedSlopeSlab.get())) {
            return SlabSkipPredicate.testAgainstElevatedSlopeSlab(level, pos, top, adjState, side);
        }
        if (adjState.m_60713_((Block)FBContent.blockFramedDoubleSlopeSlab.get())) {
            return SlabSkipPredicate.testAgainstDoubleSlopeSlab(level, pos, top, adjState, side);
        }
        if (adjState.m_60713_((Block)FBContent.blockFramedInverseDoubleSlopeSlab.get())) {
            return SlabSkipPredicate.testAgainstInverseDoubleSlopeSlab(level, pos, top, adjState, side);
        }
        if (adjState.m_60713_((Block)FBContent.blockFramedVerticalHalfStairs.get())) {
            return SlabSkipPredicate.testAgainstVerticalHalfStairs(level, pos, top, adjState, side);
        }
        return false;
    }

    private static boolean testAgainstSlab(BlockGetter level, BlockPos pos, boolean top, BlockState adjState, Direction side) {
        if (top != (Boolean)adjState.m_61143_((Property)PropertyHolder.TOP)) {
            return false;
        }
        return SideSkipPredicate.compareState(level, pos, side, top ? Direction.UP : Direction.DOWN);
    }

    private static boolean testAgainstDoubleSlab(BlockGetter level, BlockPos pos, boolean top, Direction side) {
        Direction face = top ? Direction.UP : Direction.DOWN;
        return SideSkipPredicate.compareState(level, pos, side, face);
    }

    private static boolean testAgainstEdge(BlockGetter level, BlockPos pos, boolean top, BlockState adjState, Direction side) {
        if (top != (Boolean)adjState.m_61143_((Property)PropertyHolder.TOP)) {
            return false;
        }
        if (adjState.m_61143_((Property)PropertyHolder.FACING_HOR) != side.m_122424_()) {
            return false;
        }
        return SideSkipPredicate.compareState(level, pos, side, top ? Direction.UP : Direction.DOWN);
    }

    private static boolean testAgainstStairs(BlockGetter level, BlockPos pos, boolean top, BlockState adjState, Direction side) {
        boolean adjTop;
        Direction adjDir = (Direction)adjState.m_61143_((Property)BlockStateProperties.f_61374_);
        StairsShape adjShape = (StairsShape)adjState.m_61143_((Property)BlockStateProperties.f_61398_);
        boolean bl = adjTop = adjState.m_61143_((Property)BlockStateProperties.f_61402_) == Half.TOP;
        if (top == adjTop && StairsSkipPredicate.isSlabSide(adjShape, adjDir, side.m_122424_())) {
            return SideSkipPredicate.compareState(level, pos, side);
        }
        return false;
    }

    private static boolean testAgainstSlopeSlab(BlockGetter level, BlockPos pos, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTopHalf = (Boolean)adjState.m_61143_((Property)PropertyHolder.TOP_HALF);
        if (Utils.isY(side)) {
            return false;
        }
        return adjDir == side.m_122424_() && adjTopHalf == top && SideSkipPredicate.compareState(level, pos, side, top ? Direction.UP : Direction.DOWN);
    }

    private static boolean testAgainstElevatedSlopeSlab(BlockGetter level, BlockPos pos, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (Utils.isY(side)) {
            return false;
        }
        return adjDir == side && adjTop == top && SideSkipPredicate.compareState(level, pos, side, top ? Direction.UP : Direction.DOWN);
    }

    private static boolean testAgainstDoubleSlopeSlab(BlockGetter level, BlockPos pos, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTopHalf = (Boolean)adjState.m_61143_((Property)PropertyHolder.TOP_HALF);
        if (Utils.isY(side)) {
            return false;
        }
        return (adjDir == side || adjDir == side.m_122424_()) && adjTopHalf == top && SideSkipPredicate.compareState(level, pos, side, top ? Direction.UP : Direction.DOWN);
    }

    private static boolean testAgainstInverseDoubleSlopeSlab(BlockGetter level, BlockPos pos, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        if (Utils.isY(side)) {
            return false;
        }
        return (adjDir == side && !top || adjDir == side.m_122424_() && top) && SideSkipPredicate.compareState(level, pos, side, top ? Direction.UP : Direction.DOWN);
    }

    private static boolean testAgainstVerticalHalfStairs(BlockGetter level, BlockPos pos, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (Utils.isY(side)) {
            return false;
        }
        if (adjTop == top && (adjDir == side.m_122424_() || adjDir == side.m_122428_())) {
            return SideSkipPredicate.compareState(level, pos, side, top ? Direction.UP : Direction.DOWN);
        }
        return false;
    }
}

