/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Locale;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.type.IBlockType;
import xfacthd.framedblocks.api.util.CtmPredicate;
import xfacthd.framedblocks.api.util.SideSkipPredicate;
import xfacthd.framedblocks.api.util.VoxelShapeGenerator;
import xfacthd.framedblocks.common.block.FramedCollapsibleBlock;
import xfacthd.framedblocks.common.block.FramedCornerPillarBlock;
import xfacthd.framedblocks.common.block.FramedCornerSlopeBlock;
import xfacthd.framedblocks.common.block.FramedDoorBlock;
import xfacthd.framedblocks.common.block.FramedDoubleCornerBlock;
import xfacthd.framedblocks.common.block.FramedDoublePanelBlock;
import xfacthd.framedblocks.common.block.FramedDoubleSlopeBlock;
import xfacthd.framedblocks.common.block.FramedDoubleSlopeSlabBlock;
import xfacthd.framedblocks.common.block.FramedDoubleThreewayCornerBlock;
import xfacthd.framedblocks.common.block.FramedElevatedSlopeSlabBlock;
import xfacthd.framedblocks.common.block.FramedFenceBlock;
import xfacthd.framedblocks.common.block.FramedFloorBlock;
import xfacthd.framedblocks.common.block.FramedGateBlock;
import xfacthd.framedblocks.common.block.FramedHalfPillarBlock;
import xfacthd.framedblocks.common.block.FramedHalfStairsBlock;
import xfacthd.framedblocks.common.block.FramedInverseDoubleSlopeSlabBlock;
import xfacthd.framedblocks.common.block.FramedLatticeBlock;
import xfacthd.framedblocks.common.block.FramedPanelBlock;
import xfacthd.framedblocks.common.block.FramedPillarBlock;
import xfacthd.framedblocks.common.block.FramedPrismBlock;
import xfacthd.framedblocks.common.block.FramedPrismCornerBlock;
import xfacthd.framedblocks.common.block.FramedSlabBlock;
import xfacthd.framedblocks.common.block.FramedSlabCornerBlock;
import xfacthd.framedblocks.common.block.FramedSlabEdgeBlock;
import xfacthd.framedblocks.common.block.FramedSlopeBlock;
import xfacthd.framedblocks.common.block.FramedSlopeSlabBlock;
import xfacthd.framedblocks.common.block.FramedSlopedPrismBlock;
import xfacthd.framedblocks.common.block.FramedStairsBlock;
import xfacthd.framedblocks.common.block.FramedThreewayCornerBlock;
import xfacthd.framedblocks.common.block.FramedTrapDoorBlock;
import xfacthd.framedblocks.common.block.FramedVerticalHalfStairsBlock;
import xfacthd.framedblocks.common.block.FramedVerticalStairs;
import xfacthd.framedblocks.common.block.FramedWallBlock;
import xfacthd.framedblocks.common.block.FramedWallSignBlock;
import xfacthd.framedblocks.common.data.skippreds.CollapsibleBlockSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.CornerPillarSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.CornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.DoorSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.ElevatedSlopeSlabSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.HalfPillarSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.HalfStairsSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.InnerCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.InnerThreewayCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.PaneSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.PanelSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.PillarSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.PostSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.SlabCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.SlabEdgeSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.SlabSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.SlopeSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.SlopeSlabSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.StairsSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.ThreewayCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.VerticalHalfStairsSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.VerticalStairsSkipPredicate;

public enum BlockType implements IBlockType
{
    FRAMED_CUBE(true, false, false, false, true, true, false, SideSkipPredicate.CTM, Shapes.m_83144_(), CtmPredicate.TRUE),
    FRAMED_SLOPE(true, true, false, true, true, true, false, FramedSlopeBlock.CTM_PREDICATE, new SlopeSkipPredicate(), FramedSlopeBlock::generateShapes),
    FRAMED_CORNER_SLOPE(true, true, false, true, true, true, false, FramedCornerSlopeBlock.CTM_PREDICATE, new CornerSkipPredicate(), FramedCornerSlopeBlock::generateCornerShapes),
    FRAMED_INNER_CORNER_SLOPE(true, true, false, true, true, true, false, FramedCornerSlopeBlock.CTM_PREDICATE_INNER, new InnerCornerSkipPredicate(), FramedCornerSlopeBlock::generateInnerCornerShapes),
    FRAMED_PRISM_CORNER(true, true, false, true, true, true, false, CtmPredicate.FALSE, new ThreewayCornerSkipPredicate(), FramedPrismCornerBlock::generatePrismShapes),
    FRAMED_INNER_PRISM_CORNER(true, true, false, true, true, true, false, FramedThreewayCornerBlock.CTM_PREDICATE, new InnerThreewayCornerSkipPredicate(), FramedPrismCornerBlock::generateInnerPrismShapes),
    FRAMED_THREEWAY_CORNER(true, true, false, true, true, true, false, CtmPredicate.FALSE, new ThreewayCornerSkipPredicate(), FramedThreewayCornerBlock::generateThreewayShapes),
    FRAMED_INNER_THREEWAY_CORNER(true, true, false, true, true, true, false, FramedThreewayCornerBlock.CTM_PREDICATE, new InnerThreewayCornerSkipPredicate(), FramedThreewayCornerBlock::generateInnerThreewayShapes),
    FRAMED_SLAB(true, false, false, true, true, true, false, FramedSlabBlock.CTM_PREDICATE, new SlabSkipPredicate(), FramedSlabBlock::generateShapes),
    FRAMED_SLAB_EDGE(false, false, false, true, true, true, false, CtmPredicate.FALSE, new SlabEdgeSkipPredicate(), FramedSlabEdgeBlock::generateShapes),
    FRAMED_SLAB_CORNER(false, false, false, true, true, true, false, CtmPredicate.FALSE, new SlabCornerSkipPredicate(), FramedSlabCornerBlock::generateShapes),
    FRAMED_PANEL(true, false, false, true, true, true, false, FramedPanelBlock.CTM_PREDICATE, new PanelSkipPredicate(), FramedPanelBlock::generateShapes),
    FRAMED_CORNER_PILLAR(false, false, false, true, true, true, false, CtmPredicate.FALSE, new CornerPillarSkipPredicate(), FramedCornerPillarBlock::generateShapes),
    FRAMED_STAIRS(true, false, false, true, true, true, false, new StairsSkipPredicate(), FramedStairsBlock.CTM_PREDICATE),
    FRAMED_WALL(false, false, false, true, true, false, false, FramedWallBlock.SKIP_PREDICATE, CtmPredicate.FALSE),
    FRAMED_FENCE(false, false, false, true, true, false, false, FramedFenceBlock.SKIP_PREDICATE, CtmPredicate.FALSE),
    FRAMED_GATE(false, false, false, true, true, false, false, FramedGateBlock.SKIP_PREDICATE, CtmPredicate.FALSE),
    FRAMED_DOOR(true, false, false, false, true, false, false, new DoorSkipPredicate(), FramedDoorBlock.CTM_PREDICATE),
    FRAMED_TRAPDOOR(true, false, false, true, true, false, false, SideSkipPredicate.CTM, FramedTrapDoorBlock.CTM_PREDICATE),
    FRAMED_PRESSURE_PLATE(false, false, false, false, true, false, false),
    FRAMED_LADDER(false, false, false, true, true, false, false),
    FRAMED_BUTTON(false, false, false, false, true, false, false),
    FRAMED_LEVER(false, false, false, false, true, false, false),
    FRAMED_SIGN(false, false, true, false, true, false, false),
    FRAMED_WALL_SIGN(false, false, true, false, false, false, false, CtmPredicate.FALSE, SideSkipPredicate.FALSE, FramedWallSignBlock::generateShapes),
    FRAMED_DOUBLE_SLAB(true, false, true, false, true, true, true, SideSkipPredicate.FALSE, Shapes.m_83144_(), CtmPredicate.Y_AXIS),
    FRAMED_DOUBLE_PANEL(true, false, true, false, true, true, true, SideSkipPredicate.FALSE, Shapes.m_83144_(), FramedDoublePanelBlock.CTM_PREDICATE),
    FRAMED_DOUBLE_SLOPE(true, false, true, false, true, true, true, SideSkipPredicate.FALSE, Shapes.m_83144_(), FramedDoubleSlopeBlock.CTM_PREDICATE),
    FRAMED_DOUBLE_CORNER(true, false, true, false, true, true, true, SideSkipPredicate.FALSE, Shapes.m_83144_(), FramedDoubleCornerBlock.CTM_PREDICATE),
    FRAMED_DOUBLE_PRISM_CORNER(true, false, true, false, true, true, true, SideSkipPredicate.FALSE, Shapes.m_83144_(), FramedDoubleThreewayCornerBlock.CTM_PREDICATE),
    FRAMED_DOUBLE_THREEWAY_CORNER(true, false, true, false, true, true, true, SideSkipPredicate.FALSE, Shapes.m_83144_(), FramedDoubleThreewayCornerBlock.CTM_PREDICATE),
    FRAMED_TORCH(false, false, false, false, true, false, false),
    FRAMED_WALL_TORCH(false, false, false, false, false, false, false),
    FRAMED_SOUL_TORCH(false, false, false, false, true, false, false),
    FRAMED_SOUL_WALL_TORCH(false, false, false, false, false, false, false),
    FRAMED_FLOOR_BOARD(true, false, false, true, true, true, false, FramedFloorBlock.SKIP_PREDICATE, Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.0625, (double)1.0), FramedFloorBlock.CTM_PREDICATE),
    FRAMED_LATTICE_BLOCK(false, false, false, true, true, true, false, CtmPredicate.FALSE, FramedLatticeBlock.SKIP_PREDICATE, FramedLatticeBlock::generateShapes),
    FRAMED_VERTICAL_STAIRS(true, false, false, true, true, true, false, FramedVerticalStairs.CTM_PREDICATE, new VerticalStairsSkipPredicate(), FramedVerticalStairs::generateShapes),
    FRAMED_CHEST(false, false, true, true, true, false, false, SideSkipPredicate.FALSE, Shapes.m_83048_((double)0.0625, (double)0.0, (double)0.0625, (double)0.9375, (double)0.875, (double)0.9375), CtmPredicate.FALSE),
    FRAMED_BARS(false, false, false, true, true, true, false, SideSkipPredicate.FALSE, CtmPredicate.FALSE),
    FRAMED_PANE(false, false, false, true, true, true, false, new PaneSkipPredicate(), CtmPredicate.FALSE),
    FRAMED_RAIL_SLOPE(true, true, false, true, true, false, false, FramedSlopeBlock.CTM_PREDICATE, new SlopeSkipPredicate(), FramedSlopeBlock::generateShapes),
    FRAMED_FLOWER_POT(false, false, true, false, true, false, false, SideSkipPredicate.FALSE, Shapes.m_83048_((double)0.3125, (double)0.0, (double)0.3125, (double)0.6875, (double)0.375, (double)0.6875), CtmPredicate.FALSE),
    FRAMED_PILLAR(false, false, false, true, true, true, false, CtmPredicate.FALSE, new PillarSkipPredicate(), FramedPillarBlock::generatePillarShapes),
    FRAMED_HALF_PILLAR(false, false, false, true, true, true, false, CtmPredicate.FALSE, new HalfPillarSkipPredicate(), FramedHalfPillarBlock::generateShapes),
    FRAMED_POST(false, false, false, true, true, true, false, CtmPredicate.FALSE, new PostSkipPredicate(), FramedPillarBlock::generatePostShapes),
    FRAMED_COLLAPSIBLE_BLOCK(false, true, true, true, true, true, false, new CollapsibleBlockSkipPredicate(), FramedCollapsibleBlock.CTM_PREDICATE),
    FRAMED_HALF_STAIRS(false, false, false, true, true, true, false, CtmPredicate.FALSE, new HalfStairsSkipPredicate(), FramedHalfStairsBlock::generateShapes),
    FRAMED_BOUNCY_CUBE(true, false, false, false, true, false, false, SideSkipPredicate.CTM, Shapes.m_83144_(), CtmPredicate.TRUE),
    FRAMED_SECRET_STORAGE(true, false, true, false, true, false, false, SideSkipPredicate.CTM, Shapes.m_83144_(), CtmPredicate.TRUE),
    FRAMED_PRISM(true, true, false, true, true, true, false, FramedPrismBlock.CTM_PREDICATE, FramedPrismBlock.SKIP_PREDICATE, FramedPrismBlock::generateShapes),
    FRAMED_SLOPED_PRISM(true, true, false, true, true, true, false, FramedSlopedPrismBlock.CTM_PREDICATE, FramedSlopedPrismBlock.SKIP_PREDICATE, FramedSlopedPrismBlock::generateShapes),
    FRAMED_SLOPE_SLAB(true, true, false, true, true, true, false, FramedSlopeSlabBlock.CTM_PREDICATE, new SlopeSlabSkipPredicate(), FramedSlopeSlabBlock::generateShapes),
    FRAMED_ELEVATED_SLOPE_SLAB(true, true, true, true, true, true, false, FramedElevatedSlopeSlabBlock.CTM_PREDICATE, new ElevatedSlopeSlabSkipPredicate(), FramedElevatedSlopeSlabBlock::generateShapes),
    FRAMED_DOUBLE_SLOPE_SLAB(true, false, true, true, true, true, true, SideSkipPredicate.FALSE, FramedDoubleSlopeSlabBlock.CTM_PREDICATE),
    FRAMED_INV_DOUBLE_SLOPE_SLAB(true, true, true, true, true, true, true, CtmPredicate.FALSE, SideSkipPredicate.FALSE, FramedInverseDoubleSlopeSlabBlock::generateShapes),
    FRAMED_VERTICAL_HALF_STAIRS(false, false, false, true, true, false, false, CtmPredicate.FALSE, new VerticalHalfStairsSkipPredicate(), FramedVerticalHalfStairsBlock::generateShapes);

    private final String name = this.toString().toLowerCase(Locale.ROOT);
    private final boolean canOcclude;
    private final boolean specialHitbox;
    private final boolean specialTile;
    private final boolean waterloggable;
    private final boolean blockItem;
    private final boolean allowIntangible;
    private final boolean doubleBlock;
    private final CtmPredicate ctmPredicate;
    private final SideSkipPredicate skipPredicate;
    private final VoxelShapeGenerator shapeGen;

    private BlockType(boolean canOcclude, boolean specialHitbox, boolean specialTile, boolean waterloggable, boolean blockItem, boolean allowIntangible, boolean doubleBlock) {
        this(canOcclude, specialHitbox, specialTile, waterloggable, blockItem, allowIntangible, doubleBlock, CtmPredicate.FALSE, SideSkipPredicate.FALSE, VoxelShapeGenerator.EMTPTY);
    }

    private BlockType(boolean canOcclude, boolean specialHitbox, boolean specialTile, boolean waterloggable, boolean blockItem, boolean allowIntangible, boolean doubleBlock, SideSkipPredicate skipPredicate, CtmPredicate ctmPredicate) {
        this(canOcclude, specialHitbox, specialTile, waterloggable, blockItem, allowIntangible, doubleBlock, ctmPredicate, skipPredicate, VoxelShapeGenerator.EMTPTY);
    }

    private BlockType(boolean canOcclude, boolean specialHitbox, boolean specialTile, boolean waterloggable, boolean blockItem, boolean allowIntangible, boolean doubleBlock, SideSkipPredicate skipPredicate, VoxelShape shape, CtmPredicate ctmPredicate) {
        this(canOcclude, specialHitbox, specialTile, waterloggable, blockItem, allowIntangible, doubleBlock, ctmPredicate, skipPredicate, VoxelShapeGenerator.singleShape(shape));
    }

    private BlockType(boolean canOcclude, boolean specialHitbox, boolean specialTile, boolean waterloggable, boolean blockItem, boolean allowIntangible, boolean doubleBlock, CtmPredicate ctmPredicate, SideSkipPredicate skipPredicate, VoxelShapeGenerator shapeGen) {
        this.canOcclude = canOcclude;
        this.specialHitbox = specialHitbox;
        this.specialTile = specialTile;
        this.waterloggable = waterloggable;
        this.blockItem = blockItem;
        this.allowIntangible = allowIntangible;
        this.doubleBlock = doubleBlock;
        this.ctmPredicate = ctmPredicate;
        this.skipPredicate = skipPredicate;
        this.shapeGen = shapeGen;
    }

    @Override
    public boolean canOccludeWithSolidCamo() {
        return this.canOcclude;
    }

    @Override
    public boolean hasSpecialHitbox() {
        return this.specialHitbox;
    }

    @Override
    public CtmPredicate getCtmPredicate() {
        return this.ctmPredicate;
    }

    @Override
    public SideSkipPredicate getSideSkipPredicate() {
        return this.skipPredicate;
    }

    @Override
    public ImmutableMap<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        return this.shapeGen.generate(states);
    }

    @Override
    public boolean hasSpecialTile() {
        return this.specialTile;
    }

    @Override
    public boolean hasBlockItem() {
        return this.blockItem;
    }

    @Override
    public boolean supportsWaterLogging() {
        return this.waterloggable;
    }

    @Override
    public boolean allowMakingIntangible() {
        return this.allowIntangible;
    }

    @Override
    public boolean isDoubleBlock() {
        return this.doubleBlock;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int compareTo(IBlockType other) {
        if (!(other instanceof BlockType)) {
            return 1;
        }
        BlockType type = (BlockType)other;
        return this.compareTo(type);
    }
}

