/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.world.module;

import com.google.common.collect.Maps;
import java.util.ArrayDeque;
import java.util.Map;
import java.util.Queue;
import java.util.function.BooleanSupplier;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import vazkii.quark.base.block.IQuarkBlock;
import vazkii.quark.base.block.QuarkBlock;
import vazkii.quark.base.block.QuarkBlockWrapper;
import vazkii.quark.base.handler.VariantHandler;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.ModuleLoader;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.base.module.config.Config;
import vazkii.quark.base.module.config.type.DimensionConfig;
import vazkii.quark.base.world.WorldGenHandler;
import vazkii.quark.base.world.generator.OreGenerator;
import vazkii.quark.content.world.block.MyaliteBlock;
import vazkii.quark.content.world.config.BigStoneClusterConfig;
import vazkii.quark.content.world.config.StoneTypeConfig;
import vazkii.quark.content.world.module.BigStoneClustersModule;

@LoadModule(category=ModuleCategory.WORLD, hasSubscriptions=true)
public class NewStoneTypesModule
extends QuarkModule {
    @Config(flag="limestone")
    private static boolean enableLimestone = true;
    @Config(flag="jasper")
    private static boolean enableJasper = true;
    @Config(flag="shale")
    private static boolean enableShale = true;
    @Config(flag="myalite")
    private static boolean enableMyalite = true;
    public static boolean enabledWithLimestone;
    public static boolean enabledWithJasper;
    public static boolean enabledWithShale;
    public static boolean enabledWithMyalite;
    @Config
    public static StoneTypeConfig limestone;
    @Config
    public static StoneTypeConfig jasper;
    @Config
    public static StoneTypeConfig shale;
    @Config
    public static StoneTypeConfig myalite;
    public static Block limestoneBlock;
    public static Block jasperBlock;
    public static Block shaleBlock;
    public static Block myaliteBlock;
    public static Map<Block, Block> polishedBlocks;
    private static Queue<Runnable> defers;

    @Override
    public void register() {
        limestoneBlock = NewStoneTypesModule.makeStone(this, "limestone", limestone, BigStoneClustersModule.limestone, () -> enableLimestone, MaterialColor.f_76409_);
        jasperBlock = NewStoneTypesModule.makeStone(this, "jasper", jasper, BigStoneClustersModule.jasper, () -> enableJasper, MaterialColor.f_76386_);
        shaleBlock = NewStoneTypesModule.makeStone(this, "shale", shale, BigStoneClustersModule.shale, () -> enableShale, MaterialColor.f_76403_);
        myaliteBlock = NewStoneTypesModule.makeStone(this, null, "myalite", myalite, BigStoneClustersModule.myalite, () -> enableMyalite, MaterialColor.f_76422_, MyaliteBlock::new);
    }

    public static Block makeStone(QuarkModule module, String name, StoneTypeConfig config, BigStoneClusterConfig bigConfig, BooleanSupplier enabledCond, MaterialColor color) {
        return NewStoneTypesModule.makeStone(module, null, name, config, bigConfig, enabledCond, color, QuarkBlock::new);
    }

    public static Block makeStone(QuarkModule module, Block raw, String name, StoneTypeConfig config, BigStoneClusterConfig bigConfig, BooleanSupplier enabledCond, MaterialColor color, QuarkBlock.Constructor<QuarkBlock> constr) {
        BooleanSupplier trueEnabledCond = () -> (bigConfig == null || !bigConfig.enabled || !ModuleLoader.INSTANCE.isModuleEnabled(BigStoneClustersModule.class)) && enabledCond.getAsBoolean();
        BlockBehaviour.Properties props = raw != null ? BlockBehaviour.Properties.m_60926_((BlockBehaviour)raw) : BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)color).m_60999_().m_60913_(1.5f, 6.0f);
        Object normal = raw != null ? raw : constr.make(name, module, CreativeModeTab.f_40749_, props).setCondition(enabledCond);
        QuarkBlock polished = constr.make("polished_" + name, module, CreativeModeTab.f_40749_, props).setCondition(enabledCond);
        polishedBlocks.put((Block)normal, (Block)polished);
        VariantHandler.addSlabStairsWall(normal instanceof IQuarkBlock ? (IQuarkBlock)normal : new QuarkBlockWrapper((Block)normal, module));
        VariantHandler.addSlabAndStairs(polished);
        if (raw == null) {
            defers.add(() -> NewStoneTypesModule.lambda$makeStone$5(module, config, (Block)normal, trueEnabledCond));
        }
        return normal;
    }

    @Override
    public void configChanged() {
        enabledWithLimestone = enableLimestone && this.enabled;
        enabledWithJasper = enableJasper && this.enabled;
        enabledWithShale = enableShale && this.enabled;
        enabledWithMyalite = enableMyalite && this.enabled;
    }

    @Override
    public void setup() {
        while (!defers.isEmpty()) {
            defers.poll().run();
        }
    }

    private static /* synthetic */ void lambda$makeStone$5(QuarkModule module, StoneTypeConfig config, Block normal, BooleanSupplier trueEnabledCond) {
        WorldGenHandler.addGenerator(module, new OreGenerator(config.dimensions, config.oregenLower, normal.m_49966_(), OreGenerator.ALL_DIMS_STONE_MATCHER, trueEnabledCond), GenerationStep.Decoration.UNDERGROUND_ORES, 1);
        WorldGenHandler.addGenerator(module, new OreGenerator(config.dimensions, config.oregenUpper, normal.m_49966_(), OreGenerator.ALL_DIMS_STONE_MATCHER, trueEnabledCond), GenerationStep.Decoration.UNDERGROUND_ORES, 1);
    }

    static {
        limestone = new StoneTypeConfig();
        jasper = new StoneTypeConfig();
        shale = new StoneTypeConfig();
        myalite = new StoneTypeConfig(DimensionConfig.end(false));
        polishedBlocks = Maps.newHashMap();
        defers = new ArrayDeque<Runnable>();
    }
}

