/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.world.gen;

import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.common.Tags;
import vazkii.quark.base.module.config.type.DimensionConfig;
import vazkii.quark.base.world.generator.Generator;
import vazkii.quark.content.world.module.FairyRingsModule;

public class FairyRingGenerator
extends Generator {
    public FairyRingGenerator(DimensionConfig dimConfig) {
        super(dimConfig);
    }

    @Override
    public void generateChunk(WorldGenRegion worldIn, ChunkGenerator generator, Random rand, BlockPos corner) {
        int x = corner.m_123341_() + rand.nextInt(16);
        int z = corner.m_123343_() + rand.nextInt(16);
        BlockPos center = new BlockPos(x, 128, z);
        Holder<Biome> biome = this.getBiome((LevelAccessor)worldIn, center, false);
        Biome.BiomeCategory category = Biome.m_204183_(biome);
        double chance = 0.0;
        if (category == Biome.BiomeCategory.FOREST) {
            chance = FairyRingsModule.forestChance;
        } else if (category == Biome.BiomeCategory.PLAINS) {
            chance = FairyRingsModule.plainsChance;
        }
        if (rand.nextDouble() < chance) {
            BlockPos pos = center;
            BlockState state = worldIn.m_8055_(pos);
            while (state.m_60767_() != Material.f_76315_ && pos.m_123342_() > 30) {
                pos = pos.m_7495_();
                state = worldIn.m_8055_(pos);
            }
            if (state.m_60767_() == Material.f_76315_) {
                FairyRingGenerator.spawnFairyRing((WorldGenLevel)worldIn, generator, pos.m_7495_(), biome, rand);
            }
        }
    }

    public static void spawnFairyRing(WorldGenLevel world, ChunkGenerator generator, BlockPos pos, Holder<Biome> biome, Random rand) {
        List features = ((Biome)biome.m_203334_()).m_47536_().m_47815_();
        Holder holder = features.isEmpty() ? null : ((RandomPatchConfiguration)((ConfiguredFeature)features.get(0)).f_65378_()).f_191304_();
        BlockState flowerState = holder == null ? Blocks.f_50120_.m_49966_() : null;
        for (int i = -3; i <= 3; ++i) {
            block1: for (int j = -3; j <= 3; ++j) {
                BlockPos fpos;
                int k;
                float dist = i * i + j * j;
                if (dist < 7.0f || dist > 10.0f) {
                    for (k = 6; k > -3; --k) {
                        fpos = pos.m_142082_(i, k, j);
                        BlockState state = world.m_8055_(fpos);
                        if (!state.m_204336_(BlockTags.f_13037_)) continue;
                        world.m_7731_(fpos, Blocks.f_50016_.m_49966_(), 2);
                        continue block1;
                    }
                    continue;
                }
                for (k = 5; k > -4; --k) {
                    fpos = pos.m_142082_(i, k, j);
                    BlockPos fposUp = fpos.m_7494_();
                    BlockState state = world.m_8055_(fpos);
                    if (state.m_60767_() != Material.f_76315_ || !world.m_46859_(fposUp)) continue;
                    if (flowerState == null) {
                        ((PlacedFeature)holder.m_203334_()).m_191782_(world, generator, rand, fposUp);
                        flowerState = world.m_8055_(fposUp);
                        continue block1;
                    }
                    world.m_7731_(fposUp, flowerState, 2);
                    continue block1;
                }
            }
        }
        BlockPos orePos = pos.m_6625_(rand.nextInt(10) + 25);
        BlockState stoneState = world.m_8055_(orePos);
        for (int down = 0; !stoneState.m_204336_(Tags.Blocks.STONE) && down < 10; ++down) {
            orePos = orePos.m_7495_();
            stoneState = world.m_8055_(orePos);
        }
        if (stoneState.m_204336_(Tags.Blocks.STONE)) {
            BlockState ore = FairyRingsModule.ores.get(rand.nextInt(FairyRingsModule.ores.size()));
            world.m_7731_(orePos, ore, 2);
            for (Direction face : Direction.values()) {
                if (!rand.nextBoolean()) continue;
                world.m_7731_(orePos.m_142300_(face), ore, 2);
            }
        }
    }
}

