/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.experimental.module;

import com.mojang.text2speech.Narrator;
import java.util.List;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.SignBlock;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import vazkii.arl.util.ClientTicker;
import vazkii.quark.base.client.handler.ModKeybindHandler;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.QuarkModule;

@LoadModule(category=ModuleCategory.EXPERIMENTAL, enabledByDefault=false, hasSubscriptions=true, subscribeOn={Dist.CLIENT})
public class NarratorReadoutModule
extends QuarkModule {
    @OnlyIn(value=Dist.CLIENT)
    private KeyMapping keybind;
    @OnlyIn(value=Dist.CLIENT)
    private KeyMapping keybindFull;
    private float last;

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientSetup() {
        if (this.enabled) {
            this.keybind = ModKeybindHandler.init("narrator_readout", null, "quark.gui.keygroup.misc");
            this.keybindFull = ModKeybindHandler.init("narrator_full_readout", null, "quark.gui.keygroup.misc");
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onMouseInput(InputEvent.MouseInputEvent event) {
        boolean down = this.isDown(event.getButton(), 0, true, this.keybind);
        boolean full = this.isDown(event.getButton(), 0, true, this.keybindFull);
        this.acceptInput(down || full, down);
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onKeyInput(InputEvent.KeyInputEvent event) {
        boolean down = this.isDown(event.getKey(), event.getScanCode(), false, this.keybind);
        boolean full = this.isDown(event.getKey(), event.getScanCode(), false, this.keybindFull);
        this.acceptInput(down || full, down);
    }

    @OnlyIn(value=Dist.CLIENT)
    private boolean isDown(int key, int scancode, boolean mouse, KeyMapping keybind) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91080_ != null) {
            if (mouse) {
                return keybind.m_90830_(key) && (keybind.getKeyModifier() == KeyModifier.NONE || keybind.getKeyModifier().isActive((IKeyConflictContext)KeyConflictContext.GUI));
            }
            return keybind.m_90832_(key, scancode) && (keybind.getKeyModifier() == KeyModifier.NONE || keybind.getKeyModifier().isActive((IKeyConflictContext)KeyConflictContext.GUI));
        }
        return keybind.m_90857_();
    }

    @OnlyIn(value=Dist.CLIENT)
    private void acceptInput(boolean down, boolean full) {
        Minecraft mc = Minecraft.m_91087_();
        float curr = ClientTicker.total;
        if (down && curr - this.last > 10.0f) {
            Narrator narrator = Narrator.getNarrator();
            String readout = this.getReadout(mc, full);
            if (readout != null) {
                narrator.say(readout, true);
                this.last = curr;
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private String getReadout(Minecraft mc, boolean full) {
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return I18n.m_118938_((String)"quark.readout.not_ingame", (Object[])new Object[0]);
        }
        StringBuilder sb = new StringBuilder();
        if (mc.f_91080_ == null) {
            HitResult ray = mc.f_91077_;
            if (ray instanceof BlockHitResult) {
                BlockPos pos = ((BlockHitResult)ray).m_82425_();
                BlockState state = mc.f_91073_.m_8055_(pos);
                Item item = state.m_60734_().m_5456_();
                if (item != null) {
                    sb.append(I18n.m_118938_((String)"quark.readout.looking", (Object[])new Object[]{item.m_7626_(new ItemStack((ItemLike)item)).getString()}));
                    if (full) {
                        sb.append(", ");
                    }
                }
                if (state.m_60734_() instanceof SignBlock) {
                    SignBlockEntity tile = (SignBlockEntity)mc.f_91073_.m_7702_(pos);
                    sb.append(I18n.m_118938_((String)"quark.readout.sign_says", (Object[])new Object[0]));
                    for (Component cmp : tile.f_59720_) {
                        String msg = cmp.getString().trim();
                        if (msg.isEmpty()) continue;
                        sb.append(cmp.getString());
                        sb.append(" ");
                    }
                    sb.append(". ");
                }
            }
            if (full) {
                ItemStack stack = player.m_21205_();
                ItemStack stack2 = player.m_21206_();
                if (stack.m_41619_()) {
                    stack = stack2;
                    stack2 = ItemStack.f_41583_;
                }
                if (!stack.m_41619_()) {
                    if (!stack2.m_41619_()) {
                        sb.append(I18n.m_118938_((String)"quark.readout.holding_with_off", (Object[])new Object[]{stack.m_41613_(), stack.m_41786_().getString(), stack2.m_41613_(), stack2.m_41786_().getString()}));
                    } else {
                        sb.append(I18n.m_118938_((String)"quark.readout.holding", (Object[])new Object[]{stack.m_41613_(), stack.m_41786_().getString()}));
                    }
                    sb.append(", ");
                }
                sb.append(I18n.m_118938_((String)"quark.readout.health", (Object[])new Object[]{(int)mc.f_91074_.m_21223_()}));
                sb.append(", ");
                sb.append(I18n.m_118938_((String)"quark.readout.food", (Object[])new Object[]{mc.f_91074_.m_36324_().m_38702_()}));
            }
        } else {
            Screen stack = mc.f_91080_;
            if (stack instanceof AbstractContainerScreen) {
                ItemStack stack2;
                AbstractContainerScreen cnt = (AbstractContainerScreen)stack;
                Slot slot = cnt.getSlotUnderMouse();
                ItemStack itemStack = stack2 = slot == null ? ItemStack.f_41583_ : slot.m_7993_();
                if (stack2.m_41619_()) {
                    sb.append(I18n.m_118938_((String)"quark.readout.no_item", (Object[])new Object[0]));
                } else {
                    List tooltip = cnt.m_96555_(stack2);
                    for (Component t : tooltip) {
                        MutableComponent print = t.m_6881_();
                        List bros = print.m_7360_();
                        for (Component sib : bros) {
                            TranslatableComponent ttc;
                            if (!(sib instanceof TranslatableComponent) || !(ttc = (TranslatableComponent)sib).m_131328_().contains("enchantment.level.")) continue;
                            bros.set(bros.indexOf(sib), new TextComponent(ttc.m_131328_().substring("enchantment.level.".length())));
                            break;
                        }
                        sb.append(print.getString());
                        if (full) {
                            sb.append(", ");
                            continue;
                        }
                        break;
                    }
                }
            } else {
                sb.append(mc.f_91080_.m_142562_());
            }
        }
        return sb.toString();
    }
}

