/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.addons.oddities.entity;

import com.mojang.authlib.GameProfile;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkHooks;
import vazkii.quark.addons.oddities.module.TotemOfHoldingModule;

public class TotemOfHoldingEntity
extends Entity {
    private static final String TAG_ITEMS = "storedItems";
    private static final String TAG_DYING = "dying";
    private static final String TAG_OWNER = "owner";
    private static final EntityDataAccessor<Boolean> DYING = SynchedEntityData.m_135353_(TotemOfHoldingEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final int DEATH_TIME = 40;
    private int deathTicks = 0;
    private String owner;
    private List<ItemStack> storedItems = new LinkedList<ItemStack>();

    public TotemOfHoldingEntity(EntityType<? extends TotemOfHoldingEntity> entityType, Level worldIn) {
        super(entityType, worldIn);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DYING, (Object)false);
    }

    public void addItem(ItemStack stack) {
        this.storedItems.add(stack);
    }

    public void setOwner(Player player) {
        this.owner = Player.m_36198_((GameProfile)player.m_36316_()).toString();
    }

    private Player getOwnerEntity() {
        for (Player player : this.f_19853_.m_6907_()) {
            String uuid = Player.m_36198_((GameProfile)player.m_36316_()).toString();
            if (!uuid.equals(this.owner)) continue;
            return player;
        }
        return null;
    }

    public boolean m_7313_(@Nonnull Entity e) {
        if (!this.f_19853_.f_46443_ && e instanceof Player) {
            Player owner;
            Player player = (Player)e;
            if (!TotemOfHoldingModule.allowAnyoneToCollect && !player.m_150110_().f_35937_ && e != (owner = this.getOwnerEntity())) {
                return false;
            }
            int drops = Math.min(this.storedItems.size(), 3 + this.f_19853_.f_46441_.nextInt(4));
            for (int i = 0; i < drops; ++i) {
                ItemStack curr;
                ItemStack stack = this.storedItems.remove(0);
                Item item = stack.m_41720_();
                if (item instanceof ArmorItem) {
                    ArmorItem armor = (ArmorItem)item;
                    EquipmentSlot slot = armor.m_40402_();
                    ItemStack curr2 = player.m_6844_(slot);
                    if (curr2.m_41619_()) {
                        player.m_8061_(slot, stack);
                        stack = null;
                    } else if (!EnchantmentHelper.m_44920_((ItemStack)curr2) && !EnchantmentHelper.m_44920_((ItemStack)stack)) {
                        player.m_8061_(slot, stack);
                        stack = curr2;
                    }
                } else if (stack.m_41720_() instanceof ShieldItem && (curr = player.m_6844_(EquipmentSlot.OFFHAND)).m_41619_()) {
                    player.m_8061_(EquipmentSlot.OFFHAND, stack);
                    stack = null;
                }
                if (stack == null || player.m_36356_(stack)) continue;
                this.m_5552_(stack, 0.0f);
            }
            if (this.f_19853_ instanceof ServerLevel) {
                ((ServerLevel)this.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123798_, this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), drops, 0.1, 0.5, 0.1, 0.0);
                ((ServerLevel)this.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123808_, this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), drops, 0.4, 0.5, 0.4, 0.0);
            }
        }
        return false;
    }

    public boolean m_6087_() {
        return true;
    }

    public void m_8119_() {
        Player owner;
        super.m_8119_();
        if (!this.m_6084_()) {
            return;
        }
        if (TotemOfHoldingModule.darkSoulsMode && (owner = this.getOwnerEntity()) != null && !this.f_19853_.f_46443_) {
            String ownerTotem = TotemOfHoldingModule.getTotemUUID(owner);
            if (!this.m_142081_().toString().equals(ownerTotem)) {
                this.dropEverythingAndDie();
            }
        }
        if (this.storedItems.isEmpty() && !this.f_19853_.f_46443_) {
            this.f_19804_.m_135381_(DYING, (Object)true);
        }
        if (this.isDying()) {
            if (this.deathTicks > 40) {
                this.m_146870_();
            } else {
                ++this.deathTicks;
            }
        } else if (this.f_19853_.f_46443_) {
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123760_, this.m_20185_(), this.m_20186_() + (Math.random() - 0.5) * 0.2, this.m_20189_(), Math.random() - 0.5, Math.random() - 0.5, Math.random() - 0.5);
        }
    }

    private void dropEverythingAndDie() {
        if (!TotemOfHoldingModule.destroyLostItems) {
            for (ItemStack storedItem : this.storedItems) {
                this.m_5552_(storedItem, 0.0f);
            }
        }
        this.storedItems.clear();
        this.m_146870_();
    }

    public int getDeathTicks() {
        return this.deathTicks;
    }

    public boolean isDying() {
        return (Boolean)this.f_19804_.m_135370_(DYING);
    }

    public void m_7378_(@Nonnull CompoundTag compound) {
        ListTag list = compound.m_128437_(TAG_ITEMS, 10);
        this.storedItems = new LinkedList<ItemStack>();
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag cmp = list.m_128728_(i);
            ItemStack stack = ItemStack.m_41712_((CompoundTag)cmp);
            this.storedItems.add(stack);
        }
        boolean dying = compound.m_128471_(TAG_DYING);
        this.f_19804_.m_135381_(DYING, (Object)dying);
        this.owner = compound.m_128461_(TAG_OWNER);
    }

    protected void m_7380_(@Nonnull CompoundTag compound) {
        ListTag list = new ListTag();
        for (ItemStack stack : this.storedItems) {
            list.add((Object)stack.serializeNBT());
        }
        compound.m_128365_(TAG_ITEMS, (Tag)list);
        compound.m_128379_(TAG_DYING, this.isDying());
        if (this.owner != null) {
            compound.m_128359_(TAG_OWNER, this.owner);
        }
    }

    @Nonnull
    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

