/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.backend.instancing.instancing;

import com.jozufozu.flywheel.api.InstanceData;
import com.jozufozu.flywheel.api.Instancer;
import com.jozufozu.flywheel.api.Material;
import com.jozufozu.flywheel.api.struct.Instanced;
import com.jozufozu.flywheel.backend.instancing.AbstractInstancer;
import com.jozufozu.flywheel.backend.instancing.instancing.GPUInstancer;
import com.jozufozu.flywheel.backend.model.ModelAllocator;
import com.jozufozu.flywheel.core.model.Model;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

public class InstancedMaterial<D extends InstanceData>
implements Material<D> {
    protected final ModelAllocator allocator;
    protected final Map<Object, GPUInstancer<D>> models = new HashMap<Object, GPUInstancer<D>>();
    protected final Instanced<D> type;
    protected final List<GPUInstancer<D>> uninitialized = new ArrayList<GPUInstancer<D>>();

    public InstancedMaterial(Instanced<D> type, ModelAllocator allocator) {
        this.type = type;
        this.allocator = allocator;
    }

    @Override
    public Instancer<D> model(Object key, Supplier<Model> modelSupplier) {
        return this.models.computeIfAbsent(key, $ -> {
            GPUInstancer<D> instancer = new GPUInstancer<D>(this.type, (Model)modelSupplier.get(), this.allocator);
            this.uninitialized.add(instancer);
            return instancer;
        });
    }

    public int getInstanceCount() {
        return this.models.values().stream().mapToInt(AbstractInstancer::getInstanceCount).sum();
    }

    public int getVertexCount() {
        return this.models.values().stream().mapToInt(AbstractInstancer::getVertexCount).sum();
    }

    public boolean nothingToRender() {
        return this.models.size() > 0 && this.models.values().stream().allMatch(GPUInstancer::isEmpty);
    }

    public void delete() {
        this.models.values().forEach(GPUInstancer::delete);
        this.models.clear();
    }

    public void clear() {
        this.models.values().forEach(AbstractInstancer::clear);
    }

    public Collection<GPUInstancer<D>> getAllInstancers() {
        return this.models.values();
    }
}

