/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.mods.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.resources.ResourceLocation;
import xaero.map.WorldMap;
import xaero.map.animation.SlowingAnimation;
import xaero.map.element.MapElement;
import xaero.map.graphics.MapRenderHelper;
import xaero.map.gui.GuiMap;
import xaero.map.gui.RightClickOption;
import xaero.map.mods.SupportMods;
import xaero.map.mods.gui.WaypointRenderer;

public class Waypoint
extends MapElement<WaypointRenderer>
implements Comparable<Waypoint> {
    private Object original;
    public static final ResourceLocation minimapTextures = new ResourceLocation("xaerobetterpvp", "gui/guis.png");
    public static final int white = -1;
    private int x;
    private int y;
    private int z;
    private String text;
    private String symbol;
    private int color;
    private boolean disabled = false;
    private int type = 0;
    private boolean rotation = false;
    private int yaw = 0;
    private float destAlpha = 0.0f;
    private float alpha = 0.0f;
    private SlowingAnimation alphaAnim = null;
    private boolean editable;
    private boolean temporary;
    private boolean global;
    private String setName;
    private boolean yIncluded;
    private ArrayList<RightClickOption> rightClickOptions;
    private double dimDiv;

    public Waypoint(WaypointRenderer renderer, Object original, int x, int y, int z, String name, String symbol, int color, int type, boolean editable, String setName, boolean yIncluded, double dimDiv) {
        super(renderer);
        this.original = original;
        this.x = x;
        this.y = y;
        this.z = z;
        this.symbol = symbol;
        this.color = color;
        this.type = type;
        this.text = name;
        this.editable = editable;
        this.setName = setName;
        this.yIncluded = yIncluded;
        this.rightClickOptions = new ArrayList();
        this.rightClickOptions.add(new RightClickOption(name, this.rightClickOptions.size(), this){

            @Override
            public void onAction(Screen screen) {
                SupportMods.xaeroMinimap.openWaypoint((GuiMap)screen, Waypoint.this);
            }
        });
        if (WorldMap.settings.coordinates && !SupportMods.xaeroMinimap.hidingWaypointCoordinates()) {
            this.rightClickOptions.add(new RightClickOption(String.format("X: %d, Y: %s, Z: %d", x, this.yIncluded ? "" + y : "~", z), this.rightClickOptions.size(), this){

                @Override
                public void onAction(Screen screen) {
                    SupportMods.xaeroMinimap.openWaypoint((GuiMap)screen, Waypoint.this);
                }
            });
        }
        this.rightClickOptions.add(new RightClickOption("gui.xaero_right_click_waypoint_edit", this.rightClickOptions.size(), this){

            @Override
            public void onAction(Screen screen) {
                SupportMods.xaeroMinimap.openWaypoint((GuiMap)screen, Waypoint.this);
            }
        }.setNameFormatArgs("E"));
        this.rightClickOptions.add(new RightClickOption("gui.xaero_right_click_waypoint_teleport", this.rightClickOptions.size(), this){

            @Override
            public void onAction(Screen screen) {
                SupportMods.xaeroMinimap.teleportToWaypoint(screen, Waypoint.this);
            }

            @Override
            public boolean isActive() {
                return SupportMods.xaeroMinimap.canTeleport(SupportMods.xaeroMinimap.getWaypointWorld());
            }
        }.setNameFormatArgs("T"));
        this.rightClickOptions.add(new RightClickOption("gui.xaero_right_click_waypoint_share", this.rightClickOptions.size(), this){

            @Override
            public void onAction(Screen screen) {
                SupportMods.xaeroMinimap.shareWaypoint(Waypoint.this, (GuiMap)screen, SupportMods.xaeroMinimap.getWaypointWorld());
            }
        });
        this.rightClickOptions.add(new RightClickOption("", this.rightClickOptions.size(), this){

            @Override
            public String getName() {
                return Waypoint.this.temporary ? "gui.xaero_right_click_waypoint_restore" : (Waypoint.this.disabled ? "gui.xaero_right_click_waypoint_enable" : "gui.xaero_right_click_waypoint_disable");
            }

            @Override
            public void onAction(Screen screen) {
                if (Waypoint.this.temporary) {
                    SupportMods.xaeroMinimap.toggleTemporaryWaypoint(Waypoint.this);
                } else {
                    SupportMods.xaeroMinimap.disableWaypoint(Waypoint.this);
                }
            }
        }.setNameFormatArgs("H"));
        this.rightClickOptions.add(new RightClickOption("", this.rightClickOptions.size(), this){

            @Override
            public String getName() {
                return Waypoint.this.temporary ? "gui.xaero_right_click_waypoint_delete_confirm" : "gui.xaero_right_click_waypoint_delete";
            }

            @Override
            public void onAction(Screen screen) {
                if (Waypoint.this.temporary) {
                    SupportMods.xaeroMinimap.deleteWaypoint(Waypoint.this);
                } else {
                    SupportMods.xaeroMinimap.toggleTemporaryWaypoint(Waypoint.this);
                }
            }
        }.setNameFormatArgs("DEL"));
        this.dimDiv = dimDiv;
    }

    public String getName() {
        return I18n.m_118938_((String)this.text, (Object[])new Object[0]);
    }

    public void renderShadow(float brightness, VertexConsumer regularUIObjectConsumer, PoseStack matrixStack, TextureManager textureManager) {
        float visibilityAlpha = this.disabled ? 0.3f : 1.0f;
        matrixStack.m_85837_(-14.0, -41.0, 0.0);
        MapRenderHelper.blitIntoExistingBuffer(matrixStack.m_85850_().m_85861_(), regularUIObjectConsumer, 0, 19, 0, 117, 41, 22, 0.0f, 0.0f, 0.0f, brightness * visibilityAlpha);
    }

    @Override
    public int compareTo(Waypoint arg0) {
        return this.z > arg0.z ? 1 : (this.z != arg0.z ? -1 : 0);
    }

    public String toString() {
        return this.getName();
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public int getType() {
        return this.type;
    }

    public int getYaw() {
        return this.yaw;
    }

    public void setYaw(int yaw) {
        this.yaw = yaw;
    }

    public boolean isRotation() {
        return this.rotation;
    }

    public void setRotation(boolean rotation) {
        this.rotation = rotation;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public Object getOriginal() {
        return this.original;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public void setTemporary(boolean temporary) {
        this.temporary = temporary;
    }

    public void setGlobal(boolean global) {
        this.global = global;
    }

    @Override
    public int getLeftSideLength(Minecraft mc) {
        return 9 + mc.f_91062_.m_92895_(this.getName());
    }

    public String getSetName() {
        return this.setName;
    }

    public String getComparisonName() {
        String comparisonName = this.getName().toLowerCase().trim();
        if (comparisonName.startsWith("the ")) {
            comparisonName = comparisonName.substring(4);
        }
        if (comparisonName.startsWith("a ")) {
            comparisonName = comparisonName.substring(2);
        }
        return comparisonName;
    }

    @Override
    public ArrayList<RightClickOption> getRightClickOptions() {
        return this.rightClickOptions;
    }

    @Override
    public boolean isRightClickValid() {
        return SupportMods.xaeroMinimap.waypointExists(this);
    }

    @Override
    public int getRightClickTitleBackgroundColor() {
        return this.color;
    }

    public int getColor() {
        return this.color;
    }

    public boolean isGlobal() {
        return this.global;
    }

    @Override
    public double getRenderX() {
        if (this.dimDiv == 1.0) {
            return this.x;
        }
        return (int)Math.floor((double)this.x / this.dimDiv);
    }

    @Override
    public double getRenderZ() {
        if (this.dimDiv == 1.0) {
            return this.z;
        }
        return (int)Math.floor((double)this.z / this.dimDiv);
    }

    @Override
    public int boundingBoxLeft() {
        return -this.boundingBoxRight();
    }

    @Override
    public int boundingBoxRight() {
        return this.getSymbol().length() > 1 ? 21 : 14;
    }

    @Override
    public int boundingBoxTop() {
        return WorldMap.settings.waypointBackgrounds ? -41 : -12;
    }

    @Override
    public int boundingBoxBottom() {
        return WorldMap.settings.waypointBackgrounds ? 0 : 12;
    }

    @Override
    public double getScale() {
        return 1.0;
    }

    @Override
    public boolean isHidden(WaypointRenderer renderer, GuiMap mapScreen) {
        return !renderer.waypointIsGood(this, mapScreen) || !WorldMap.settings.showDisabledWaypoints && this.isDisabled();
    }

    public boolean isTemporary() {
        return this.temporary;
    }

    public float getDestAlpha() {
        return this.destAlpha;
    }

    public void setDestAlpha(float destAlpha) {
        this.destAlpha = destAlpha;
    }

    public SlowingAnimation getAlphaAnim() {
        return this.alphaAnim;
    }

    public void setAlphaAnim(SlowingAnimation alphaAnim) {
        this.alphaAnim = alphaAnim;
    }

    public float getAlpha() {
        return this.alpha;
    }

    public void setAlpha(float alpha) {
        this.alpha = alpha;
    }

    @Override
    public String getMenuName() {
        Object name = this.getName();
        if (this.isGlobal()) {
            name = "* " + (String)name;
        }
        return name;
    }

    @Override
    public int getMenuTextFillLeftPadding() {
        return (this.disabled ? 11 : 0) + (this.temporary ? 10 : 0);
    }

    @Override
    public String getFilterName() {
        return this.getMenuName() + " " + this.getSymbol();
    }
}

