/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import moze_intel.projecte.PECore;
import moze_intel.projecte.gameObjs.container.CondenserContainer;
import moze_intel.projecte.gameObjs.container.CondenserMK2Container;
import moze_intel.projecte.gameObjs.gui.PEContainerScreen;
import moze_intel.projecte.utils.Constants;
import moze_intel.projecte.utils.TransmutationEMCFormatter;
import moze_intel.projecte.utils.text.PELang;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractCondenserScreen<T extends CondenserContainer>
extends PEContainerScreen<T> {
    public AbstractCondenserScreen(T condenser, Inventory playerInventory, Component title) {
        super(condenser, playerInventory, title);
        this.f_97726_ = 255;
        this.f_97727_ = 233;
    }

    protected abstract ResourceLocation getTexture();

    protected void m_7286_(@NotNull PoseStack matrix, float partialTicks, int x, int y) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.getTexture());
        this.m_93228_(matrix, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        int progress = ((CondenserContainer)this.f_97732_).getProgressScaled();
        this.m_93228_(matrix, this.f_97735_ + 33, this.f_97736_ + 10, 0, 235, progress, 10);
    }

    protected void m_7027_(@NotNull PoseStack matrix, int x, int y) {
        long toDisplay = Math.min(((CondenserContainer)this.f_97732_).displayEmc.get(), ((CondenserContainer)this.f_97732_).requiredEmc.get());
        Component emc = TransmutationEMCFormatter.formatEMC(toDisplay);
        this.f_96547_.m_92889_(matrix, emc, 140.0f, 10.0f, 0x404040);
    }

    protected void m_7025_(@NotNull PoseStack matrix, int mouseX, int mouseY) {
        long toDisplay = Math.min(((CondenserContainer)this.f_97732_).displayEmc.get(), ((CondenserContainer)this.f_97732_).requiredEmc.get());
        if ((double)toDisplay < 1.0E12) {
            super.m_7025_(matrix, mouseX, mouseY);
            return;
        }
        int emcLeft = 140 + this.f_97735_;
        int emcRight = emcLeft + 110;
        int emcTop = 6 + this.f_97736_;
        int emcBottom = emcTop + 15;
        if (mouseX > emcLeft && mouseX < emcRight && mouseY > emcTop && mouseY < emcBottom) {
            this.m_96602_(matrix, (Component)PELang.EMC_TOOLTIP.translate(Constants.EMC_FORMATTER.format(toDisplay)), mouseX, mouseY);
        } else {
            super.m_7025_(matrix, mouseX, mouseY);
        }
    }

    public static class MK2
    extends AbstractCondenserScreen<CondenserMK2Container> {
        public MK2(CondenserMK2Container condenser, Inventory playerInventory, Component title) {
            super(condenser, playerInventory, title);
        }

        @Override
        protected ResourceLocation getTexture() {
            return PECore.rl("textures/gui/condenser_mk2.png");
        }
    }

    public static class MK1
    extends AbstractCondenserScreen<CondenserContainer> {
        public MK1(CondenserContainer condenser, Inventory playerInventory, Component title) {
            super(condenser, playerInventory, title);
        }

        @Override
        protected ResourceLocation getTexture() {
            return PECore.rl("textures/gui/condenser.png");
        }
    }
}

