/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.client.render.tileentity.MekanismTileEntityRenderer;
import mekanism.generators.client.model.ModelTurbine;
import mekanism.generators.common.content.turbine.TurbineMultiblockData;
import mekanism.generators.common.tile.turbine.TileEntityTurbineRotor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.util.profiling.ProfilerFiller;

@ParametersAreNonnullByDefault
public class RenderTurbineRotor
extends MekanismTileEntityRenderer<TileEntityTurbineRotor> {
    public static RenderTurbineRotor INSTANCE;
    private static final float BASE_SPEED = 512.0f;
    public final ModelTurbine model;

    public RenderTurbineRotor(BlockEntityRendererProvider.Context context) {
        super(context);
        INSTANCE = this;
        this.model = new ModelTurbine(context.m_173585_());
    }

    protected void render(TileEntityTurbineRotor tile, float partialTick, PoseStack matrix, MultiBufferSource renderer, int light, int overlayLight, ProfilerFiller profiler) {
        if (tile.getMultiblock() == null) {
            this.render(tile, matrix, this.model.getBuffer(renderer), light, overlayLight);
        }
    }

    public void render(TileEntityTurbineRotor tile, PoseStack matrix, VertexConsumer buffer, int light, int overlayLight) {
        int housedBlades = tile.getHousedBlades();
        if (housedBlades == 0) {
            return;
        }
        int baseIndex = tile.getPosition() * 2;
        if (!Minecraft.m_91087_().m_91104_()) {
            if (tile.getMultiblock() != null && TurbineMultiblockData.clientRotationMap.containsKey((Object)tile.getMultiblock())) {
                float rotateSpeed = TurbineMultiblockData.clientRotationMap.getFloat((Object)tile.getMultiblock()) * 512.0f;
                tile.rotationLower = (tile.rotationLower + rotateSpeed * (1.0f / (float)(baseIndex + 1))) % 360.0f;
                tile.rotationUpper = (tile.rotationUpper + rotateSpeed * (1.0f / (float)(baseIndex + 2))) % 360.0f;
            } else {
                tile.rotationLower %= 360.0f;
                tile.rotationUpper %= 360.0f;
            }
        }
        matrix.m_85836_();
        matrix.m_85837_(0.5, -1.0, 0.5);
        matrix.m_85845_(Vector3f.f_122225_.m_122240_(tile.rotationLower));
        this.model.render(matrix, buffer, light, overlayLight, baseIndex);
        matrix.m_85849_();
        if (housedBlades == 2) {
            matrix.m_85836_();
            matrix.m_85837_(0.5, -0.5, 0.5);
            matrix.m_85845_(Vector3f.f_122225_.m_122240_(tile.rotationUpper));
            this.model.render(matrix, buffer, light, overlayLight, baseIndex + 1);
            matrix.m_85849_();
        }
    }

    protected String getProfilerSection() {
        return "turbineRotor";
    }

    public boolean shouldRenderOffScreen(TileEntityTurbineRotor tile) {
        return tile.getMultiblock() == null && tile.getHousedBlades() > 0;
    }
}

