/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.inventory.IInventorySlot;
import mekanism.common.Mekanism;
import mekanism.common.config.MekanismConfig;
import mekanism.common.item.interfaces.IItemSustainedInventory;
import mekanism.common.lib.inventory.TileTransitRequest;
import mekanism.common.lib.security.IOwnerItem;
import mekanism.common.lib.security.ISecurityItem;
import mekanism.common.lib.security.ISecurityObject;
import mekanism.common.lib.security.SecurityMode;
import mekanism.common.recipe.upgrade.ItemRecipeData;
import mekanism.common.util.CapabilityUtils;
import mekanism.common.util.SecurityUtils;
import mekanism.common.util.StackUtils;
import net.minecraft.core.Direction;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Contract;

public final class InventoryUtils {
    private InventoryUtils() {
    }

    public static void dropItemContents(ItemEntity entity, DamageSource source) {
        Item item;
        ItemStack stack = entity.m_32055_();
        if (!entity.f_19853_.f_46443_ && !stack.m_41619_() && (item = stack.m_41720_()) instanceof IItemSustainedInventory) {
            boolean shouldDrop;
            IItemSustainedInventory sustainedInventory = (IItemSustainedInventory)item;
            Entity entity2 = source.m_7639_();
            if (entity2 instanceof Player) {
                Player player = (Player)entity2;
                shouldDrop = SecurityUtils.canAccess(player, stack);
            } else if (!(stack.m_41720_() instanceof ISecurityItem) && (entity2 = stack.m_41720_()) instanceof IOwnerItem) {
                IOwnerItem ownerItem = (IOwnerItem)entity2;
                shouldDrop = !MekanismConfig.general.allowProtection.get() || ownerItem.getOwnerUUID(stack) == null;
            } else {
                ISecurityObject security = SecurityUtils.wrapSecurityItem(stack);
                boolean bl = shouldDrop = !security.hasSecurity() || security.getSecurityMode() == SecurityMode.PUBLIC;
            }
            if (shouldDrop) {
                ListTag storedContents = sustainedInventory.getInventory(stack);
                for (IInventorySlot slot : ItemRecipeData.readContents(storedContents)) {
                    int max;
                    if (slot.isEmpty()) continue;
                    ItemStack slotStack = slot.getStack();
                    int count = slotStack.m_41613_();
                    if (count > (max = slotStack.m_41741_())) {
                        while (count > max) {
                            entity.f_19853_.m_7967_((Entity)new ItemEntity(entity.f_19853_, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), StackUtils.size(slotStack, max)));
                            count -= max;
                        }
                        if (count <= 0) continue;
                        entity.f_19853_.m_7967_((Entity)new ItemEntity(entity.f_19853_, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), StackUtils.size(slotStack, count)));
                        continue;
                    }
                    entity.f_19853_.m_7967_((Entity)new ItemEntity(entity.f_19853_, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), slotStack));
                }
            }
        }
    }

    public static boolean areItemsStackable(ItemStack toInsert, ItemStack inSlot) {
        if (toInsert.m_41619_() || inSlot.m_41619_()) {
            return true;
        }
        return ItemHandlerHelper.canItemStacksStack((ItemStack)inSlot, (ItemStack)toInsert);
    }

    @Nullable
    public static IItemHandler assertItemHandler(String desc, BlockEntity tile, Direction side) {
        Optional capability = CapabilityUtils.getCapability((ICapabilityProvider)tile, CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side).resolve();
        if (capability.isPresent()) {
            return (IItemHandler)capability.get();
        }
        Mekanism.logger.warn("'{}' was wrapped around a non-IItemHandler inventory. This should not happen!", (Object)desc, (Object)new Exception());
        if (tile == null) {
            Mekanism.logger.warn(" - null tile");
        } else {
            Mekanism.logger.warn(" - details: {} {}", (Object)tile, (Object)tile.m_58899_());
        }
        return null;
    }

    public static boolean isItemHandler(BlockEntity tile, Direction side) {
        return CapabilityUtils.getCapability((ICapabilityProvider)tile, CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side).isPresent();
    }

    public static TileTransitRequest getEjectItemMap(BlockEntity tile, Direction side, List<IInventorySlot> slots) {
        return InventoryUtils.getEjectItemMap(new TileTransitRequest(tile, side), slots);
    }

    @Contract(value="_, _ -> param1")
    public static <REQUEST extends TileTransitRequest> REQUEST getEjectItemMap(REQUEST request, List<IInventorySlot> slots) {
        ArrayList<IInventorySlot> shuffled = new ArrayList<IInventorySlot>(slots);
        Collections.shuffle(shuffled);
        for (IInventorySlot slot : shuffled) {
            ItemStack simulatedExtraction = slot.extractItem(slot.getCount(), Action.SIMULATE, AutomationType.EXTERNAL);
            if (simulatedExtraction.m_41619_()) continue;
            request.addItem(simulatedExtraction, slots.indexOf(slot));
        }
        return request;
    }
}

