/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.prefab;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.IConfigurable;
import mekanism.api.IContentsListener;
import mekanism.api.providers.IBlockProvider;
import mekanism.api.text.EnumColor;
import mekanism.client.SparkleAnimation;
import mekanism.common.MekanismLang;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.resolver.BasicCapabilityResolver;
import mekanism.common.config.MekanismConfig;
import mekanism.common.integration.computer.BoundComputerMethod;
import mekanism.common.integration.computer.ComputerMethodMapper;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.sync.dynamic.SyncMapper;
import mekanism.common.lib.multiblock.FormationProtocol;
import mekanism.common.lib.multiblock.IMultiblock;
import mekanism.common.lib.multiblock.IStructuralMultiblock;
import mekanism.common.lib.multiblock.MultiblockCache;
import mekanism.common.lib.multiblock.MultiblockData;
import mekanism.common.lib.multiblock.Structure;
import mekanism.common.tile.base.SubstanceType;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.NBTUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public abstract class TileEntityMultiblock<T extends MultiblockData>
extends TileEntityMekanism
implements IMultiblock<T>,
IConfigurable {
    private Structure structure = Structure.INVALID;
    private final T defaultMultiblock = this.createMultiblock();
    private boolean prevStructure;
    private boolean isMaster;
    protected MultiblockCache<T> cachedData;
    @Nullable
    protected UUID cachedID = null;
    private long unformedTicks = 100L;

    public TileEntityMultiblock(IBlockProvider blockProvider, BlockPos pos, BlockState state) {
        super(blockProvider, pos, state);
        this.cacheCoord();
        this.addCapabilityResolver(BasicCapabilityResolver.constant(Capabilities.CONFIGURABLE_CAPABILITY, this));
    }

    @Override
    public void setStructure(Structure structure) {
        this.structure = structure;
    }

    @Override
    public Structure getStructure() {
        return this.structure;
    }

    @Override
    public T getDefaultData() {
        return this.defaultMultiblock;
    }

    @Override
    protected void onUpdateClient() {
        super.onUpdateClient();
        if (!this.getMultiblock().isFormed()) {
            ++this.unformedTicks;
            if (!this.playersUsing.isEmpty()) {
                for (Player player : new ObjectOpenHashSet((Collection)this.playersUsing)) {
                    player.m_6915_();
                }
            }
        } else {
            this.unformedTicks = 0L;
        }
    }

    @Override
    protected void onUpdateServer() {
        MultiblockData multiblock;
        super.onUpdateServer();
        boolean needsPacket = false;
        if (this.ticker >= 3) {
            this.structure.tick(this, this.ticker % 10 == 0);
        }
        if ((multiblock = this.getMultiblock()).isFormed()) {
            if (!this.prevStructure) {
                this.structureChanged(multiblock);
                this.prevStructure = true;
                needsPacket = true;
            }
            if (multiblock.inventoryID != null) {
                this.cachedID = multiblock.inventoryID;
                this.getManager().updateCache(this, multiblock);
                if (this.isMaster()) {
                    if (multiblock.tick(this.f_58857_)) {
                        needsPacket = true;
                    }
                    if (multiblock.isDirty()) {
                        this.markForSave();
                        multiblock.resetDirty();
                    }
                }
            }
        } else {
            this.playersUsing.forEach(Player::m_6915_);
            if (this.cachedID != null) {
                this.getManager().updateCache(this, multiblock);
            }
            if (this.prevStructure) {
                this.structureChanged(multiblock);
                this.prevStructure = false;
                needsPacket = true;
            }
            this.isMaster = false;
        }
        if (needsPacket |= this.onUpdateServer(multiblock)) {
            this.sendUpdatePacket();
        }
    }

    protected boolean onUpdateServer(T multiblock) {
        return false;
    }

    @Override
    public void resetForFormed() {
        this.isMaster = false;
        this.prevStructure = false;
    }

    protected void structureChanged(T multiblock) {
        this.invalidateCachedCapabilities();
        if (((MultiblockData)multiblock).isFormed() && !((MultiblockData)multiblock).hasMaster && this.canBeMaster()) {
            ((MultiblockData)multiblock).hasMaster = true;
            this.isMaster = true;
            ((MultiblockData)multiblock).forceUpdateComparatorLevel();
            ((MultiblockData)multiblock).notifyAllUpdateComparator(this.f_58857_);
        }
        for (Direction side : EnumUtils.DIRECTIONS) {
            BlockPos pos = this.m_58899_().m_142300_(side);
            if (((MultiblockData)multiblock).isFormed() && (((MultiblockData)multiblock).locations.contains(pos) || ((MultiblockData)multiblock).internalLocations.contains(pos))) continue;
            BlockEntity tile = WorldUtils.getTileEntity((BlockGetter)this.f_58857_, pos);
            if (this.f_58857_.m_46859_(pos) || tile != null && tile.getClass() == this.getClass() || tile instanceof IStructuralMultiblock || tile instanceof IMultiblock) continue;
            WorldUtils.notifyNeighborOfChange(this.f_58857_, pos, this.m_58899_());
        }
        if (!((MultiblockData)multiblock).isFormed()) {
            this.markDirtyComparator();
        }
    }

    @Override
    protected boolean makesComparatorDirty(@Nullable SubstanceType type) {
        return false;
    }

    @Override
    public boolean canBeMaster() {
        return true;
    }

    @Override
    public InteractionResult onActivate(Player player, InteractionHand hand, ItemStack stack) {
        if (player.m_6144_() || !this.getMultiblock().isFormed()) {
            return InteractionResult.PASS;
        }
        return this.openGui(player);
    }

    @Override
    public void m_7651_() {
        super.m_7651_();
        if (!this.isRemote()) {
            this.structure.invalidate(this.f_58857_);
            if (this.cachedID != null) {
                this.getManager().invalidate(this);
            }
        }
    }

    @Override
    public boolean shouldDumpRadiation() {
        return false;
    }

    @Override
    public void resetCache() {
        this.cachedID = null;
        this.cachedData = null;
    }

    @Override
    public UUID getCacheID() {
        return this.cachedID;
    }

    @Override
    public MultiblockCache<T> getCache() {
        return this.cachedData;
    }

    @Override
    public void setCache(MultiblockCache<T> cache) {
        this.cachedData = cache;
    }

    @Override
    public boolean isMaster() {
        return this.isMaster;
    }

    @Override
    @Nonnull
    public CompoundTag getReducedUpdateTag() {
        CompoundTag updateTag = super.getReducedUpdateTag();
        updateTag.m_128379_("rendering", this.isMaster());
        MultiblockData multiblock = this.getMultiblock();
        updateTag.m_128379_("hasStructure", multiblock.isFormed());
        if (multiblock.isFormed() && this.isMaster()) {
            multiblock.writeUpdateTag(updateTag);
        }
        return updateTag;
    }

    @Override
    public void handleUpdateTag(@Nonnull CompoundTag tag) {
        super.handleUpdateTag(tag);
        NBTUtils.setBooleanIfPresent(tag, "rendering", value -> {
            this.isMaster = value;
        });
        MultiblockData multiblock = this.getMultiblock();
        NBTUtils.setBooleanIfPresent(tag, "hasStructure", multiblock::setFormedForce);
        if (this.isMaster()) {
            if (multiblock.isFormed()) {
                multiblock.readUpdateTag(tag);
                this.doMultiblockSparkle(multiblock);
            } else {
                this.isMaster = false;
            }
        }
        this.prevStructure = multiblock.isFormed();
    }

    private void doMultiblockSparkle(T multiblock) {
        LocalPlayer player;
        if (this.isRemote() && ((MultiblockData)multiblock).renderLocation != null && !this.prevStructure && this.unformedTicks >= 5L && this.f_58858_.m_123331_((Vec3i)(player = Minecraft.m_91087_().f_91074_).m_142538_()) <= 1600.0) {
            if (MekanismConfig.client.enableMultiblockFormationParticles.get()) {
                new SparkleAnimation(this, ((MultiblockData)multiblock).renderLocation, ((MultiblockData)multiblock).length() - 1, ((MultiblockData)multiblock).width() - 1, ((MultiblockData)multiblock).height() - 1).run();
            } else {
                player.m_5661_((Component)MekanismLang.MULTIBLOCK_FORMED_CHAT.translateColored(EnumColor.INDIGO, new Object[0]), true);
            }
        }
    }

    @Override
    public void m_142466_(@Nonnull CompoundTag nbt) {
        super.m_142466_(nbt);
        if (!this.getMultiblock().isFormed()) {
            NBTUtils.setUUIDIfPresent(nbt, "inventoryID", id -> {
                this.cachedID = id;
                if (nbt.m_128425_("cache", 10)) {
                    this.cachedData = this.getManager().createCache();
                    this.cachedData.load(nbt.m_128469_("cache"));
                }
            });
        }
    }

    @Override
    public void m_183515_(@Nonnull CompoundTag nbtTags) {
        super.m_183515_(nbtTags);
        if (this.cachedID != null) {
            nbtTags.m_128362_("inventoryID", this.cachedID);
            if (this.cachedData != null) {
                MultiblockData multiblock = this.getMultiblock();
                if (multiblock.isFormed()) {
                    this.cachedData.sync(multiblock);
                }
                CompoundTag cacheTags = new CompoundTag();
                this.cachedData.save(cacheTags);
                nbtTags.m_128365_("cache", (Tag)cacheTags);
            }
        }
    }

    @Override
    public void addContainerTrackers(MekanismContainer container) {
        super.addContainerTrackers(container);
        SyncMapper.INSTANCE.setup(container, this.getMultiblock().getClass(), this::getMultiblock);
    }

    @Nonnull
    public AABB getRenderBoundingBox() {
        MultiblockData multiblock;
        if (this.isMaster() && (multiblock = this.getMultiblock()).isFormed() && multiblock.getBounds() != null) {
            return new AABB(multiblock.getMinPos(), multiblock.getMaxPos().m_142082_(1, 1, 1));
        }
        return super.getRenderBoundingBox();
    }

    @Override
    public boolean persistInventory() {
        return false;
    }

    @Override
    @Nonnull
    protected IInventorySlotHolder getInitialInventory(IContentsListener listener) {
        return side -> this.getMultiblock().getInventorySlots(side);
    }

    @Override
    public void onNeighborChange(Block block, BlockPos neighborPos) {
        MultiblockData multiblock;
        super.onNeighborChange(block, neighborPos);
        if (!this.isRemote() && (multiblock = this.getMultiblock()).isPositionInsideBounds(this.getStructure(), neighborPos) && (!multiblock.innerNodes.contains(neighborPos) || this.f_58857_.m_46859_(neighborPos))) {
            this.getStructure().markForUpdate(this.f_58857_, true);
        }
    }

    @Override
    public InteractionResult onRightClick(Player player) {
        FormationProtocol.FormationResult result;
        if (!(this.isRemote() || this.getMultiblock().isFormed() || (result = this.getStructure().runUpdate(this)).isFormed() || result.getResultText() == null)) {
            player.m_6352_(result.getResultText(), Util.f_137441_);
            return InteractionResult.m_19078_((boolean)this.isRemote());
        }
        return InteractionResult.PASS;
    }

    @Override
    public InteractionResult onSneakRightClick(Player player) {
        return InteractionResult.PASS;
    }

    public boolean exposesMultiblockToComputer() {
        return true;
    }

    @Override
    public boolean isComputerCapabilityPersistent() {
        return !this.exposesMultiblockToComputer() && super.isComputerCapabilityPersistent();
    }

    @Override
    public void getComputerMethods(Map<String, BoundComputerMethod> methods) {
        MultiblockData multiblock;
        super.getComputerMethods(methods);
        if (this.exposesMultiblockToComputer() && (multiblock = this.getMultiblock()).isFormed()) {
            ComputerMethodMapper.INSTANCE.getAndBindToHandler(multiblock, methods);
        }
    }

    @ComputerMethod(restriction=ComputerMethodMapper.MethodRestriction.MULTIBLOCK)
    private boolean isFormed() {
        return this.getMultiblock().isFormed();
    }
}

