/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.upgrade;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.DataHandlerUtils;
import mekanism.api.annotations.FieldsAreNonnullByDefault;
import mekanism.api.annotations.NonNull;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.inventory.IMekanismInventory;
import mekanism.api.recipes.ItemStackToEnergyRecipe;
import mekanism.common.integration.energy.EnergyCompatUtils;
import mekanism.common.inventory.slot.BasicInventorySlot;
import mekanism.common.item.ItemRobit;
import mekanism.common.item.block.ItemBlockBin;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.recipe.lookup.cache.InputRecipeCache;
import mekanism.common.recipe.upgrade.RecipeUpgradeData;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.interfaces.ISustainedInventory;
import net.minecraft.core.Direction;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
public class ItemRecipeData
implements RecipeUpgradeData<ItemRecipeData> {
    private final List<IInventorySlot> slots;

    ItemRecipeData(ListTag slots) {
        this.slots = ItemRecipeData.readContents(slots);
    }

    private ItemRecipeData(List<IInventorySlot> slots) {
        this.slots = slots;
    }

    @Override
    @Nullable
    public ItemRecipeData merge(ItemRecipeData other) {
        ArrayList<IInventorySlot> allSlots = new ArrayList<IInventorySlot>(this.slots.size() + other.slots.size());
        allSlots.addAll(this.slots);
        allSlots.addAll(other.slots);
        return new ItemRecipeData(allSlots);
    }

    @Override
    public boolean applyToStack(ItemStack stack) {
        if (this.slots.isEmpty()) {
            return true;
        }
        Item item = stack.m_41720_();
        boolean isBin = item instanceof ItemBlockBin;
        Optional capability = stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).resolve();
        final ArrayList<DummyInventorySlot> slots = new ArrayList<DummyInventorySlot>();
        if (capability.isPresent()) {
            IItemHandler itemHandler = (IItemHandler)capability.get();
            i = 0;
            while (i < itemHandler.getSlots()) {
                slot = i++;
                slots.add(new DummyInventorySlot(itemHandler.getSlotLimit(slot), itemStack -> itemHandler.isItemValid(slot, itemStack), isBin));
            }
        } else if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            TileEntityMekanism tile = this.getTileFromBlock(blockItem.m_40614_());
            if (tile == null || !tile.persistInventory()) {
                return false;
            }
            i = 0;
            while (i < tile.getSlots()) {
                slot = i++;
                slots.add(new DummyInventorySlot(tile.getSlotLimit(slot), itemStack -> tile.isItemValid(slot, (ItemStack)itemStack), isBin));
            }
        } else if (item instanceof ItemRobit) {
            for (int slotY = 0; slotY < 3; ++slotY) {
                for (int slotX = 0; slotX < 9; ++slotX) {
                    slots.add(new DummyInventorySlot(64, BasicInventorySlot.alwaysTrue, false));
                }
            }
            slots.add(new DummyInventorySlot(64, itemStack -> {
                if (EnergyCompatUtils.hasStrictEnergyHandler(itemStack)) {
                    return true;
                }
                ItemStackToEnergyRecipe foundRecipe = (ItemStackToEnergyRecipe)((InputRecipeCache.SingleItem)MekanismRecipeType.ENERGY_CONVERSION.getInputCache()).findTypeBasedRecipe(null, itemStack);
                return foundRecipe != null && !foundRecipe.getOutput((ItemStack)itemStack).isZero();
            }, false));
            slots.add(new DummyInventorySlot(64, itemStack -> ((InputRecipeCache.SingleItem)MekanismRecipeType.SMELTING.getInputCache()).containsInput(null, itemStack), false));
            slots.add(new DummyInventorySlot(64, BasicInventorySlot.alwaysTrue, false));
        } else {
            if (item instanceof ISustainedInventory) {
                ISustainedInventory sustainedInventory = (ISustainedInventory)item;
                for (IInventorySlot slot : this.slots) {
                    if (slot.isEmpty()) continue;
                    sustainedInventory.setInventory(DataHandlerUtils.writeContainers(this.slots), stack);
                    return true;
                }
                return true;
            }
            return false;
        }
        if (slots.isEmpty()) {
            return true;
        }
        IMekanismInventory outputHandler = new IMekanismInventory(){

            @Override
            @Nonnull
            public List<IInventorySlot> getInventorySlots(@Nullable Direction side) {
                return slots;
            }

            @Override
            public void onContentsChanged() {
            }
        };
        boolean hasData = false;
        for (IInventorySlot slot : this.slots) {
            if (slot.isEmpty()) continue;
            if (!ItemHandlerHelper.insertItemStacked((IItemHandler)outputHandler, (ItemStack)slot.getStack(), (boolean)false).m_41619_()) {
                return false;
            }
            hasData = true;
        }
        if (hasData) {
            ((ISustainedInventory)stack.m_41720_()).setInventory(DataHandlerUtils.writeContainers(slots), stack);
        }
        return true;
    }

    public static List<IInventorySlot> readContents(@Nullable ListTag contents) {
        if (contents == null) {
            return Collections.emptyList();
        }
        int count = DataHandlerUtils.getMaxId(contents, "Slot");
        ArrayList<IInventorySlot> slots = new ArrayList<IInventorySlot>(count);
        for (int i = 0; i < count; ++i) {
            slots.add(new DummyInventorySlot());
        }
        DataHandlerUtils.readContainers(slots, contents);
        return slots;
    }

    private static class DummyInventorySlot
    extends BasicInventorySlot {
        private DummyInventorySlot() {
            this(Integer.MAX_VALUE, alwaysTrue, true);
        }

        private DummyInventorySlot(int capacity, Predicate<@NonNull ItemStack> validator, boolean isBin) {
            super(capacity, alwaysTrueBi, alwaysTrueBi, validator, null, 0, 0);
            if (isBin) {
                this.obeyStackLimit = false;
            }
        }
    }
}

