/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.ingredient.chemical;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import mekanism.api.annotations.NonNull;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.infuse.InfuseType;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.chemical.pigment.Pigment;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.chemical.slurry.Slurry;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.api.recipes.ingredients.InputIngredient;
import mekanism.common.recipe.ingredient.IMultiIngredient;
import mekanism.common.recipe.ingredient.chemical.ChemicalIngredientDeserializer;
import mekanism.common.recipe.ingredient.chemical.ChemicalIngredientInfo;
import net.minecraft.network.FriendlyByteBuf;

public abstract class MultiChemicalStackIngredient<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, INGREDIENT extends ChemicalStackIngredient<CHEMICAL, STACK>>
implements ChemicalStackIngredient<CHEMICAL, STACK>,
IMultiIngredient<STACK, INGREDIENT> {
    private final INGREDIENT[] ingredients;

    @SafeVarargs
    protected MultiChemicalStackIngredient(INGREDIENT ... ingredients) {
        this.ingredients = ingredients;
    }

    protected abstract ChemicalIngredientInfo<CHEMICAL, STACK> getIngredientInfo();

    List<INGREDIENT> getIngredients() {
        return List.of(this.ingredients);
    }

    @Override
    public boolean test(@Nonnull STACK stack) {
        return Arrays.stream(this.ingredients).anyMatch(ingredient -> ingredient.test(stack));
    }

    @Override
    public boolean testType(@Nonnull STACK stack) {
        return Arrays.stream(this.ingredients).anyMatch(ingredient -> ingredient.testType(stack));
    }

    @Override
    public boolean testType(@Nonnull CHEMICAL chemical) {
        return Arrays.stream(this.ingredients).anyMatch(ingredient -> ingredient.testType(chemical));
    }

    @Override
    @Nonnull
    public STACK getMatchingInstance(@Nonnull STACK stack) {
        for (INGREDIENT ingredient : this.ingredients) {
            ChemicalStack matchingInstance = (ChemicalStack)ingredient.getMatchingInstance(stack);
            if (matchingInstance.isEmpty()) continue;
            return (STACK)matchingInstance;
        }
        return this.getIngredientInfo().getEmptyStack();
    }

    @Override
    public long getNeededAmount(@Nonnull STACK stack) {
        for (INGREDIENT ingredient : this.ingredients) {
            long amount = ingredient.getNeededAmount(stack);
            if (amount <= 0L) continue;
            return amount;
        }
        return 0L;
    }

    @Override
    public boolean hasNoMatchingInstances() {
        return Arrays.stream(this.ingredients).allMatch(InputIngredient::hasNoMatchingInstances);
    }

    @Override
    @Nonnull
    public List<@NonNull STACK> getRepresentations() {
        ArrayList<@NonNull TYPE> representations = new ArrayList();
        for (INGREDIENT ingredient : this.ingredients) {
            representations.addAll(ingredient.getRepresentations());
        }
        return representations;
    }

    @Override
    public boolean forEachIngredient(Predicate<INGREDIENT> checker) {
        boolean result = false;
        for (INGREDIENT ingredient : this.ingredients) {
            result |= checker.test(ingredient);
        }
        return result;
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.m_130068_((Enum)ChemicalIngredientDeserializer.IngredientType.MULTI);
        buffer.m_130130_(this.ingredients.length);
        for (INGREDIENT ingredient : this.ingredients) {
            ingredient.write(buffer);
        }
    }

    @Override
    @Nonnull
    public JsonElement serialize() {
        JsonArray json = new JsonArray();
        for (INGREDIENT ingredient : this.ingredients) {
            json.add(ingredient.serialize());
        }
        return json;
    }

    public static class MultiSlurryStackIngredient
    extends MultiChemicalStackIngredient<Slurry, SlurryStack, ChemicalStackIngredient.SlurryStackIngredient>
    implements ChemicalStackIngredient.SlurryStackIngredient {
        MultiSlurryStackIngredient(ChemicalStackIngredient.SlurryStackIngredient ... ingredients) {
            super((ChemicalStackIngredient[])ingredients);
        }

        @Override
        protected ChemicalIngredientInfo<Slurry, SlurryStack> getIngredientInfo() {
            return ChemicalIngredientInfo.SLURRY;
        }
    }

    public static class MultiPigmentStackIngredient
    extends MultiChemicalStackIngredient<Pigment, PigmentStack, ChemicalStackIngredient.PigmentStackIngredient>
    implements ChemicalStackIngredient.PigmentStackIngredient {
        MultiPigmentStackIngredient(ChemicalStackIngredient.PigmentStackIngredient ... ingredients) {
            super((ChemicalStackIngredient[])ingredients);
        }

        @Override
        protected ChemicalIngredientInfo<Pigment, PigmentStack> getIngredientInfo() {
            return ChemicalIngredientInfo.PIGMENT;
        }
    }

    public static class MultiInfusionStackIngredient
    extends MultiChemicalStackIngredient<InfuseType, InfusionStack, ChemicalStackIngredient.InfusionStackIngredient>
    implements ChemicalStackIngredient.InfusionStackIngredient {
        MultiInfusionStackIngredient(ChemicalStackIngredient.InfusionStackIngredient ... ingredients) {
            super((ChemicalStackIngredient[])ingredients);
        }

        @Override
        protected ChemicalIngredientInfo<InfuseType, InfusionStack> getIngredientInfo() {
            return ChemicalIngredientInfo.INFUSION;
        }
    }

    public static class MultiGasStackIngredient
    extends MultiChemicalStackIngredient<Gas, GasStack, ChemicalStackIngredient.GasStackIngredient>
    implements ChemicalStackIngredient.GasStackIngredient {
        MultiGasStackIngredient(ChemicalStackIngredient.GasStackIngredient ... ingredients) {
            super((ChemicalStackIngredient[])ingredients);
        }

        @Override
        protected ChemicalIngredientInfo<Gas, GasStack> getIngredientInfo() {
            return ChemicalIngredientInfo.GAS;
        }
    }
}

