/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network.to_client;

import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import mekanism.common.inventory.container.QIOItemViewerContainer;
import mekanism.common.lib.inventory.HashedItem;
import mekanism.common.network.IMekanismPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.network.NetworkEvent;

public class PacketQIOItemViewerGuiSync
implements IMekanismPacket {
    private final Type type;
    private final Object2LongMap<HashedItem.UUIDAwareHashedItem> itemMap;
    private final long countCapacity;
    private final int typeCapacity;

    private PacketQIOItemViewerGuiSync(Type type, Object2LongMap<HashedItem.UUIDAwareHashedItem> itemMap, long countCapacity, int typeCapacity) {
        this.type = type;
        this.itemMap = itemMap;
        this.countCapacity = countCapacity;
        this.typeCapacity = typeCapacity;
    }

    public static PacketQIOItemViewerGuiSync batch(Object2LongMap<HashedItem.UUIDAwareHashedItem> itemMap, long countCapacity, int typeCapacity) {
        return new PacketQIOItemViewerGuiSync(Type.BATCH, itemMap, countCapacity, typeCapacity);
    }

    public static PacketQIOItemViewerGuiSync update(Object2LongMap<HashedItem.UUIDAwareHashedItem> itemMap, long countCapacity, int typeCapacity) {
        return new PacketQIOItemViewerGuiSync(Type.UPDATE, itemMap, countCapacity, typeCapacity);
    }

    public static PacketQIOItemViewerGuiSync kill() {
        return new PacketQIOItemViewerGuiSync(Type.UPDATE, null, 0L, 0);
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        AbstractContainerMenu abstractContainerMenu;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null && (abstractContainerMenu = player.f_36096_) instanceof QIOItemViewerContainer) {
            QIOItemViewerContainer container = (QIOItemViewerContainer)abstractContainerMenu;
            switch (this.type) {
                case BATCH: {
                    container.handleBatchUpdate(this.itemMap, this.countCapacity, this.typeCapacity);
                    break;
                }
                case UPDATE: {
                    container.handleUpdate(this.itemMap, this.countCapacity, this.typeCapacity);
                    break;
                }
                case KILL: {
                    container.handleKill();
                }
            }
        }
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130068_((Enum)this.type);
        if (this.type == Type.BATCH || this.type == Type.UPDATE) {
            buffer.m_130103_(this.countCapacity);
            buffer.m_130130_(this.typeCapacity);
            buffer.m_130130_(this.itemMap.size());
            this.itemMap.forEach((key, value) -> {
                buffer.m_130055_(key.getStack());
                if (key.getUUID() == null) {
                    buffer.writeBoolean(false);
                } else {
                    buffer.writeBoolean(true);
                    buffer.m_130077_(key.getUUID());
                }
                buffer.m_130103_(value.longValue());
            });
        }
    }

    public static PacketQIOItemViewerGuiSync decode(FriendlyByteBuf buffer) {
        Type type = (Type)buffer.m_130066_(Type.class);
        long countCapacity = 0L;
        int typeCapacity = 0;
        Object2LongOpenHashMap map = null;
        if (type == Type.BATCH || type == Type.UPDATE) {
            countCapacity = buffer.m_130258_();
            typeCapacity = buffer.m_130242_();
            int count = buffer.m_130242_();
            map = new Object2LongOpenHashMap(count);
            for (int i = 0; i < count; ++i) {
                map.put((Object)new HashedItem.UUIDAwareHashedItem(buffer.m_130267_(), buffer.readBoolean() ? buffer.m_130259_() : null), buffer.m_130258_());
            }
        }
        return new PacketQIOItemViewerGuiSync(type, (Object2LongMap<HashedItem.UUIDAwareHashedItem>)map, countCapacity, typeCapacity);
    }

    public static enum Type {
        BATCH,
        UPDATE,
        KILL;

    }
}

