/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib.security;

import javax.annotation.Nonnull;
import mekanism.common.config.MekanismConfig;
import mekanism.common.lib.security.IOwnerItem;
import mekanism.common.lib.security.SecurityMode;
import mekanism.common.util.ItemDataUtils;
import net.minecraft.world.item.ItemStack;

public interface ISecurityItem
extends IOwnerItem {
    default public SecurityMode getSecurity(@Nonnull ItemStack stack) {
        if (!MekanismConfig.general.allowProtection.get()) {
            return SecurityMode.PUBLIC;
        }
        return SecurityMode.byIndexStatic(ItemDataUtils.getInt(stack, "securityMode"));
    }

    default public void setSecurity(@Nonnull ItemStack stack, SecurityMode mode) {
        ItemDataUtils.setInt(stack, "securityMode", mode.ordinal());
    }
}

