/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib.multiblock;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.function.ToIntFunction;
import mekanism.common.lib.math.voxel.BlockPosBuilder;
import mekanism.common.lib.math.voxel.VoxelPlane;
import mekanism.common.lib.multiblock.FormationProtocol;
import mekanism.common.lib.multiblock.IMultiblock;
import mekanism.common.lib.multiblock.IMultiblockBase;
import mekanism.common.lib.multiblock.IStructuralMultiblock;
import mekanism.common.lib.multiblock.MultiblockData;
import mekanism.common.lib.multiblock.MultiblockManager;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.ChunkAccess;

public class Structure {
    public static final Structure INVALID = new Structure();
    private final Map<BlockPos, IMultiblockBase> nodes = new Object2ObjectOpenHashMap();
    private final Map<Axis, NavigableMap<Integer, VoxelPlane>> minorPlaneMap = new EnumMap<Axis, NavigableMap<Integer, VoxelPlane>>(Axis.class);
    private final Map<Axis, NavigableMap<Integer, VoxelPlane>> planeMap = new EnumMap<Axis, NavigableMap<Integer, VoxelPlane>>(Axis.class);
    private boolean valid;
    private long updateTimestamp;
    private boolean didUpdate;
    private MultiblockData multiblockData;
    private IMultiblock<?> controller;

    private Structure() {
    }

    public Structure(IMultiblockBase node) {
        this.init(node);
        this.valid = true;
    }

    private void init(IMultiblockBase node) {
        BlockPos pos = node.getTilePos();
        this.nodes.put(pos, node);
        for (Axis axis : Axis.AXES) {
            this.getMinorAxisMap(axis).put(axis.getCoord(pos), new VoxelPlane(axis, pos, node instanceof IMultiblock));
        }
        if (node instanceof IMultiblock) {
            IMultiblock multiblock = (IMultiblock)node;
            if (this.getController() == null || multiblock.canBeMaster()) {
                this.controller = multiblock;
            }
        }
    }

    public MultiblockData getMultiblockData() {
        return this.multiblockData;
    }

    public void setMultiblockData(MultiblockData multiblockData) {
        boolean changed = this.multiblockData != multiblockData;
        this.multiblockData = multiblockData;
        if (changed) {
            for (IMultiblockBase node : this.nodes.values()) {
                node.resetForFormed();
            }
        }
    }

    public IMultiblock<?> getController() {
        return this.controller;
    }

    public MultiblockManager<?> getManager() {
        return this.getController() != null && this.valid ? this.getController().getManager() : null;
    }

    public IMultiblockBase getTile(BlockPos pos) {
        return this.nodes.get(pos);
    }

    public NavigableMap<Integer, VoxelPlane> getMinorAxisMap(Axis axis) {
        return this.minorPlaneMap.computeIfAbsent(axis, k -> new TreeMap(Integer::compare));
    }

    public NavigableMap<Integer, VoxelPlane> getMajorAxisMap(Axis axis) {
        return this.planeMap.computeIfAbsent(axis, k -> new TreeMap(Integer::compare));
    }

    public void markForUpdate(Level world, boolean invalidate) {
        this.updateTimestamp = world.m_46467_();
        this.didUpdate = false;
        if (invalidate) {
            this.invalidate(world);
        } else {
            this.removeMultiblock(world);
        }
    }

    public <TILE extends BlockEntity> void tick(TILE tile, boolean tryValidate) {
        if (!this.didUpdate && this.updateTimestamp == tile.m_58904_().m_46467_() - 1L) {
            this.didUpdate = true;
            this.runUpdate(tile);
        }
        if (tryValidate && !this.isValid()) {
            Structure.validate((IMultiblockBase)tile, (Long2ObjectMap<ChunkAccess>)new Long2ObjectOpenHashMap());
        }
    }

    public <TILE extends BlockEntity> FormationProtocol.FormationResult runUpdate(TILE tile) {
        if (this.getController() != null && this.multiblockData == null) {
            return this.getController().createFormationProtocol().doUpdate();
        }
        this.removeMultiblock(tile.m_58904_());
        return FormationProtocol.FormationResult.FAIL;
    }

    public void add(Structure s) {
        if (s != this) {
            NavigableMap<Integer, VoxelPlane> majorMap;
            NavigableMap<Integer, VoxelPlane> minorMap;
            Axis axis;
            if (s.getController() != null && s.getController().canBeMaster() && (this.getController() == null || !this.getController().canBeMaster())) {
                this.controller = s.getController();
            }
            MultiblockManager<?> manager = this.getManager();
            s.nodes.forEach((key, value) -> {
                this.nodes.put((BlockPos)key, (IMultiblockBase)value);
                value.setStructure(manager, this);
            });
            for (Map.Entry<Axis, NavigableMap<Integer, VoxelPlane>> entry : s.minorPlaneMap.entrySet()) {
                axis = entry.getKey();
                minorMap = this.getMinorAxisMap(axis);
                majorMap = this.getMajorAxisMap(axis);
                entry.getValue().forEach((key, value) -> {
                    VoxelPlane majorPlane = (VoxelPlane)majorMap.get(key);
                    if (majorPlane != null) {
                        majorPlane.merge((VoxelPlane)value);
                        return;
                    }
                    VoxelPlane minorPlane = (VoxelPlane)minorMap.get(key);
                    if (minorPlane == null) {
                        minorMap.put((Integer)key, (VoxelPlane)value);
                    } else {
                        minorPlane.merge((VoxelPlane)value);
                        if (minorPlane.hasFrame() && minorPlane.length() >= 2 && minorPlane.height() >= 2) {
                            majorMap.put((Integer)key, minorPlane);
                            minorMap.remove(key);
                        }
                    }
                });
            }
            for (Map.Entry<Axis, NavigableMap<Integer, VoxelPlane>> entry : s.planeMap.entrySet()) {
                axis = entry.getKey();
                minorMap = this.getMinorAxisMap(axis);
                majorMap = this.getMajorAxisMap(axis);
                entry.getValue().forEach((key, value) -> {
                    VoxelPlane majorPlane = (VoxelPlane)majorMap.get(key);
                    if (majorPlane == null) {
                        majorPlane = value;
                        majorMap.put((Integer)key, majorPlane);
                        VoxelPlane minorPlane = (VoxelPlane)minorMap.get(key);
                        if (minorPlane != null) {
                            majorPlane.merge(minorPlane);
                            minorMap.remove(key);
                        }
                    } else {
                        majorPlane.merge((VoxelPlane)value);
                    }
                });
            }
        }
    }

    public boolean isValid() {
        return this.valid;
    }

    public void invalidate(Level world) {
        this.removeMultiblock(world);
        this.valid = false;
    }

    public void removeMultiblock(Level world) {
        if (this.multiblockData != null) {
            this.multiblockData.remove(world);
            this.multiblockData = null;
        }
    }

    public boolean contains(BlockPos pos) {
        return this.nodes.containsKey(pos);
    }

    public int size() {
        return this.nodes.size();
    }

    private static void validate(IMultiblockBase node, Long2ObjectMap<ChunkAccess> chunkMap) {
        if (node instanceof IMultiblock) {
            IMultiblock multiblock = (IMultiblock)node;
            if (!multiblock.getStructure().isValid()) {
                multiblock.resetStructure(multiblock.getManager());
            }
        } else if (node instanceof IStructuralMultiblock) {
            node.resetStructure(null);
        }
        FormationProtocol.explore(node.getTilePos(), pos -> {
            IMultiblockBase adj;
            if (pos.equals((Object)node.getTilePos())) {
                return true;
            }
            BlockEntity tile = WorldUtils.getTileEntity((LevelAccessor)node.getTileWorld(), chunkMap, pos);
            if (tile instanceof IMultiblockBase && Structure.isCompatible(node, adj = (IMultiblockBase)tile)) {
                boolean didMerge = false;
                if (node instanceof IStructuralMultiblock && adj instanceof IStructuralMultiblock) {
                    HashSet managers = new HashSet();
                    managers.addAll(((IStructuralMultiblock)node).getStructureMap().keySet());
                    managers.addAll(((IStructuralMultiblock)adj).getStructureMap().keySet());
                    for (MultiblockManager multiblockManager : managers) {
                        didMerge = Structure.mergeIfNecessary(node, adj, multiblockManager);
                    }
                } else {
                    if (node instanceof IStructuralMultiblock) {
                        if (!Structure.hasStructure(node, (IMultiblock)adj)) {
                            Structure.validate(adj, chunkMap);
                        }
                        return false;
                    }
                    didMerge = adj instanceof IStructuralMultiblock ? Structure.mergeIfNecessary(node, adj, Structure.getManager(node)) : Structure.mergeIfNecessary(node, adj, Structure.getManager(node));
                }
                return didMerge;
            }
            return false;
        });
    }

    private static boolean hasStructure(IMultiblockBase structural, IMultiblock<?> multiblock) {
        return structural.getStructure(multiblock.getManager()) == multiblock.getStructure();
    }

    private static boolean mergeIfNecessary(IMultiblockBase node, IMultiblockBase adj, MultiblockManager<?> manager) {
        Structure adjStructure;
        Structure nodeStructure = node.getStructure(manager);
        if (!nodeStructure.isValid()) {
            nodeStructure = node.resetStructure(manager);
        }
        if (!(adjStructure = adj.getStructure(manager)).isValid()) {
            adjStructure = adj.resetStructure(manager);
        }
        if (!node.hasStructure(adjStructure)) {
            Structure changed;
            if (nodeStructure.size() >= adjStructure.size() || nodeStructure.getManager() != null && adjStructure.getManager() == null) {
                changed = nodeStructure;
                changed.add(adjStructure);
            } else {
                changed = adjStructure;
                changed.add(nodeStructure);
            }
            changed.markForUpdate(node.getTileWorld(), false);
            return true;
        }
        return false;
    }

    private static boolean isCompatible(IMultiblockBase node, IMultiblockBase other) {
        MultiblockManager<?> manager = Structure.getManager(node);
        MultiblockManager<?> otherManager = Structure.getManager(other);
        if (manager != null && otherManager != null) {
            return manager == otherManager;
        }
        if (manager == null && otherManager == null) {
            return true;
        }
        if (manager == null && node instanceof IStructuralMultiblock) {
            IStructuralMultiblock multiblock = (IStructuralMultiblock)node;
            return multiblock.canInterface(otherManager);
        }
        if (otherManager == null && other instanceof IStructuralMultiblock) {
            IStructuralMultiblock multiblock = (IStructuralMultiblock)other;
            return multiblock.canInterface(manager);
        }
        return false;
    }

    private static MultiblockManager<?> getManager(IMultiblockBase node) {
        MultiblockManager multiblockManager;
        if (node instanceof IMultiblock) {
            IMultiblock multiblock = (IMultiblock)node;
            multiblockManager = multiblock.getManager();
        } else {
            multiblockManager = null;
        }
        return multiblockManager;
    }

    public static enum Axis {
        X(Vec3i::m_123341_),
        Y(Vec3i::m_123342_),
        Z(Vec3i::m_123343_);

        private final ToIntFunction<BlockPos> posMapper;
        static final Axis[] AXES;

        private Axis(ToIntFunction<BlockPos> posMapper) {
            this.posMapper = posMapper;
        }

        public int getCoord(BlockPos pos) {
            return this.posMapper.applyAsInt(pos);
        }

        public void set(BlockPosBuilder pos, int val) {
            pos.set(this, val);
        }

        public Axis horizontal() {
            return this == X ? Z : X;
        }

        public Axis vertical() {
            return this == Y ? Z : Y;
        }

        public static Axis get(Direction side) {
            return AXES[side.m_122434_().ordinal()];
        }

        static {
            AXES = Axis.values();
        }
    }
}

