/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib.frequency;

import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.common.lib.frequency.Frequency;
import mekanism.common.lib.frequency.FrequencyType;
import mekanism.common.lib.security.IOwnerItem;
import mekanism.common.util.ItemDataUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;

public interface IFrequencyItem
extends IOwnerItem {
    @Override
    default public void setOwnerUUID(@Nonnull ItemStack stack, @Nullable UUID owner) {
        this.setFrequency(stack, null);
        IOwnerItem.super.setOwnerUUID(stack, owner);
    }

    @Nullable
    default public Frequency.FrequencyIdentity getFrequencyIdentity(ItemStack stack) {
        if (this.hasFrequency(stack)) {
            return Frequency.FrequencyIdentity.load(this.getFrequencyType(), ItemDataUtils.getCompound(stack, "frequency"));
        }
        return null;
    }

    default public boolean hasFrequency(ItemStack stack) {
        return ItemDataUtils.hasData(stack, "frequency", 10);
    }

    @Nullable
    default public Frequency getFrequency(ItemStack stack) {
        if (this.hasFrequency(stack)) {
            CompoundTag frequencyCompound = ItemDataUtils.getCompound(stack, "frequency");
            Frequency.FrequencyIdentity identity = Frequency.FrequencyIdentity.load(this.getFrequencyType(), frequencyCompound);
            if (identity != null && frequencyCompound.m_128403_("owner")) {
                return this.getFrequencyType().getManager(identity, frequencyCompound.m_128342_("owner")).getFrequency(identity.key());
            }
        }
        return null;
    }

    default public void setFrequency(ItemStack stack, Frequency frequency) {
        if (frequency == null) {
            ItemDataUtils.removeData(stack, "frequency");
        } else {
            ItemDataUtils.setCompound(stack, "frequency", frequency.serializeIdentityWithOwner());
        }
    }

    public FrequencyType<?> getFrequencyType();
}

