/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item.block;

import java.util.List;
import javax.annotation.Nonnull;
import mekanism.api.text.EnumColor;
import mekanism.common.MekanismLang;
import mekanism.common.block.interfaces.IPersonalStorage;
import mekanism.common.inventory.container.item.PersonalStorageItemContainer;
import mekanism.common.item.block.ItemBlockTooltip;
import mekanism.common.item.interfaces.IGuiItem;
import mekanism.common.item.interfaces.IItemSustainedInventory;
import mekanism.common.lib.security.ISecurityItem;
import mekanism.common.registration.impl.ContainerTypeRegistryObject;
import mekanism.common.registration.impl.ItemDeferredRegister;
import mekanism.common.registries.MekanismContainerTypes;
import mekanism.common.util.SecurityUtils;
import mekanism.common.util.text.BooleanStateDisplay;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.FakePlayer;

public class ItemBlockPersonalStorage<BLOCK extends Block & IPersonalStorage>
extends ItemBlockTooltip<BLOCK>
implements IItemSustainedInventory,
ISecurityItem,
IGuiItem {
    public ItemBlockPersonalStorage(BLOCK block) {
        super(block, true, ItemDeferredRegister.getMekBaseProperties().m_41487_(1));
    }

    @Override
    protected void addDetails(@Nonnull ItemStack stack, Level world, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flag) {
        SecurityUtils.addSecurityTooltip(stack, tooltip);
        tooltip.add((Component)MekanismLang.HAS_INVENTORY.translateColored(EnumColor.AQUA, EnumColor.GRAY, BooleanStateDisplay.YesNo.of(this.hasInventory(new Object[]{stack}))));
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(@Nonnull Level world, Player player, @Nonnull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (this.getOwnerUUID(stack) == null) {
            if (!world.f_46443_) {
                SecurityUtils.claimItem(player, stack);
            }
        } else if (SecurityUtils.canAccess(player, stack)) {
            if (!world.f_46443_) {
                this.getContainerType().tryOpenGui((ServerPlayer)player, hand, stack);
                player.m_36246_(Stats.f_12988_.m_12902_((Object)Stats.f_12968_));
            }
        } else {
            if (!world.f_46443_) {
                SecurityUtils.displayNoAccess(player);
            }
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        return InteractionResultHolder.m_19092_((Object)stack, (boolean)world.f_46443_);
    }

    @Nonnull
    public InteractionResult m_6225_(@Nonnull UseOnContext context) {
        InteractionResult result = this.m_40576_(new BlockPlaceContext(context));
        Player player = context.m_43723_();
        return result.m_19077_() || player == null ? result : this.m_7203_(context.m_43725_(), player, context.m_43724_()).m_19089_();
    }

    protected boolean m_40610_(@Nonnull BlockPlaceContext context, @Nonnull BlockState state) {
        Player player = context.m_43723_();
        return (player == null || player instanceof FakePlayer || player.m_6144_()) && super.m_40610_(context, state);
    }

    public ContainerTypeRegistryObject<PersonalStorageItemContainer> getContainerType() {
        return MekanismContainerTypes.PERSONAL_STORAGE_ITEM;
    }
}

