/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.inventory.slot;

import java.util.Objects;
import java.util.Set;
import java.util.function.BiPredicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.AutomationType;
import mekanism.api.IContentsListener;
import mekanism.api.Upgrade;
import mekanism.api.annotations.FieldsAreNonnullByDefault;
import mekanism.api.annotations.NonNull;
import mekanism.common.inventory.container.SelectedWindowData;
import mekanism.common.inventory.container.slot.SlotOverlay;
import mekanism.common.inventory.container.slot.VirtualInventoryContainerSlot;
import mekanism.common.inventory.slot.BasicInventorySlot;
import mekanism.common.item.interfaces.IUpgradeItem;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class UpgradeInventorySlot
extends BasicInventorySlot {
    public static UpgradeInventorySlot input(@Nullable IContentsListener listener, Set<Upgrade> supportedTypes) {
        Objects.requireNonNull(supportedTypes, "Supported types cannot be null");
        return new UpgradeInventorySlot(listener, (stack, automationType) -> {
            Item item = stack.m_41720_();
            if (item instanceof IUpgradeItem) {
                IUpgradeItem upgradeItem = (IUpgradeItem)item;
                Upgrade upgradeType = upgradeItem.getUpgradeType((ItemStack)stack);
                return supportedTypes.contains(upgradeType);
            }
            return false;
        });
    }

    public static UpgradeInventorySlot output(@Nullable IContentsListener listener) {
        return new UpgradeInventorySlot(listener, internalOnly);
    }

    private UpgradeInventorySlot(@Nullable IContentsListener listener, BiPredicate<@NonNull ItemStack, @NonNull AutomationType> canInsert) {
        super(manualOnly, canInsert, (ItemStack stack) -> stack.m_41720_() instanceof IUpgradeItem, listener, 0, 0);
        this.setSlotOverlay(SlotOverlay.UPGRADE);
    }

    @Override
    @Nonnull
    public VirtualInventoryContainerSlot createContainerSlot() {
        return new VirtualInventoryContainerSlot(this, new SelectedWindowData(SelectedWindowData.WindowType.UPGRADE), this.getSlotOverlay(), this::setStackUnchecked);
    }
}

