/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.base;

import java.time.LocalDate;
import java.time.Month;
import java.util.Set;
import javax.annotation.Nullable;
import mekanism.api.text.EnumColor;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.config.MekanismConfig;
import mekanism.common.registration.impl.SoundEventRegistryObject;
import mekanism.common.registries.MekanismSounds;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Range;

public final class HolidayManager {
    public static final Holiday CHRISTMAS = new Christmas();
    public static final Holiday NEW_YEAR = new NewYear();
    public static final Holiday MAY_4 = new May4();
    public static final Holiday APRIL_FOOLS = new AprilFools();
    private static final Set<Holiday> holidays = Set.of(CHRISTMAS, NEW_YEAR, MAY_4, APRIL_FOOLS);

    public static void init() {
        LocalDate time = LocalDate.now();
        YearlyDate date = new YearlyDate(time.getMonth(), time.getDayOfMonth());
        for (Holiday holiday : holidays) {
            holiday.updateIsToday(date);
        }
        Mekanism.logger.info("Initialized HolidayManager.");
    }

    public static void notify(Player player) {
        if (MekanismConfig.client.holidays.get()) {
            for (Holiday holiday : holidays) {
                if (!holiday.isToday() || holiday.hasNotified()) continue;
                holiday.notify(player);
            }
        }
    }

    public static SoundEventRegistryObject<SoundEvent> filterSound(SoundEventRegistryObject<SoundEvent> sound) {
        if (MekanismConfig.client.holidays.get()) {
            for (Holiday holiday : holidays) {
                if (!holiday.isToday()) continue;
                return holiday.filterSound(sound);
            }
        }
        return sound;
    }

    private static String getThemedLines(int amount, EnumColor ... colors) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < amount; ++i) {
            builder.append(colors[i % colors.length]).append("-");
        }
        return builder.toString();
    }

    public record YearlyDate(Month month, @Range(from=1L, to=31L) int day) {
    }

    public static abstract class Holiday {
        private final YearlyDate date;
        private boolean hasNotified;
        private boolean isToday;

        protected Holiday(YearlyDate date) {
            this.date = date;
        }

        public YearlyDate getDate() {
            return this.date;
        }

        protected boolean checkIsToday(YearlyDate date) {
            return this.getDate().equals(date);
        }

        @Nullable
        protected HolidayMessage getMessage(Player player) {
            return null;
        }

        public SoundEventRegistryObject<SoundEvent> filterSound(SoundEventRegistryObject<SoundEvent> sound) {
            return sound;
        }

        private boolean hasNotified() {
            return this.hasNotified;
        }

        private void notify(Player player) {
            HolidayMessage message = this.getMessage(player);
            if (message != null) {
                player.m_6352_((Component)MekanismLang.HOLIDAY_BORDER.translate(message.themedLines, EnumColor.DARK_BLUE, MekanismLang.GENERIC_SQUARE_BRACKET.translate(MekanismLang.MEKANISM)), Util.f_137441_);
                for (Component line : message.lines) {
                    player.m_6352_(line, Util.f_137441_);
                }
                player.m_6352_((Component)MekanismLang.HOLIDAY_BORDER.translate(message.themedLines, EnumColor.DARK_BLUE, "[=======]"), Util.f_137441_);
            }
            this.hasNotified = true;
        }

        private void updateIsToday(YearlyDate date) {
            this.isToday = this.checkIsToday(date);
            if (!this.isToday) {
                this.hasNotified = false;
            }
        }

        public boolean isToday() {
            return this.isToday;
        }
    }

    private static class Christmas
    extends Holiday {
        private Christmas() {
            super(new YearlyDate(Month.DECEMBER, 25));
        }

        @Override
        @Nullable
        protected HolidayMessage getMessage(Player player) {
            return new HolidayMessage(HolidayManager.getThemedLines(13, EnumColor.DARK_GREEN, EnumColor.DARK_RED), new Component[]{MekanismLang.CHRISTMAS_LINE_ONE.translateColored(EnumColor.RED, EnumColor.DARK_BLUE, player.m_7755_()), MekanismLang.CHRISTMAS_LINE_TWO.translateColored(EnumColor.RED, new Object[0]), MekanismLang.CHRISTMAS_LINE_THREE.translateColored(EnumColor.RED, new Object[0]), MekanismLang.CHRISTMAS_LINE_FOUR.translateColored(EnumColor.RED, new Object[0]), MekanismLang.HOLIDAY_SIGNATURE.translateColored(EnumColor.DARK_GRAY, new Object[0])});
        }

        @Override
        public SoundEventRegistryObject<SoundEvent> filterSound(SoundEventRegistryObject<SoundEvent> sound) {
            if (sound == MekanismSounds.ENRICHMENT_CHAMBER) {
                return MekanismSounds.CHRISTMAS1;
            }
            if (sound == MekanismSounds.METALLURGIC_INFUSER) {
                return MekanismSounds.CHRISTMAS2;
            }
            if (sound == MekanismSounds.PURIFICATION_CHAMBER) {
                return MekanismSounds.CHRISTMAS3;
            }
            if (sound == MekanismSounds.ENERGIZED_SMELTER) {
                return MekanismSounds.CHRISTMAS4;
            }
            if (sound == MekanismSounds.CRUSHER) {
                return MekanismSounds.CHRISTMAS5;
            }
            return super.filterSound(sound);
        }
    }

    private static class NewYear
    extends Holiday {
        private NewYear() {
            super(new YearlyDate(Month.JANUARY, 1));
        }

        @Override
        @Nullable
        protected HolidayMessage getMessage(Player player) {
            return new HolidayMessage(HolidayManager.getThemedLines(13, EnumColor.WHITE, EnumColor.YELLOW), new Component[]{MekanismLang.NEW_YEAR_LINE_ONE.translateColored(EnumColor.AQUA, EnumColor.DARK_BLUE, player.m_7755_()), MekanismLang.NEW_YEAR_LINE_TWO.translateColored(EnumColor.AQUA, new Object[0]), MekanismLang.NEW_YEAR_LINE_THREE.translateColored(EnumColor.AQUA, LocalDate.now().getYear()), MekanismLang.HOLIDAY_SIGNATURE.translateColored(EnumColor.DARK_GRAY, new Object[0])});
        }
    }

    private static class May4
    extends Holiday {
        private May4() {
            super(new YearlyDate(Month.MAY, 4));
        }

        @Override
        @Nullable
        protected HolidayMessage getMessage(Player player) {
            return new HolidayMessage(HolidayManager.getThemedLines(15, EnumColor.BLACK, EnumColor.GRAY, EnumColor.BLACK, EnumColor.YELLOW, EnumColor.BLACK), new Component[]{MekanismLang.MAY_4_LINE_ONE.translateColored(EnumColor.GRAY, EnumColor.DARK_BLUE, player.m_7755_())});
        }
    }

    private static class AprilFools
    extends Holiday {
        private AprilFools() {
            super(new YearlyDate(Month.APRIL, 1));
        }
    }

    private record HolidayMessage(String themedLines, Component[] lines) {
    }
}

