/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import java.util.ArrayList;
import mekanism.api.MekanismAPI;
import mekanism.api.gear.IHUDElement;
import mekanism.api.text.ILangEntry;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.MekanismLang;
import mekanism.common.config.MekanismConfig;
import mekanism.common.content.gear.HUDElement;
import mekanism.common.item.gear.ItemMekaSuitArmor;
import mekanism.common.item.gear.ItemMekaTool;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.StorageUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class HUDRenderer {
    private static final ResourceLocation HEAD_ICON = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_HUD, "hud_mekasuit_helmet.png");
    private static final ResourceLocation CHEST_ICON = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_HUD, "hud_mekasuit_chest.png");
    private static final ResourceLocation LEGS_ICON = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_HUD, "hud_mekasuit_leggings.png");
    private static final ResourceLocation BOOTS_ICON = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_HUD, "hud_mekasuit_boots.png");
    private static final ResourceLocation TOOL_ICON = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_HUD, "hud_mekatool.png");
    private static final ResourceLocation COMPASS = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "compass.png");
    private long lastTick = -1L;
    private float prevRotationYaw;
    private float prevRotationPitch;
    private final Minecraft minecraft = Minecraft.m_91087_();

    public void renderHUD(PoseStack matrix, float partialTick) {
        this.update();
        if (MekanismConfig.client.hudOpacity.get() < 0.05f) {
            return;
        }
        int color = HUDElement.HUDColor.REGULAR.getColorARGB();
        matrix.m_85836_();
        float yawJitter = -HUDRenderer.absSqrt(this.minecraft.f_91074_.f_20885_ - this.prevRotationYaw);
        float pitchJitter = -HUDRenderer.absSqrt(this.minecraft.f_91074_.m_146909_() - this.prevRotationPitch);
        matrix.m_85837_((double)yawJitter, (double)pitchJitter, 0.0);
        if (MekanismConfig.client.hudCompassEnabled.get()) {
            this.renderCompass(matrix, partialTick, color);
        }
        this.renderMekaSuitEnergyIcons(matrix, partialTick, color);
        this.renderMekaSuitModuleIcons(matrix, partialTick, color);
        matrix.m_85849_();
    }

    private void update() {
        if (this.lastTick == -1L || this.minecraft.f_91073_.m_46467_() - this.lastTick > 1L) {
            this.prevRotationYaw = this.minecraft.f_91074_.m_146908_();
            this.prevRotationPitch = this.minecraft.f_91074_.m_146909_();
        }
        this.lastTick = this.minecraft.f_91073_.m_46467_();
        float yawDiff = this.minecraft.f_91074_.f_20885_ - this.prevRotationYaw;
        float pitchDiff = this.minecraft.f_91074_.m_146909_() - this.prevRotationPitch;
        this.prevRotationYaw += yawDiff / MekanismConfig.client.hudJitter.get();
        this.prevRotationPitch += pitchDiff / MekanismConfig.client.hudJitter.get();
    }

    private static float absSqrt(float val) {
        float ret = (float)Math.sqrt(Math.abs(val));
        return val < 0.0f ? -ret : ret;
    }

    private void renderMekaSuitEnergyIcons(PoseStack matrix, float partialTick, int color) {
        matrix.m_85836_();
        matrix.m_85837_(10.0, 10.0, 0.0);
        int posX = 0;
        posX += this.renderEnergyIcon(matrix, posX, color, HEAD_ICON, EquipmentSlot.HEAD);
        posX += this.renderEnergyIcon(matrix, posX, color, CHEST_ICON, EquipmentSlot.CHEST);
        posX += this.renderEnergyIcon(matrix, posX, color, LEGS_ICON, EquipmentSlot.LEGS);
        posX += this.renderEnergyIcon(matrix, posX, color, BOOTS_ICON, EquipmentSlot.FEET);
        posX += this.renderEnergyIcon(matrix, posX, color, TOOL_ICON, EquipmentSlot.MAINHAND);
        this.renderEnergyIcon(matrix, posX, color, TOOL_ICON, EquipmentSlot.OFFHAND);
        matrix.m_85849_();
    }

    private int renderEnergyIcon(PoseStack matrix, int posX, int color, ResourceLocation icon, EquipmentSlot slot) {
        ItemStack stack = this.getStack(slot);
        if (stack.m_41720_() instanceof ItemMekaSuitArmor || stack.m_41720_() instanceof ItemMekaTool) {
            this.renderHUDElement(matrix, posX, 0, MekanismAPI.getModuleHelper().hudElementPercent(icon, StorageUtils.getEnergyRatio(stack)), color, false);
            return 48;
        }
        return 0;
    }

    private void renderMekaSuitModuleIcons(PoseStack matrix, float partialTick, int color) {
        Item item;
        ItemStack stack;
        ArrayList elements = new ArrayList();
        for (EquipmentSlot type : EnumUtils.ARMOR_SLOTS) {
            stack = this.getStack(type);
            item = stack.m_41720_();
            if (!(item instanceof ItemMekaSuitArmor)) continue;
            ItemMekaSuitArmor armor = (ItemMekaSuitArmor)item;
            elements.addAll(armor.getHUDElements((Player)this.minecraft.f_91074_, stack));
        }
        for (EquipmentSlot type : EnumUtils.HAND_SLOTS) {
            stack = this.getStack(type);
            item = stack.m_41720_();
            if (!(item instanceof ItemMekaTool)) continue;
            ItemMekaTool tool = (ItemMekaTool)item;
            elements.addAll(tool.getHUDElements((Player)this.minecraft.f_91074_, stack));
        }
        int startX = this.minecraft.m_91268_().m_85445_() - 10;
        int curY = this.minecraft.m_91268_().m_85446_() - 10;
        matrix.m_85836_();
        for (IHUDElement element : elements) {
            int elementWidth = 24 + this.minecraft.f_91062_.m_92852_((FormattedText)element.getText());
            this.renderHUDElement(matrix, startX - elementWidth, curY -= 18, element, color, true);
        }
        matrix.m_85849_();
    }

    private void renderHUDElement(PoseStack matrix, int x, int y, IHUDElement element, int color, boolean iconRight) {
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        MekanismRenderer.color(color);
        RenderSystem.m_157456_((int)0, (ResourceLocation)element.getIcon());
        if (!iconRight) {
            GuiComponent.m_93133_((PoseStack)matrix, (int)x, (int)y, (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
            MekanismRenderer.resetColor();
            this.minecraft.f_91062_.m_92889_(matrix, element.getText(), (float)(x + 18), (float)(y + 5), element.getColor());
        } else {
            GuiComponent.m_93133_((PoseStack)matrix, (int)(x + this.minecraft.f_91062_.m_92852_((FormattedText)element.getText()) + 2), (int)y, (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
            MekanismRenderer.resetColor();
            this.minecraft.f_91062_.m_92889_(matrix, element.getText(), (float)x, (float)(y + 5), element.getColor());
        }
    }

    private void renderCompass(PoseStack matrix, float partialTick, int color) {
        matrix.m_85836_();
        int posX = 25;
        int posY = this.minecraft.m_91268_().m_85446_() - 100;
        matrix.m_85837_((double)(posX + 50), (double)(posY + 50), 0.0);
        matrix.m_85836_();
        float angle = 180.0f - Mth.m_14179_((float)partialTick, (float)this.minecraft.f_91074_.f_20886_, (float)this.minecraft.f_91074_.f_20885_);
        matrix.m_85836_();
        matrix.m_85841_(0.7f, 0.7f, 0.7f);
        TranslatableComponent coords = MekanismLang.GENERIC_BLOCK_POS.translate((int)this.minecraft.f_91074_.m_20185_(), (int)this.minecraft.f_91074_.m_20186_(), (int)this.minecraft.f_91074_.m_20189_());
        this.minecraft.f_91062_.m_92889_(matrix, (Component)coords, (float)(-this.minecraft.f_91062_.m_92852_((FormattedText)coords)) / 2.0f, -4.0f, color);
        matrix.m_85849_();
        matrix.m_85845_(Vector3f.f_122223_.m_122240_(-60.0f));
        matrix.m_85845_(Vector3f.f_122227_.m_122240_(angle));
        RenderSystem.m_157456_((int)0, (ResourceLocation)COMPASS);
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        MekanismRenderer.color(color);
        GuiComponent.m_93160_((PoseStack)matrix, (int)-50, (int)-50, (int)100, (int)100, (float)0.0f, (float)0.0f, (int)256, (int)256, (int)256, (int)256);
        this.rotateStr(matrix, MekanismLang.NORTH_SHORT, angle, 0.0f, color);
        this.rotateStr(matrix, MekanismLang.EAST_SHORT, angle, 90.0f, color);
        this.rotateStr(matrix, MekanismLang.SOUTH_SHORT, angle, 180.0f, color);
        this.rotateStr(matrix, MekanismLang.WEST_SHORT, angle, 270.0f, color);
        MekanismRenderer.resetColor();
        matrix.m_85849_();
        matrix.m_85849_();
    }

    private void rotateStr(PoseStack matrix, ILangEntry langEntry, float rotation, float shift, int color) {
        matrix.m_85836_();
        matrix.m_85845_(Vector3f.f_122227_.m_122240_(shift));
        matrix.m_85837_(0.0, -50.0, 0.0);
        matrix.m_85845_(Vector3f.f_122227_.m_122240_(-rotation - shift));
        this.minecraft.f_91062_.m_92889_(matrix, (Component)langEntry.translate(new Object[0]), -2.5f, -4.0f, color);
        matrix.m_85849_();
    }

    private ItemStack getStack(EquipmentSlot type) {
        return this.minecraft.f_91074_.m_6844_(type);
    }
}

