/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.chemical.attribute;

import java.util.Set;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.attribute.ChemicalAttribute;

public interface ChemicalAttributeValidator {
    public static final ChemicalAttributeValidator DEFAULT = attr -> !attr.needsValidation();
    public static final ChemicalAttributeValidator ALWAYS_ALLOW = attr -> true;

    public boolean validate(ChemicalAttribute var1);

    public static boolean process(Chemical<?> chemical, ChemicalAttributeValidator validator) {
        return chemical.getAttributes().stream().allMatch(validator::validate);
    }

    public static boolean process(ChemicalStack<?> stack, ChemicalAttributeValidator validator) {
        return ChemicalAttributeValidator.process(stack.getType(), validator);
    }

    @SafeVarargs
    public static ChemicalAttributeValidator create(Class<? extends ChemicalAttribute> ... validAttributes) {
        return new SimpleAttributeValidator(validAttributes, true);
    }

    @SafeVarargs
    public static ChemicalAttributeValidator createStrict(Class<? extends ChemicalAttribute> ... validAttributes) {
        return new SimpleAttributeValidator(validAttributes, false);
    }

    public static class SimpleAttributeValidator
    implements ChemicalAttributeValidator {
        private final Set<Class<? extends ChemicalAttribute>> validTypes;
        private final boolean allowNoValidation;

        SimpleAttributeValidator(Class<? extends ChemicalAttribute>[] attributeTypes, boolean allowNoValidation) {
            this.validTypes = Set.of(attributeTypes);
            this.allowNoValidation = allowNoValidation;
        }

        @Override
        public boolean validate(ChemicalAttribute attribute) {
            return this.validTypes.contains(attribute.getClass()) || this.allowNoValidation && !attribute.needsValidation();
        }
    }
}

