/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.survival.world.level.block;

import java.util.Random;
import java.util.function.BooleanSupplier;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class LootGeneratorBlock
extends AirBlock {
    private final Supplier<Block> lootBlock;
    private final Supplier<? extends ParticleOptions> particleOptions;
    private final IntSupplier refreshDelayTicks;
    private final BooleanSupplier enabled;

    public LootGeneratorBlock(BlockBehaviour.Properties properties, Supplier<Block> lootBlock, Supplier<? extends ParticleOptions> particleOptions, IntSupplier refreshDelayTicks, BooleanSupplier enabled) {
        super(properties);
        this.lootBlock = lootBlock;
        this.particleOptions = particleOptions;
        this.refreshDelayTicks = refreshDelayTicks;
        this.enabled = enabled;
    }

    public RenderShape m_7514_(BlockState blockState) {
        return RenderShape.INVISIBLE;
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0);
    }

    public void m_7100_(BlockState blockState, Level level, BlockPos pos, Random random) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91072_.m_105295_() == GameType.CREATIVE) {
            level.m_7106_(this.particleOptions.get(), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 0.0, 0.0, 0.0);
        }
    }

    public BlockState m_7417_(BlockState blockState, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        level.m_186460_(pos, (Block)this, 0);
        return super.m_7417_(blockState, direction, neighborState, level, pos, neighborPos);
    }

    public void m_7458_(BlockState blockState, ServerLevel level, BlockPos pos, Random random) {
        super.m_7458_(blockState, level, pos, random);
        if (!this.enabled.getAsBoolean()) {
            return;
        }
        level.m_186460_(pos, (Block)this, this.refreshDelayTicks.getAsInt());
        BlockState lootBlockState = this.lootBlock.get().m_49966_();
        boolean lootExists = level.m_45556_(new AABB(pos.m_142127_().m_142125_(), pos.m_142128_().m_142126_())).anyMatch(lootBlockState::equals);
        if (!lootExists) {
            if (level.m_46859_(pos.m_142127_())) {
                level.m_46597_(pos.m_142127_(), lootBlockState);
            } else if (level.m_46859_(pos.m_142126_())) {
                level.m_46597_(pos.m_142126_(), lootBlockState);
            } else if (level.m_46859_(pos.m_142128_())) {
                level.m_46597_(pos.m_142128_(), lootBlockState);
            } else if (level.m_46859_(pos.m_142125_())) {
                level.m_46597_(pos.m_142125_(), lootBlockState);
            }
        }
    }
}

