/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.survival.world.entity;

import com.craftingdead.survival.world.entity.SurvivalEntityTypes;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;

public class SupplyDrop
extends Entity
implements MenuProvider {
    private SimpleContainer inventory = new SimpleContainer(54);
    @Nullable
    private ResourceLocation lootTable;
    private long lootTableSeed;

    public SupplyDrop(EntityType<?> entityType, Level world) {
        super(entityType, world);
    }

    public SupplyDrop(EntityType<?> entityType, Level world, ResourceLocation lootTable, long lootTableSeed, double x, double y, double z) {
        this(entityType, world);
        this.lootTable = lootTable;
        this.lootTableSeed = lootTableSeed;
        this.m_6034_(x, y, z);
        this.m_20256_(Vec3.f_82478_);
        this.f_19854_ = x;
        this.f_19855_ = y;
        this.f_19856_ = z;
    }

    public SupplyDrop(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType)SurvivalEntityTypes.SUPPLY_DROP.get(), world);
    }

    protected void m_8097_() {
    }

    public void m_8119_() {
        super.m_6075_();
        if (!this.m_20068_()) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, -0.009, 0.0));
        }
        if (this.f_19861_) {
            this.m_20256_(this.m_20184_().m_82490_(0.5));
        }
        this.m_6478_(MoverType.SELF, this.m_20184_());
    }

    public void m_142687_(Entity.RemovalReason reason) {
        if (!this.f_19853_.m_5776_() && reason.m_146965_()) {
            Containers.m_18998_((Level)this.f_19853_, (Entity)this, (Container)this.inventory);
        }
        super.m_142687_(reason);
    }

    protected void m_7378_(CompoundTag compound) {
        if (compound.m_128425_("lootTable", 8)) {
            this.lootTable = new ResourceLocation(compound.m_128461_("lootTable"));
            this.lootTableSeed = compound.m_128454_("lootTableSeed");
        } else if (compound.m_128441_("inventory")) {
            NonNullList items = NonNullList.m_122780_((int)this.inventory.m_6643_(), (Object)ItemStack.f_41583_);
            ContainerHelper.m_18980_((CompoundTag)compound.m_128469_("inventory"), (NonNullList)items);
            this.inventory = new SimpleContainer((ItemStack[])items.toArray((Object[])new ItemStack[0]));
        }
    }

    protected void m_7380_(CompoundTag compound) {
        if (this.lootTable != null) {
            compound.m_128359_("lootTable", this.lootTable.toString());
            if (this.lootTableSeed != 0L) {
                compound.m_128356_("lootTableSeed", this.lootTableSeed);
            }
        } else {
            NonNullList items = NonNullList.m_122780_((int)this.inventory.m_6643_(), (Object)ItemStack.f_41583_);
            for (int i = 0; i < this.inventory.m_6643_(); ++i) {
                items.set(i, (Object)this.inventory.m_8020_(i));
            }
            compound.m_128365_("inventory", (Tag)ContainerHelper.m_18973_((CompoundTag)compound.m_128469_("inventory"), (NonNullList)items));
        }
    }

    public boolean m_6087_() {
        return true;
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public InteractionResult m_7111_(Player player, Vec3 vec, InteractionHand hand) {
        player.m_5893_((MenuProvider)this);
        return InteractionResult.PASS;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (!this.f_19853_.f_46443_ && this.m_6084_()) {
            if (this.m_6673_(source)) {
                return false;
            }
            this.m_6074_();
            return true;
        }
        return true;
    }

    private void addLoot(@Nullable Player player) {
        if (this.lootTable != null && this.f_19853_.m_142572_() != null) {
            LootTable lootTable = this.f_19853_.m_142572_().m_129898_().m_79217_(this.lootTable);
            this.lootTable = null;
            LootContext.Builder builder = new LootContext.Builder((ServerLevel)this.f_19853_).m_78972_(LootContextParams.f_81460_, (Object)this.m_20182_()).m_78965_(this.lootTableSeed);
            builder.m_78972_(LootContextParams.f_81458_, (Object)this);
            if (player != null) {
                builder.m_78963_(player.m_36336_()).m_78972_(LootContextParams.f_81455_, (Object)player);
            }
            lootTable.m_79123_((Container)this.inventory, builder.m_78975_(LootContextParamSets.f_81411_));
        }
    }

    public AbstractContainerMenu m_7208_(int id, Inventory playerInventory, Player playerEntity) {
        this.addLoot(playerEntity);
        return ChestMenu.m_39246_((int)id, (Inventory)playerInventory, (Container)this.inventory);
    }
}

