/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.survival.world.effect;

import com.craftingdead.core.world.item.ModItems;
import com.craftingdead.survival.world.damagesource.SurvivalDamageSource;
import com.craftingdead.survival.world.item.SurvivalItems;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.RegistryObject;

public class BleedingMobEffect
extends MobEffect {
    private static final int MAXIMUM_DELAY = 120;
    private static final int MINIMUM_DELAY = 10;
    private static final int DELAY_REDUCTION_PER_LEVEL = 20;

    protected BleedingMobEffect() {
        super(MobEffectCategory.HARMFUL, 0x8B0000);
    }

    public void m_6742_(LivingEntity livingEntity, int amplifier) {
        if (livingEntity.m_21223_() > 1.0f) {
            livingEntity.m_6469_(SurvivalDamageSource.BLEEDING, 1.0f);
        }
    }

    public boolean m_6584_(int duration, int amplifier) {
        int ticksBetweenHits = 120 - amplifier * 20;
        return duration % Math.max(ticksBetweenHits, 10) == 0;
    }

    public List<ItemStack> getCurativeItems() {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        items.add(new ItemStack(() -> ((RegistryObject)ModItems.BANDAGE).get()));
        items.add(new ItemStack(() -> SurvivalItems.CLEAN_RAG.get()));
        items.add(new ItemStack(() -> ((RegistryObject)ModItems.FIRST_AID_KIT).get()));
        return items;
    }
}

